/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFilePlanHelper;
import kd.wtc.wtp.business.attfile.AttFileServiceImpl;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleBusiness;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleCheckHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.opplugin.web.attfile.validator.AttFileScheduleValidate;

public class AttFileScheduleOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(AttFileScheduleOp.class);
    private static final String INVALID_VALUE = "0";

    public void onAddValidators(AddValidatorsEventArgs args) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleOp.onAddValidators start ...");
        }
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new AttFileScheduleValidate());
        if (ArrayUtils.isEmpty((Object[])args.getDataEntities())) {
            return;
        }
        if (this.getOption().getVariables().containsKey("importtag_of_datasource") && !AttFileScheduleEnum.getIsTimeHisByPageId((String)args.getDataEntities()[0].getDataEntityType().getName())) {
            Arrays.stream(args.getDataEntities()).forEach(dataEntity -> dataEntity.set("boid", null));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleOp.onAddValidators end ...");
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        String pageId = this.billEntityType.getName();
        List<String> propertyList = Arrays.asList("startdate", "enddate", "busistatus", "boid", "attfileid", "attfilevid", "iscurrentversion", "datastatus", "ismodify", "sourcevid", "hisversion", "description", "org", "attendstatus", "busistatus");
        args.getFieldKeys().add(AttFileScheduleEnum.getScheduleKeyByPageId((String)pageId));
        args.getFieldKeys().addAll(propertyList);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        args.setCancelOperation(true);
        DynamicObject[] dataEntities = args.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        String operationKey = args.getOperationKey();
        long mainBoId = DB.genGlobalLongId();
        String eventIdStr = (String)this.getOption().getVariables().get("event");
        if (WTCStringUtils.isNotEmpty((String)eventIdStr)) {
            mainBoId = Long.parseLong(eventIdStr);
        }
        switch (operationKey) {
            case "save": 
            case "saverule": {
                this.saveOp(dataEntities, operationKey, mainBoId);
                Map variableMap = this.getOption().getVariables();
                String isBillSave = (String)variableMap.get("is_bill_save");
                if (!"is_bill_save_value".equals(isBillSave)) break;
                this.unsyncDataFromDB(dataEntities);
                break;
            }
            case "deletehis": {
                this.deleteOp(dataEntities);
                break;
            }
            case "invalid": {
                this.setBusistatus(dataEntities);
                this.saveOp(dataEntities, operationKey, mainBoId);
                break;
            }
        }
    }

    private void unsyncDataFromDB(DynamicObject[] dataEntities) {
        if (ArrayUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        dataEntities[0].set("id", (Object)0L);
    }

    private void setBusistatus(DynamicObject[] dataEntities) {
        for (DynamicObject info : dataEntities) {
            info.set("busistatus", (Object)INVALID_VALUE);
        }
    }

    private void saveOp(DynamicObject[] dataEntities, String operationKey, long mainBoId) {
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleOp.saveOp start ...");
        }
        Set attFileBoIdSet = Arrays.stream(dataEntities).map(dy -> dy.getLong("attfileid.id")).collect(Collectors.toSet());
        Map variableMap = this.getOption().getVariables();
        AttFileScheduleServiceImpl instance = AttFileScheduleServiceImpl.getInstance();
        List attFileIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.get("attfilevid.id")).collect(Collectors.toList());
        List fileDys = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id, atttag.attendstatus", attFileIdList);
        Map<Long, Object> fileMap = fileDys.stream().collect(Collectors.toMap(fileDy -> fileDy.getLong("id"), fileDy -> fileDy.get("atttag.attendstatus")));
        Arrays.stream(dataEntities).forEach(dataEntity -> dataEntity.set("attendstatus", fileMap.get(dataEntity.getLong("attfilevid.id"))));
        ArrayList timeHisDyList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        ArrayList notTimeHisDyList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dataEntity2 : dataEntities) {
            if (AttFileScheduleEnum.getIsTimeHisByPageId((String)dataEntity2.getDataEntityType().getName().replace("_dg", ""))) {
                timeHisDyList.add(dataEntity2);
                continue;
            }
            notTimeHisDyList.add(dataEntity2);
        }
        if (!CollectionUtils.isEmpty((Collection)timeHisDyList)) {
            List dataList = AttFileScheduleBusiness.getSyncRosterParam((DynamicObject[])dataEntities);
            instance.addAttFileBaseSchedule(timeHisDyList.toArray(new DynamicObject[0]), Long.valueOf(mainBoId));
            String errMsg = "";
            if (WTCCollections.isNotEmpty((Collection)dataList)) {
                boolean async = Boolean.parseBoolean(this.getOption().getVariableValue("importtag_of_datasource", "false"));
                Set attFileBoIds = dataList.stream().map(map -> (String)map.get("attFileBoId")).map(Long::parseLong).collect(Collectors.toSet());
                errMsg = AttFileScheduleBusiness.validateWsSchedule(attFileBoIds);
                AttFileScheduleBusiness.fileSyncRoster((boolean)async, (List)dataList, (Map)this.getOption().getVariables());
            }
            Set checkParam = AttFileScheduleCheckHelper.getInstance().getCheckParam(dataEntities);
            String periodErrMsg = AttFileScheduleCheckHelper.getInstance().attPeriodSerialCheck(checkParam);
            if (HRStringUtils.isNotEmpty((String)periodErrMsg)) {
                errMsg = HRStringUtils.isNotEmpty((String)errMsg) ? String.join((CharSequence)"\n", errMsg, periodErrMsg) : periodErrMsg;
            }
            if (HRStringUtils.isNotEmpty((String)errMsg)) {
                this.getOption().setVariableValue("errMsg", errMsg);
            }
            String importType = (String)this.getOption().getVariables().get("importtype");
            Map<Long, Long> fileBoIdAndPersonIdMap = Arrays.stream(dataEntities).filter(dy -> dy.getDataEntityType().getName().startsWith(AttFileScheduleEnum.PERIOD.getPageId())).collect(Collectors.toMap(dy -> dy.getLong("attfileid.id"), dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"attfileid.attperson"), (a, b) -> a));
            PerAttPeriodDataService.getInstance().processPerAttPeriod(HRStringUtils.isEmpty((String)importType) ? null : "3", fileBoIdAndPersonIdMap);
        }
        if (!CollectionUtils.isEmpty((Collection)notTimeHisDyList)) {
            Map variables = this.getOption().getVariables();
            String importType = (String)variables.get("importtype");
            if (!"invalid".equals(operationKey)) {
                List newList;
                Map cutNotTimeHisDyMap = AttFilePlanHelper.cutSchedulePlanList((List)notTimeHisDyList, attFileBoIdSet);
                List importList = (List)cutNotTimeHisDyMap.get("importList");
                if (HRCollUtil.isNotEmpty((Collection)importList)) {
                    instance.addAttFileRuleSchedule(importList.toArray(new DynamicObject[0]), Long.valueOf(mainBoId), (String)variableMap.get("isAddNew"), importType);
                }
                if (HRCollUtil.isNotEmpty((Collection)(newList = (List)cutNotTimeHisDyMap.get("newList")))) {
                    instance.addAttFileRuleSchedule(newList.toArray(new DynamicObject[0]), Long.valueOf(mainBoId), "true", null);
                }
            } else {
                instance.addAttFileRuleSchedule(notTimeHisDyList.toArray(new DynamicObject[0]), Long.valueOf(mainBoId), (String)variableMap.get("isAddNew"), importType);
            }
        }
        Set fileBoIds = Arrays.stream(dataEntities).map(schedule -> schedule.getLong("attfileid.id")).collect(Collectors.toSet());
        List attFileByFileList = AttFileHelper.getAttFileByFileBoId(fileBoIds, (boolean)false);
        Set<String> attFileScheduleEnumName = Arrays.stream(dataEntities).map(dy -> dy.getDataEntityType().getName()).collect(Collectors.toSet());
        Set<AttFileScheduleEnum> updateScheduleEnumSet = this.getAttFileScheduleEnumByName(attFileScheduleEnumName);
        AttFileServiceImpl.getInstance().cutAllBaseAndRuleSchedule(attFileByFileList, updateScheduleEnumSet, Long.valueOf(mainBoId), true);
        if (LOG.isInfoEnabled()) {
            LOG.info("AttFileScheduleOp.saveOp end ...");
        }
    }

    private Set<AttFileScheduleEnum> getAttFileScheduleEnumByName(Set<String> attFileScheduleEnumName) {
        HashSet attFileScheduleEnumSet = Sets.newHashSetWithExpectedSize((int)attFileScheduleEnumName.size());
        attFileScheduleEnumName.forEach(name -> {
            AttFileScheduleEnum onlyUpdateScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)name);
            attFileScheduleEnumSet.add(onlyUpdateScheduleEnum);
        });
        return attFileScheduleEnumSet;
    }

    private void callSyncRosterDataInterface(DynamicObject[] dataEntities, Map<Long, List<DynamicObject>> attFileBoIdWsListMap) {
        HashMap attFileIdAndWSIDMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        for (DynamicObject dy : dataEntities) {
            List<DynamicObject> wsList;
            Long wsId;
            if (!dy.getDataEntityType().getName().startsWith(AttFileScheduleEnum.WS.getPageId()) || (wsId = Long.valueOf(dy.getLong("attfileid.id"))).equals(0L) || !CollectionUtils.isEmpty(wsList = attFileBoIdWsListMap.get(dy.getLong("attfileid.id")))) continue;
            attFileIdAndWSIDMap.put(dy.getLong("attfilevid.id"), dy.getLong(AttFileScheduleEnum.WS.getKey() + "." + "id"));
        }
        if (WTCMaps.isNotEmpty((Map)attFileIdAndWSIDMap)) {
            WTCServiceHelper.invokeWtcWtsBizService((String)"IScheduleService", (String)"syncRosterData", (Object[])new Object[]{attFileIdAndWSIDMap});
        }
    }

    private void deleteOp(DynamicObject[] dataEntities) {
        AttFileScheduleServiceImpl instance = AttFileScheduleServiceImpl.getInstance();
        instance.deleteOp(dataEntities);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        OperationResult operationResult = this.getOperationResult();
        OperationResult operationResult1 = this.getOperationResult();
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        OperationResult operationResult = this.getOperationResult();
        OperationResult operationResult1 = this.getOperationResult();
    }
}

