/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.license.CertControlType;
import kd.wtc.wtbs.business.license.CertService;
import kd.wtc.wtp.business.attfile.cert.AttFileCertService;

public class AttFileBaseAddCertValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(AttFileBaseAddCertValidator.class);
    StringBuilder sbOfCertMsg;

    public AttFileBaseAddCertValidator(StringBuilder sbOfCertMsg) {
        this.sbOfCertMsg = sbOfCertMsg;
    }

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        logger.info("AttFileBaseAddCertValidator size:{}", (Object)dataEntities.length);
        List files = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        List needAddCert = AttFileCertService.getAddCertDealId(files);
        Map checkMap = CertService.certControl((String)"wtp", (String)"wtp_attfilebase", (List)needAddCert, (CertControlType)CertControlType.VALIDATORANDAPPLYCHECK);
        logger.info("AttFileBaseAddCertValidator needAddCert:{} checkMap:{}", (Object)needAddCert.size(), (Object)checkMap);
        Map msg = (Map)checkMap.get("msg");
        String showMessageType = (String)msg.get("showMessageType");
        if (HRStringUtils.equals((String)String.valueOf(checkMap.get("isforbidden")), (String)"true")) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.addFatalErrorMessage(dataEntity, (String)msg.get("message"));
            }
            this.sbOfCertMsg.append((String)msg.get("message"));
        }
        if (HRStringUtils.equals((String)String.valueOf(msg.get("showMessage")), (String)"true") && "2".equals(showMessageType)) {
            this.sbOfCertMsg.append((String)msg.get("message"));
        }
    }
}

