/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.common.model.file.FileSaveDto;

public class AttFileBaseAdjustValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String fileCoreDataVo = (String)this.getOption().getVariables().get("fileCoreDataVo");
        if (HRStringUtils.isNotEmpty((String)fileCoreDataVo)) {
            FileSaveDto fileSaveDto = (FileSaveDto)SerializationUtils.fromJsonString((String)fileCoreDataVo, FileSaveDto.class);
            String discardResultStr = AttFileHelper.checkAttFileIsDiscard((Long)fileSaveDto.getBoId());
            if (WTCStringUtils.isNotEmpty((String)discardResultStr)) {
                this.addFatalErrorMessage(this.dataEntities[0], discardResultStr);
                return;
            }
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List checkData = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map errMap = new HashMap(16);
        Map variables = this.getOption().getVariables();
        String boId = (String)variables.get("op_org_variables");
        if (WTCStringUtils.isNotEmpty((String)boId) && !CollectionUtils.isEmpty(checkData)) {
            String discardResultStr = AttFileHelper.checkAttFileIsDiscard((Long)Long.parseLong(boId));
            if (WTCStringUtils.isNotEmpty((String)discardResultStr)) {
                this.addFatalErrorMessage(dataEntities[0], discardResultStr);
                return;
            }
            String orgId = ((DynamicObject)checkData.get(0)).getString("org.id");
            if (WTCStringUtils.isEmpty((String)orgId)) {
                String orgNull = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u65b0\u7684\u8003\u52e4\u7ba1\u7406\u7ec4\u7ec7\u3002", (String)"AttFileBaseAdjustValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                Arrays.stream(dataEntities).forEach(dataEntity -> this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, orgNull));
                return;
            }
            Map adjustShowErrMap = AttFileCheckService.getInstance().checkAdjustShow(Collections.singletonList(Long.parseLong(boId)));
            errMap = AttFileCheckService.getInstance().checkAdjust(Long.valueOf(Long.parseLong(orgId)), Collections.singletonList(Long.parseLong(boId)));
            errMap.putAll(adjustShowErrMap);
        }
        if (null != errMap && errMap.size() > 0) {
            for (Map.Entry entry : errMap.entrySet()) {
                for (ExtendedDataEntity dataEntity2 : dataEntities) {
                    List errMsgList = (List)errMap.get(entry.getKey());
                    String msg = String.join((CharSequence)"\n", errMsgList);
                    this.addFatalErrorMessage(dataEntity2, msg);
                }
            }
        }
    }
}

