/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.business.attfile.AttFileDiscardCheckService;
import kd.wtc.wtp.common.model.file.AttFileDiscardCheckModel;

public class AttFileBaseDiscardValidator
extends HRDataBaseValidator {
    private AttFileDiscardCheckModel attFileDiscardCheckModel;

    public AttFileBaseDiscardValidator(AttFileDiscardCheckModel attFileDiscardCheckModel) {
        this.attFileDiscardCheckModel = attFileDiscardCheckModel;
    }

    public void validate() {
        super.validate();
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        List dataEntities = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map checkResults = AttFileDiscardCheckService.getInstance().checkDiscardFile(dataEntities, this.attFileDiscardCheckModel, this.getOption());
        for (int i = 0; i < extendedDataEntities.length; ++i) {
            ExtendedDataEntity extendedDataEntity = extendedDataEntities[i];
            Long boid = extendedDataEntity.getDataEntity().getLong("boid");
            List tipsList = (List)checkResults.get(boid);
            if (!WTCCollections.isNotEmpty((Collection)tipsList)) continue;
            for (String tips : tipsList) {
                this.addFatalErrorMessage(extendedDataEntity, tips);
            }
        }
    }
}

