/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileModifyCheckService;

public class AttFileBaseModifyValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.resetDataEntityFileStatusValue(dataEntities);
        this.checkAttFileIsDiscard(dataEntities);
        List checkData = Arrays.stream(dataEntities).filter(dataEntity -> !"-1".equals(dataEntity.getDataEntity().getString("usablestatus"))).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        HashMap customMap = Maps.newHashMapWithExpectedSize((int)16);
        customMap.putAll(this.getOption().getVariables());
        Map integerSetMap = AttFileModifyCheckService.getInstance().checkModifyFile(checkData, (Map)customMap);
        for (int i = 0; i < dataEntities.length; ++i) {
            List list;
            ExtendedDataEntity extendedDataEntity = dataEntities[i];
            boolean isDiscardFile = "-1".equals(extendedDataEntity.getDataEntity().getString("usablestatus"));
            if (isDiscardFile) continue;
            Map variables = this.getOption().getVariables();
            if (variables.containsKey("importEmpPoOrgRelFailList") && (list = JSONObject.parseArray((String)((String)variables.get("importEmpPoOrgRelFailList")), Long.class)) != null && list.contains(extendedDataEntity.getBillPkId())) {
                String tips = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u6216\u5c97\u4f4d\u4e0e\u5458\u5de5\u4efb\u804c\u7ecf\u5386\u4fe1\u606f\u4e0d\u5339\u914d\u3002", (String)"AttFileBaseModifyValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(extendedDataEntity, tips);
                continue;
            }
            Set tipsSet = (Set)integerSetMap.get(i);
            if (!WTCCollections.isNotEmpty((Collection)tipsSet)) continue;
            for (String tips : tipsSet) {
                this.addFatalErrorMessage(extendedDataEntity, tips);
            }
        }
    }

    private void checkAttFileIsDiscard(ExtendedDataEntity[] dataEntities) {
        String tips = ResManager.loadKDString((String)"\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AttFileBaseModifyValidator_01", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            String usableStatus = dy.getString("usablestatus");
            if (!"-1".equals(usableStatus)) continue;
            this.addFatalErrorMessage(dataEntity, String.format(tips, dy.getString("number")));
        }
    }

    private void resetDataEntityFileStatusValue(ExtendedDataEntity[] dataEntities) {
        Set set = Arrays.stream(dataEntities).map(ExtendedDataEntity::getBillPkId).collect(Collectors.toSet());
        List dys = AttFileQueryServiceImpl.getInstance().queryAttFileByIds("id, usablestatus", new ArrayList(set));
        if (CollectionUtils.isEmpty((Collection)dys)) {
            return;
        }
        Map<Long, String> map = dys.stream().collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy.getString("usablestatus"), (a, b) -> a));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject currentDy = dataEntity.getDataEntity();
            long pkValue = currentDy.getLong("id");
            String usableStatus = map.get(pkValue);
            if (pkValue == 0L || !HRStringUtils.isNotEmpty((String)usableStatus)) continue;
            currentDy.set("usablestatus", (Object)usableStatus);
        }
    }
}

