/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDateTimeUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.model.attendperson.AttendPersonCurrResult;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.DataBaseValidatorService;
import kd.wtc.wtbs.business.web.attendperson.AttendPersonSynService;
import kd.wtc.wtbs.business.web.mservice.HRPIMServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.file.FileTypeEnum;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileCoreDataService;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFileModifyCheckService;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.file.FileCoreDataVo;
import kd.wtc.wtp.common.model.file.FileSaveDto;

public class AttFileBaseSaveValidator
extends HRDataBaseValidator {
    private static final Log logger = LogFactory.getLog(AttFileBaseSaveValidator.class);
    private Map<String, String> numberErrMsgMap = null;
    private Map<Long, FileSaveDto> depempToFileCoreDataVo;
    private static final Log LOG = LogFactory.getLog(AttFileBaseSaveValidator.class);

    private void initQueryList(ExtendedDataEntity[] dataEntities, List<Map<String, Object>> queryList) {
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject data = dataEntity.getDataEntity();
            AttFileHelper.getDepQueryParamList((List)queryList, (DynamicObject)data);
        });
    }

    public void validate() {
        boolean checkFlag;
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ExtendedDataEntity dataEntity = dataEntities[0];
        Map variables = this.getOption().getVariables();
        if (variables.containsKey("fileCoreDataVo")) {
            FileCoreDataVo fileCoreDataVo;
            String variableValue = this.getOption().getVariableValue("fileCoreDataVo");
            FileCoreDataVo fileCoreDataVo2 = fileCoreDataVo = StringUtils.isEmpty((CharSequence)variableValue) ? null : (FileCoreDataVo)SerializationUtils.fromJsonString((String)variableValue, FileCoreDataVo.class);
            if (fileCoreDataVo != null) {
                this.depempToFileCoreDataVo = fileCoreDataVo.getDepempToFileCoreDataVo();
            }
        }
        LOG.info("AttFileBaseSaveValidator before validate importtag_of_datasource = {}", (Object)this.getOption().getVariables().containsKey("importtag_of_datasource"));
        boolean bl = checkFlag = variables.containsKey("importtag_of_datasource") && dataEntity.getDataEntity().getDate("bsed") == null;
        if (LOG.isInfoEnabled() && null != dataEntity.getDataEntity()) {
            AttFileHelper.logAttFileField((DynamicObject)dataEntity.getDataEntity(), (String)"validate", (Log)LOG);
        }
        if (checkFlag) {
            ArrayList queryList = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
            this.initQueryList(dataEntities, queryList);
            Map[] resMap = this.importDataSet(dataEntities, queryList);
            this.numberErrMsgMap = resMap[0];
            this.depempToFileCoreDataVo = resMap[1];
        } else if (this.depempToFileCoreDataVo == null) {
            List empPosOrgRelIdList = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getLong("empposorgrel.id")).collect(Collectors.toList());
            this.depempToFileCoreDataVo = AttFileCoreDataService.getInstance().getFileSaveDtoMapByEmpIds(empPosOrgRelIdList);
        }
        List personIds = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("person.id")).collect(Collectors.toList());
        DynamicObject file = dataEntity.getDataEntity();
        int count = (int)Arrays.stream(dataEntities).filter(d -> d.getDataEntity() != null && HRStringUtils.isEmpty((String)d.getDataEntity().getString("number"))).count();
        String[] batchNumber = CodeRuleServiceHelper.getBatchNumber((String)"wtp_attfilebase", (DynamicObject)file, null, (int)count);
        if (count > 0 && (batchNumber == null || batchNumber.length != count)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6863\u6848\u7f16\u7801\u89c4\u5219\uff0c\u751f\u6210\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"AttFileBaseSaveValidator_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        for (int i = 0; i < dataEntities.length; ++i) {
            DynamicObject fileEntity = dataEntities[i].getDataEntity();
            if (fileEntity == null || !HRStringUtils.isEmpty((String)fileEntity.getString("number"))) continue;
            fileEntity.set("number", (Object)batchNumber[i]);
        }
        Set periodSets = Arrays.stream(dataEntities).map(dy -> dy.getDataEntity().getLong("period.id")).collect(Collectors.toSet());
        HRBaseServiceHelper attPeriodHelper = new HRBaseServiceHelper("wtp_attperiod");
        Map<Long, DynamicObject> periodMap = Arrays.stream(attPeriodHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", periodSets)})).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (aa, bb) -> aa));
        List fileDyList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        HashMap cardCheckErrMap = Maps.newHashMapWithExpectedSize((int)dataEntities.length);
        AttFileHelper.checkCard(fileDyList, (Map)cardCheckErrMap, (boolean)true, (boolean)true);
        for (int index = 0; index < dataEntities.length; ++index) {
            String errMsg;
            ExtendedDataEntity entity = dataEntities[index];
            if (!WTCMaps.isNotEmpty((Map)cardCheckErrMap) || !WTCStringUtils.isNotEmpty((String)(errMsg = (String)cardCheckErrMap.get(String.valueOf(index))))) continue;
            this.addFatalErrorMessage(entity, errMsg);
        }
        List empPosIds = Arrays.stream(dataEntities).map(data -> data.getDataEntity().getLong("hrpiempposorgrel.id")).collect(Collectors.toList());
        AttendPersonCurrResult attendPersonCurrResult = AttendPersonSynService.getInstance().checkAndGetPersonData(personIds, empPosIds, null);
        List attendPersonCurrModels = attendPersonCurrResult.getAttendPersonCurrModels();
        Map<Long, String> personDataMap = attendPersonCurrModels.stream().collect(Collectors.toMap(dy -> dy.getPerson().getBid(), dy -> dy.getPerson().getNumber(), (a, b) -> a));
        HashMap cusMap = Maps.newHashMapWithExpectedSize((int)16);
        cusMap.put("sourcetype", this.getOption().getVariables().get("sourcetype"));
        Map stringSetMap = AttFileCheckService.getInstance().checkAddAttFile(this.depempToFileCoreDataVo, fileDyList, true, (Map)cusMap);
        this.validatorHelper(periodMap, personDataMap, stringSetMap);
    }

    private void validatorHelper(Map<Long, DynamicObject> periodMap, Map<Long, String> personDataMap, Map<Integer, Set<String>> errSetMap) {
        Set personSetIds = Arrays.stream(this.dataEntities).map(dy -> dy.getDataEntity().getLong("person.id")).collect(Collectors.toSet());
        int size = personSetIds.size();
        List queryParam = Lists.newArrayListWithExpectedSize((int)size);
        List fileDyList = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        long[] temBoIds = ID.genLongIds((int)fileDyList.size());
        HashMap checkWsMap = Maps.newHashMapWithExpectedSize((int)fileDyList.size());
        HRBaseServiceHelper wsSchBaseServiceHelper = new HRBaseServiceHelper(AttFileScheduleEnum.WS.getPageId());
        Date maxEndDate = WTCHisServiceHelper.getMaxEndDate();
        for (int i = 0; i < fileDyList.size(); ++i) {
            DynamicObject fileCheckDy = (DynamicObject)fileDyList.get(i);
            long temBoId = temBoIds[i];
            fileCheckDy.set("boid", (Object)temBoId);
            DynamicObject wsSchDy = wsSchBaseServiceHelper.generateEmptyDynamicObject();
            wsSchDy.set("bsed", (Object)fileCheckDy.getDate("bsed"));
            wsSchDy.set("bsled", (Object)maxEndDate);
            wsSchDy.set(AttFileScheduleEnum.WS.getKey(), (Object)WTCDynamicObjectUtils.getBaseDataId((DynamicObject)fileCheckDy, (String)AttFileScheduleEnum.WS.getKey()));
            checkWsMap.put(temBoId, wsSchDy);
        }
        if (!checkWsMap.isEmpty()) {
            Set employeeIds = fileDyList.stream().map(dy -> dy.getLong("employee.id")).collect(Collectors.toSet());
            Map checkFileMap = fileDyList.stream().collect(Collectors.toMap(dy -> dy.getLong("employee.id"), Function.identity(), (a, b) -> a));
            queryParam = AttFileCheckService.getInstance().getWsOverlapQueryParam(employeeIds, (Map)checkWsMap, checkFileMap);
        }
        Map shiftIfOverlapReturnMap = (Map)WTCServiceHelper.invokeWtcWtsBizService((String)"IScheduleService", (String)"isShiftPeriodOverlap", (Object[])new Object[]{queryParam});
        LOG.info("errSetMap : {}; dataEntities size : {}; dataEntities personId : {}", new Object[]{JSON.toJSONString(errSetMap), this.dataEntities.length, JSON.toJSONString(Arrays.stream(this.dataEntities).map(dy -> dy.getDataEntity().getLong("person_id")).collect(Collectors.toList()))});
        for (int i = 0; i < this.dataEntities.length; ++i) {
            long empPosOrgRelId;
            Set<String> errSet;
            String currentNumberErrMsg;
            ExtendedDataEntity entity = this.dataEntities[i];
            DynamicObject checkDataEntity = entity.getDataEntity();
            DynamicObject person = checkDataEntity.getDynamicObject("person");
            if (this.numberErrMsgMap != null && HRStringUtils.isNotEmpty((String)(currentNumberErrMsg = this.numberErrMsgMap.get(person.getString("number"))))) {
                this.addFatalErrorMessage(entity, currentNumberErrMsg);
                continue;
            }
            if (errSetMap != null && !errSetMap.isEmpty() && !CollectionUtils.isEmpty(errSet = errSetMap.get(i))) {
                errSet.remove("showNewConfirm");
                for (String errMsg : errSet) {
                    this.addFatalErrorMessage(entity, errMsg);
                }
            }
            this.checkCard(checkDataEntity, entity);
            long l = empPosOrgRelId = checkDataEntity.get("hrpiempposorgrel") instanceof Long ? checkDataEntity.getLong("hrpiempposorgrel") : checkDataEntity.getLong("hrpiempposorgrel.id");
            if (0L == empPosOrgRelId) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u4eba\u5458\u4efb\u804c\u7ecf\u5386\uff0c\u8bf7\u786e\u8ba4\u4eba\u5458\u662f\u5426\u5df2\u79bb\u804c\u3002", (String)"AttFileBaseSaveValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!personDataMap.containsKey(checkDataEntity.getLong("person.id"))) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u4eba\u5458\u6570\u636e\u5f02\u5e38\uff0c\u65e0\u6cd5\u751f\u6210\u6863\u6848\u3002", (String)"AttFileBaseSaveValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            this.checkAttPeriod(checkDataEntity, periodMap, entity);
            this.checkWSSIfOverlap(entity, checkDataEntity, shiftIfOverlapReturnMap);
        }
        List checkDataList = Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map errMap = AttFileModifyCheckService.getInstance().checkAttPersonOtherInfo(checkDataList);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String errMsg = (String)errMap.get(i);
            if (!HRStringUtils.isNotEmpty((String)errMsg)) continue;
            this.addFatalErrorMessage(this.dataEntities[i], errMsg);
        }
    }

    private void checkCard(DynamicObject checkDataEntity, ExtendedDataEntity entity) {
        String mode;
        if (checkDataEntity.getLong("attperson.id") == 0L) {
            checkDataEntity.set("attperson", (Object)checkDataEntity.getLong("person.id"));
        }
        if (FileTypeEnum.VCFILE.getFileType().equals(checkDataEntity.getString("type"))) {
            return;
        }
        String card = checkDataEntity.getString("card");
        String cardMsg = DataBaseValidatorService.checkCard((String)card, (Boolean)AttFileHelper.getCardIsMustInput((String)(mode = checkDataEntity.getString("mode"))));
        if (HRStringUtils.isNotEmpty((String)cardMsg)) {
            this.addFatalErrorMessage(entity, cardMsg);
        }
    }

    private void checkAttPeriod(DynamicObject checkDataEntity, Map<Long, DynamicObject> periodMap, ExtendedDataEntity entity) {
        Date begin = checkDataEntity.getDate("bsed");
        long periodId = checkDataEntity.getLong("period.id");
        if (periodId != 0L) {
            DynamicObject dynamicObject = periodMap.get(periodId);
            DynamicObjectCollection attPeriodEntryList = dynamicObject.getDynamicObjectCollection("attperiodentry");
            if (CollectionUtils.isEmpty((Collection)attPeriodEntryList)) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u4e0d\u80fd\u9009\u62e9\u8003\u52e4\u671f\u95f4\u4e3a\u7a7a\u7684\u8003\u52e4\u5468\u671f\u3002", (String)"AttFileBaseSaveValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                return;
            }
            attPeriodEntryList.sort(Comparator.comparing(ao -> ao.getDate("begindate")));
            Date attPeriodEntryDate = ((DynamicObject)attPeriodEntryList.get(0)).getDate("begindate");
            if (attPeriodEntryDate.getTime() > begin.getTime()) {
                String message = ResManager.loadKDString((String)"\u6240\u9009\u8003\u52e4\u5468\u671f\u6700\u65e9\u7684\u8003\u52e4\u671f\u95f4\u5f00\u59cb\u65e5\u671f\u4e3a%1$s\uff0c\u672c\u6b21\u8f93\u5165\u7684\u5f00\u59cb\u65e5\u671f\u65e9\u4e8e%2$s\uff0c\u4f1a\u5bfc\u81f4%3$s\u81f3%4$s\u671f\u95f4\u65e0\u6cd5\u51fa\u8003\u52e4\u7ed3\u679c\uff0c\u8bf7\u5148\u53bb\u7ef4\u62a4\u8003\u52e4\u5468\u671f\u3002", (String)"AttFileBaseSaveValidator_4", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                Date attPeriodEntryDateLess = HRDateTimeUtils.addDay((Date)attPeriodEntryDate, (long)-1L);
                String formatAttPeriodEntryDate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attPeriodEntryDate);
                String formatAttFileDate = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)begin);
                String attPeriodEntryDateLessStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)attPeriodEntryDateLess);
                message = String.format(Locale.ROOT, message, formatAttPeriodEntryDate, formatAttPeriodEntryDate, formatAttFileDate, attPeriodEntryDateLessStr);
                this.addFatalErrorMessage(entity, message);
            }
        }
    }

    private Map[] importDataSet(ExtendedDataEntity[] dataEntities, List<Map<String, Object>> queryList) {
        Map[] resMap = new Map[2];
        Map numberDepEmpMap = HRPIMServiceImpl.getInstance().listDepEmpInfo(queryList);
        if (WTCCollections.isEmpty((Map)numberDepEmpMap)) {
            throw new KDBizException("position init failed");
        }
        int size = numberDepEmpMap.size();
        HashMap numberDepEmpIdMap = Maps.newHashMapWithExpectedSize((int)size);
        HashMap queryMap = Maps.newHashMapWithExpectedSize((int)queryList.size());
        queryList.forEach(item -> queryMap.put((String)item.get("number"), item));
        HashMap numberEntityMap = Maps.newHashMapWithExpectedSize((int)size);
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            numberEntityMap.put(((DynamicObject)dynamicObject.get("person")).getString("number"), dataEntity);
        });
        ArrayList depEmpIdList = Lists.newArrayListWithExpectedSize((int)size);
        HashMap numberErrMsgMap = Maps.newHashMapWithExpectedSize((int)size);
        numberDepEmpMap.forEach((key, value) -> {
            Object position = ((ExtendedDataEntity)numberEntityMap.get(key)).getDataEntity().get("position");
            if (position != null) {
                String positionName = ((DynamicObject)position).getString("name");
                if (value.size() == 1) {
                    depEmpIdList.add(((DynamicObject)value.get(0)).getLong("id"));
                } else if (value.size() > 1) {
                    if (((Map)queryMap.get(key)).get("adminorg") == null) {
                        numberErrMsgMap.put(key, AttFileKDString.getHaveManyPositionErrTips((Object[])new Object[]{positionName}));
                    } else {
                        String adminOrgName = ((DynamicObject)((ExtendedDataEntity)numberEntityMap.get(key)).getDataEntity().get("adminorg")).getString("name");
                        numberErrMsgMap.put(key, AttFileKDString.getInTheAdminOrgSameHaveManyPositionErrTips((Object[])new Object[]{adminOrgName, positionName}));
                    }
                } else if (((Map)queryMap.get(key)).get("adminorg") == null) {
                    numberErrMsgMap.put(key, AttFileKDString.getNoPositionErrTips((Object[])new Object[]{positionName}));
                } else {
                    String adminOrgName = ((DynamicObject)((ExtendedDataEntity)numberEntityMap.get(key)).getDataEntity().get("adminorg")).getString("name");
                    numberErrMsgMap.put(key, AttFileKDString.getInTheAdminOrgAndPositionHaveNoPositionErrTips((Object[])new Object[]{adminOrgName, positionName}));
                }
            }
        });
        QFilter qFilter = new QFilter("depemp.id", "in", (Object)depEmpIdList);
        DynamicObject[] empOrgRelArr = HRPIMServiceImpl.getInstance().listFieldsFilterInfo("id,depemp", qFilter, "hrpi_empposorgrel");
        ArrayList empOrgRelIdList = Lists.newArrayListWithExpectedSize((int)size);
        Arrays.stream(empOrgRelArr).forEach(item -> empOrgRelIdList.add((Long)item.get("id")));
        Map fileSaveDtoMap = AttFileCoreDataService.getInstance().getFileSaveDtoMapByEmpIds((List)empOrgRelIdList);
        Arrays.stream(empOrgRelArr).forEach(empOrgRel -> {
            Long depEmpId = (Long)empOrgRel.get("depemp.id");
            numberDepEmpMap.forEach((key, value) -> {
                if (value != null && value.size() > 0 && depEmpId.equals(((DynamicObject)value.get(0)).getLong("id"))) {
                    numberDepEmpIdMap.put(key, depEmpId);
                }
            });
        });
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            DynamicObject fileDy = dataEntity2.getDataEntity();
            DynamicObject person = fileDy.getDynamicObject("person");
            String number = person.getString("number");
            String errMsg = (String)numberErrMsgMap.get(number);
            if (HRStringUtils.isEmpty((String)errMsg)) {
                Long depEmpId = (Long)numberDepEmpIdMap.get(number);
                FileSaveDto fileSaveDto = (FileSaveDto)fileSaveDtoMap.get(depEmpId);
                if (fileSaveDto != null) {
                    AttFileCoreDataService.getInstance().initFileByFileSaveDto(fileSaveDto, fileDy, null);
                }
                fileDy.set("enddate", (Object)WTCHisServiceHelper.getMaxEndDate());
                fileDy.set("bsed", (Object)fileDy.getDate("startdate"));
                continue;
            }
            fileDy.set("enddate", (Object)WTCHisServiceHelper.getMaxEndDate());
            fileDy.set("bsed", (Object)WTCHisServiceHelper.getMaxEndDate());
        }
        resMap[0] = numberErrMsgMap;
        resMap[1] = fileSaveDtoMap;
        return resMap;
    }

    private void checkWSSIfOverlap(ExtendedDataEntity dataEntity, DynamicObject attFile, Map<String, Boolean> shiftIfOverlapReturnMap) {
        long fileBoId;
        Boolean ifOverlap;
        long wsId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attFile, (String)AttFileScheduleEnum.WS.getKey());
        if (wsId != 0L && (ifOverlap = shiftIfOverlapReturnMap.get((fileBoId = attFile.getLong("boid")) + "_" + wsId)) != null && ifOverlap.booleanValue()) {
            Date bsedDate = attFile.getDate("bsed");
            String bsedDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)bsedDate);
            Date beforeBsedDate = HRDateTimeUtils.addDay((Date)bsedDate, (long)-1L);
            String beforeBsedDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)beforeBsedDate);
            this.addFatalErrorMessage(dataEntity, AttFileKDString.getShiftPeriodOverlapTips((String)beforeBsedDateStr, (String)bsedDateStr));
        }
    }
}

