/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtp.business.attfile.AttFilePlanHelper;

public class AttFileRulePlanValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(AttFileRulePlanValidator.class);

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("invalid".equals(operateKey)) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        LOG.info("AttFileBasePersonValidator size:{}", (Object)dataEntities.length);
        List dataList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map planMap = AttFilePlanHelper.genRulePlanMap((String)"1", dataList);
        Map errMsgMap = AttFilePlanHelper.validatePlan((String)"1", dataList, (Map)planMap);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject attFile = dataEntity.getDataEntity();
            List errMsgList = (List)errMsgMap.get((Long)attFile.getPkValue());
            if (HRCollUtil.isEmpty((Collection)errMsgList)) continue;
            for (String errMsg : errMsgList) {
                this.addFatalErrorMessage(dataEntity, errMsg);
            }
        }
    }
}

