/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateInfo;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.business.web.wtte.sysparam.AttRecordParamService;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.enums.AttModeEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtbs.common.util.WTCMaps;
import kd.wtc.wtbs.common.util.WTCOrgUnitServiceHelper;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtte.common.model.AttRecordParam;
import kd.wtc.wtp.business.attfile.AttFileHelper;
import kd.wtc.wtp.business.attfile.AttFileModifyCheckService;
import kd.wtc.wtp.business.attfile.AttFilePlanHelper;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleBusiness;
import kd.wtc.wtp.business.attfile.schedule.AttFileScheduleCheckHelper;
import kd.wtc.wtp.business.attstateinfo.AttStateInfoService;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.attstateinfo.AttStateInfoBO;

public class AttFileScheduleValidate
extends AbstractValidator {
    private static Log LOG = LogFactory.getLog(AttFileScheduleValidate.class);
    private static final Set<String> timeSeqPageIdSet = Sets.newHashSet((Object[])new String[]{AttFileScheduleEnum.WS.getPageId() + "_dg", AttFileScheduleEnum.PERIOD.getPageId() + "_dg", AttFileScheduleEnum.MODE.getPageId() + "_dg", AttFileScheduleEnum.CARD.getPageId() + "_dg", AttFileScheduleEnum.TZ.getPageId() + "_dg"});
    private static final Set<String> noTimeSeqPageIdSet = Sets.newHashSet((Object[])new String[]{AttFileScheduleEnum.VP.getPageId() + "_dg", AttFileScheduleEnum.TP.getPageId() + "_dg", AttFileScheduleEnum.OTP.getPageId() + "_dg", AttFileScheduleEnum.EX.getPageId() + "_dg", AttFileScheduleEnum.AD.getPageId() + "_dg", AttFileScheduleEnum.IDP.getPageId() + "_dg", AttFileScheduleEnum.ATT.getPageId() + "_dg", AttFileScheduleEnum.QT.getPageId() + "_dg", AttFileScheduleEnum.FM.getPageId() + "_dg", AttFileScheduleEnum.SWSHIFT.getPageId() + "_dg"});
    private static final Set<String> modeSet = Sets.newHashSet((Object[])new String[]{AttModeEnum.NO_CARD.getCode(), AttModeEnum.ONES_CARD.getCode(), AttModeEnum.MANY_CARD.getCode()});

    public void validate() {
        String operateKey = this.getOperateKey();
        List<Long> attFileIdList = Arrays.stream(this.dataEntities).filter(info -> info.getDataEntity() != null).map(info -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)info.getDataEntity(), (String)"attfileid")).collect(Collectors.toList());
        List attStateInfoBOS = AttStateInfoService.getInstance().queryAttStateInfoByBoid(attFileIdList);
        Map<Long, AttStateInfoBO> frozeAllInfoMap = attStateInfoBOS.stream().collect(Collectors.toMap(AttStateInfoBO::getFileBoid, Function.identity(), (oldValue, newValue) -> oldValue));
        if ("invalid".equals(operateKey)) {
            for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                DynamicObject dataEntity2 = extendedDataEntity.getDataEntity();
                Date date = dataEntity2.getDate("startdate");
                Long attFileBoId = dataEntity2.getLong("attfileid.id");
                AttStateInfoBO attStateInfoBO = (AttStateInfoBO)frozeAllInfoMap.get(attFileBoId);
                if (attStateInfoBO == null) continue;
                Date lockTo = attStateInfoBO.getLockTo();
                Date frozenEnDate = attStateInfoBO.getFronzenEnDate();
                if (lockTo != null && !date.after(lockTo)) {
                    this.addFatalErrorMessage(extendedDataEntity, AttFileKDString.getFileSchLockTips((String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)lockTo)));
                    continue;
                }
                if (frozenEnDate == null || date.after(frozenEnDate)) continue;
                this.addFatalErrorMessage(extendedDataEntity, AttFileKDString.getFileSchLockTips((String)WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)frozenEnDate)));
            }
            return;
        }
        this.checkAttFileIsDiscard(this.getDataEntities());
        List dataList = Arrays.stream(this.dataEntities).filter(dataEntity -> !this.isAttFileDiscard(dataEntity.getDataEntity())).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        this.validatePlanSchedule(this.dataEntities, operateKey);
        HashSet<Long> attFileIdSet = new HashSet<Long>(attFileIdList);
        List<DynamicObject> attFileDyList = this.queryAttFile(attFileIdSet, false, "id,boid,name,number,bsed,bsled,startdate,enddate,firstbsed,atttag,atttag.attendstatus,iscurrentversion,person.id,employee.id");
        List<DynamicObject> hasAuthAttFileDyList = this.queryAttFile(attFileIdSet, true, null);
        LOG.info("AttFileScheduleValidate before validate importtag_of_datasource = {}", (Object)this.getOption().getVariables().containsKey("importtag_of_datasource"));
        HashMap fileBoIdMsgMap = Maps.newHashMapWithExpectedSize((int)16);
        if (WTCCollections.isEmpty((Map)this.getOption().getVariables()) || !"fromcoordination".equals(this.getOption().getVariables().get("fromcoordination"))) {
            fileBoIdMsgMap.putAll(AttFileHelper.checkAttFileVersionAuth((DynamicObject[])((DynamicObject[])Arrays.stream(this.dataEntities).map(ExtendedDataEntity::getDataEntity).toArray(DynamicObject[]::new)), hasAuthAttFileDyList, (int)1, (boolean)this.getOption().getVariables().containsKey("importtag_of_datasource")));
        }
        Map<Long, DynamicObject> attFileDyMap = attFileDyList.stream().collect(Collectors.toMap(attFileDy -> attFileDy.getLong("id"), Function.identity(), (oldValue, newValue) -> oldValue));
        Map<Long, List<DynamicObject>> attFileGroupMap = attFileDyList.stream().collect(Collectors.groupingBy(info -> info.getLong("boid")));
        Set pageStrSet = Arrays.stream(this.dataEntities).map(info -> info.getDataEntity().getDataEntityType().getName()).collect(Collectors.toSet());
        AttFileScheduleQueryParam queryParam = new AttFileScheduleQueryParam();
        queryParam.setqFilter(new QFilter("attfileid", "in", attFileIdSet));
        queryParam.setLoad(Boolean.TRUE);
        HashMap scheduleDyMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
        HashMap scheduleEnumDyGroupMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
        for (String pageStr2 : pageStrSet) {
            AttFileScheduleEnum attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)pageStr2);
            List scheduleDyList = AttFileScheduleServiceImpl.getInstance().queryAttFileScheduleByList(attFileScheduleEnum, queryParam);
            scheduleDyMap.putAll(scheduleDyList.stream().filter(scheduleDy -> scheduleDy.getBoolean("iscurrentversion")).collect(Collectors.toMap(scheduleDy -> scheduleDy.getLong("id"), Function.identity(), (oldValue, newValue) -> oldValue)));
            Map<Long, List<DynamicObject>> scheduleDyGroupMap = scheduleDyList.stream().collect(Collectors.groupingBy(info -> info.getLong("attfileid.id")));
            scheduleEnumDyGroupMap.put(pageStr2, scheduleDyGroupMap);
        }
        this.switchWsWarn(scheduleEnumDyGroupMap);
        Map<Long, Date> storageMap = attStateInfoBOS.stream().filter(arg -> arg.getLockTo() != null).collect(Collectors.toMap(AttStateInfoBO::getFileBoid, AttStateInfoBO::getLockTo, (oldValue, newValue) -> oldValue));
        Map<Object, Object> periodMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
        if (pageStrSet.stream().anyMatch(pageStr -> pageStr.startsWith(AttFileScheduleEnum.PERIOD.getPageId()))) {
            periodMap = this.setPeriodMap();
        }
        boolean isImport = this.getOption().getVariables().containsKey("importtag_of_datasource");
        for (DynamicObject scheduleDy2 : dataList) {
            this.setField(attFileGroupMap, scheduleDy2);
        }
        this.checkExistAttStopFileDate(attFileIdList, scheduleEnumDyGroupMap);
        String isAddNew = (String)this.getOption().getVariables().get("isAddNew");
        boolean importSaveFlag = false;
        if (isImport) {
            String importType = (String)this.getOption().getVariables().get("importtype");
            importSaveFlag = "new".equals(importType);
        }
        boolean addNewFlag = "true".equals(isAddNew) || importSaveFlag;
        HashMap cardCheckErrMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
        HashMap shiftIfOverlapReturnMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
        for (Map.Entry entries : scheduleEnumDyGroupMap.entrySet()) {
            if (addNewFlag) {
                this.checkHaveBeenSet(isImport, operateKey, (Map)entries.getValue(), (String)entries.getKey());
            }
            if (((String)entries.getKey()).startsWith(AttFileScheduleEnum.CARD.getPageId())) {
                cardCheckErrMap.putAll(AttFileScheduleCheckHelper.checkCard((String)((String)entries.getKey()), dataList, (boolean)addNewFlag));
            }
            if (!((String)entries.getKey()).startsWith(AttFileScheduleEnum.WS.getPageId())) continue;
            List workSchCurrentData = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).filter(d -> d != null && d.getDataEntityType().getName().startsWith(AttFileScheduleEnum.WS.getPageId())).collect(Collectors.toList());
            Map stringBooleanMap = AttFileScheduleCheckHelper.checkShiftOverlap((String)((String)entries.getKey()), workSchCurrentData, attFileDyList);
            if (CollectionUtils.isEmpty((Map)stringBooleanMap)) continue;
            shiftIfOverlapReturnMap.putAll(stringBooleanMap);
        }
        for (Map.Entry entries : scheduleEnumDyGroupMap.entrySet()) {
            String pageId = (String)entries.getKey();
            this.check(operateKey, attFileDyMap, pageId, scheduleDyMap, (Map)entries.getValue(), storageMap, frozeAllInfoMap, periodMap, cardCheckErrMap, shiftIfOverlapReturnMap, fileBoIdMsgMap);
        }
    }

    private void checkAttFileIsDiscard(ExtendedDataEntity[] dataEntities) {
        String tips = ResManager.loadKDString((String)"\u6863\u6848\u5df2\u5e9f\u5f03\uff0c\u65e0\u6cd5\u64cd\u4f5c\u3002", (String)"AttFileScheduleValidate_27", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dy = dataEntity.getDataEntity();
            if (!this.isAttFileDiscard(dy)) continue;
            this.addFatalErrorMessage(dataEntity, String.format(tips, dy.getString("attfileid.number")));
        }
    }

    private boolean isAttFileDiscard(DynamicObject dy) {
        return "-1".equals(dy.getString("attfileid.usablestatus"));
    }

    private void checkExistAttStopFileDate(List<Long> attFileIdList, Map<String, Map<Long, List<DynamicObject>>> scheduleEnumDyGroupMap) {
        Map existAttStopFileMap = AttFileModifyCheckService.getInstance().getExistAttStopFileMap(attFileIdList);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            AttFileScheduleEnum attFileScheduleEnum;
            DynamicObject checkDy = dataEntity.getDataEntity();
            if (this.isAttFileDiscard(checkDy)) continue;
            String pageId = checkDy.getDataEntityType().getName();
            long attFileId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)checkDy, (String)"attfileid");
            List<DynamicObject> existsScheduleDys = scheduleEnumDyGroupMap.get(pageId).get(attFileId);
            if (existsScheduleDys == null || existsScheduleDys.size() == 0 || (attFileScheduleEnum = AttFileScheduleEnum.getAttFileScheduleEnumByPageId((String)pageId)) == null) continue;
            String endDateStr = AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId);
            Date endDate = checkDy.getDate(endDateStr);
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)checkDy, (String)"attfileid");
            String msg = AttFileModifyCheckService.getInstance().checkExistAttStopFileDate(existAttStopFileMap, endDate, fileBoId);
            if (!WTCStringUtils.isNotEmpty((String)msg)) continue;
            this.addFatalErrorMessage(dataEntity, msg);
        }
    }

    private void validatePlanSchedule(ExtendedDataEntity[] dataEntities, String operateKey) {
        List dataList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        Map planMap = AttFilePlanHelper.genRulePlanMap((String)"2", dataList);
        Map errMsgMap = AttFilePlanHelper.validatePlan((String)"2", dataList, (Map)planMap);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            List errMsgList;
            DynamicObject schedule = dataEntity.getDataEntity();
            if (this.isAttFileDiscard(schedule) || HRCollUtil.isEmpty((Collection)(errMsgList = (List)errMsgMap.get((Long)schedule.getPkValue())))) continue;
            for (String errMsg : errMsgList) {
                this.addFatalErrorMessage(dataEntity, errMsg);
            }
        }
    }

    private void switchWsWarn(Map<String, Map<Long, List<DynamicObject>>> scheduleEnumDyGroupMap) {
        for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (this.isAttFileDiscard(dataEntity) || !AttFileScheduleEnum.WS.getPageId().equals(dataEntity.getDataEntityType().getName())) continue;
            long attFileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dataEntity, (String)"attfileid");
            Map<Long, List<DynamicObject>> wsListMap = scheduleEnumDyGroupMap.get(AttFileScheduleEnum.WS.getPageId());
            if (wsListMap == null || !WTCCollections.isNotEmpty((Collection)wsListMap.get(attFileBoId))) continue;
            this.addWarningMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5de5\u4f5c\u65e5\u7a0b\u8868\u53d1\u751f\u53d8\u66f4\u540e\u9ed8\u8ba4\u4f1a\u540c\u65f6\u66f4\u65b0\u81f3\u5458\u5de5\u7684\u4e2a\u4eba\u8ba1\u5212\u6392\u73ed\u3002\u662f\u5426\u8986\u76d6\u5df2\u8c03\u6574\u8fc7\u7684\u4e2a\u4eba\u8ba1\u5212\u6392\u73ed\u6570\u636e\uff1f", (String)"AttFileScheduleValidate_26", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkHaveBeenSet(Boolean isImport, String operateKey, Map<Long, List<DynamicObject>> scheduleDyGroupMap, String pageId) {
        if ("save".equals(operateKey)) {
            HashMap checkSelfMap = Maps.newHashMapWithExpectedSize((int)this.dataEntities.length);
            for (ExtendedDataEntity dataEntity : this.dataEntities) {
                String checkHaveBeenSetErrMsg;
                DynamicObject scheduleDy = dataEntity.getDataEntity();
                boolean needCheckExist = this.getOption().getVariables().containsKey("need_check_exist");
                if (!isImport.booleanValue() && !needCheckExist || !StringUtils.isNotBlank((CharSequence)(checkHaveBeenSetErrMsg = AttFileScheduleCheckHelper.checkHaveBeenSet(scheduleDyGroupMap, (DynamicObject)scheduleDy, (String)pageId, (Map)checkSelfMap)))) continue;
                this.addErrorMessage(dataEntity, checkHaveBeenSetErrMsg);
            }
        }
    }

    private void check(String operateKey, Map<Long, DynamicObject> attFileDyMap, String pageId, Map<Long, DynamicObject> scheduleDyMap, Map<Long, List<DynamicObject>> scheduleDyGroupMap, Map<Long, Date> storageMap, Map<Long, AttStateInfoBO> frozeAllInfoMap, Map<Long, DynamicObject> periodMap, Map<String, String> cardCheckErrMap, Map<String, Boolean> shiftIfOverlapReturnMap, Map<Long, String> fileBoIdMsgMap) {
        long hrDefaultRootOrgId = WTCOrgUnitServiceHelper.getHRDefaultRootOrgId();
        AttRecordParam attRecordParam = AttRecordParamService.getAttRecordParam((long)hrDefaultRootOrgId);
        for (int i = 0; i < this.dataEntities.length; ++i) {
            String checkFrozeDateErrMsg;
            String checkStorageToDateErrMsg;
            ExtendedDataEntity dataEntity = this.dataEntities[i];
            DynamicObject scheduleDy = dataEntity.getDataEntity();
            if (this.isAttFileDiscard(scheduleDy)) continue;
            String checkBeginDateAndEndDateErrorMsg = AttFileScheduleCheckHelper.checkBeginDateAndEndDate((DynamicObject)scheduleDy, (String)pageId);
            if (StringUtils.isNotBlank((CharSequence)checkBeginDateAndEndDateErrorMsg)) {
                this.addFatalErrorMessage(dataEntity, checkBeginDateAndEndDateErrorMsg);
                continue;
            }
            String checkStartDateErrMsg = AttFileScheduleCheckHelper.checkStartDate(attFileDyMap, (ExtendedDataEntity)dataEntity, (OperateOption)this.getOption());
            if (StringUtils.isNotBlank((CharSequence)checkStartDateErrMsg)) {
                this.addFatalErrorMessage(dataEntity, checkStartDateErrMsg);
                continue;
            }
            String checkAuthMsg = fileBoIdMsgMap.get(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)scheduleDy, (String)"attfileid"));
            if (StringUtils.isNotBlank((CharSequence)checkAuthMsg)) {
                this.addFatalErrorMessage(dataEntity, checkAuthMsg);
                continue;
            }
            if ("save".equals(operateKey)) {
                String checkShiftOverLapEntity;
                String checkPeriodErrMsg;
                if (AttFileScheduleCheckHelper.checkCardExists(scheduleDyGroupMap, (DynamicObject)scheduleDy)) {
                    checkStorageToDateErrMsg = AttFileScheduleCheckHelper.checkStorageToDateNoTime(storageMap, (DynamicObject)scheduleDy, (String)pageId);
                    if (StringUtils.isNotBlank((CharSequence)checkStorageToDateErrMsg)) {
                        this.addFatalErrorMessage(dataEntity, checkStorageToDateErrMsg);
                        continue;
                    }
                    if (attRecordParam != null && attRecordParam.isAttefile() && StringUtils.isNotBlank((CharSequence)(checkFrozeDateErrMsg = AttFileScheduleCheckHelper.checkFrozeDate(frozeAllInfoMap, (DynamicObject)scheduleDy, (String)pageId)))) {
                        this.addFatalErrorMessage(dataEntity, checkFrozeDateErrMsg);
                        continue;
                    }
                }
                if (pageId.startsWith(AttFileScheduleEnum.PERIOD.getPageId()) && StringUtils.isNotBlank((CharSequence)(checkPeriodErrMsg = AttFileScheduleCheckHelper.checkPeriod(periodMap, (DynamicObject)scheduleDy, (String)pageId)))) {
                    this.addFatalErrorMessage(dataEntity, checkPeriodErrMsg);
                    continue;
                }
                if (WTCMaps.isNotEmpty(cardCheckErrMap)) {
                    String errMsg = cardCheckErrMap.get(String.valueOf(i));
                    int dataEntityIndex = dataEntity.getDataEntityIndex();
                    if (!this.isCurrRowHaveErrorMsg(dataEntityIndex) && WTCStringUtils.isNotEmpty((String)errMsg)) {
                        this.addFatalErrorMessage(dataEntity, errMsg);
                        continue;
                    }
                }
                if (pageId.startsWith(AttFileScheduleEnum.WS.getPageId()) && StringUtils.isNotBlank((CharSequence)(checkShiftOverLapEntity = AttFileScheduleCheckHelper.checkShiftOverLapEntity(shiftIfOverlapReturnMap, (DynamicObject)scheduleDy)))) {
                    this.addFatalErrorMessage(dataEntity, checkShiftOverLapEntity);
                }
                if (!pageId.startsWith(AttFileScheduleEnum.MODE.getPageId()) || modeSet.contains(scheduleDy.getString(AttFileScheduleEnum.MODE.getKey()))) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8003\u52e4\u65b9\u5f0f\u4e0d\u7b26\u5408\u8981\u6c42\u3002", (String)"AttFileScheduleValidate_25", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"saverule".equals(operateKey)) continue;
            checkStorageToDateErrMsg = AttFileScheduleCheckHelper.checkStorageToDate(scheduleDyMap, storageMap, (DynamicObject)scheduleDy, (String)pageId);
            if (StringUtils.isNotBlank((CharSequence)checkStorageToDateErrMsg)) {
                this.addFatalErrorMessage(dataEntity, checkStorageToDateErrMsg);
                continue;
            }
            if (attRecordParam != null && attRecordParam.isAttefile() && StringUtils.isNotBlank((CharSequence)(checkFrozeDateErrMsg = AttFileScheduleCheckHelper.checkFrozeDate(frozeAllInfoMap, (DynamicObject)scheduleDy, (String)pageId)))) {
                this.addFatalErrorMessage(dataEntity, checkFrozeDateErrMsg);
                continue;
            }
            String checkSelfDateScopeErrMsg = this.checkSelfDateScope(i, scheduleDy, pageId);
            if (!StringUtils.isNotBlank((CharSequence)checkSelfDateScopeErrMsg)) continue;
            this.addFatalErrorMessage(dataEntity, checkSelfDateScopeErrMsg);
        }
    }

    private List<DynamicObject> queryAttFile(Set<Long> attFileIdSet, boolean authCheck, String properties) {
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAttStatus(null);
        if (WTCStringUtils.isNotEmpty((String)properties)) {
            attFileQueryParam.setProperties(properties);
        } else {
            attFileQueryParam.setProperties(WTCStringUtils.joinStr((String[])new String[]{AttFileQueryParam.baseProperties, ",", "person.id,person.number,person.name"}));
        }
        attFileQueryParam.setSetBoIds(attFileIdSet);
        attFileQueryParam.setAuthCheck(Boolean.valueOf(authCheck));
        attFileQueryParam.setBeCurrent(null);
        return AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
    }

    private String checkSelfDateScope(int j, DynamicObject scheduleDy, String pageId) {
        Date beginDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
        Date endDate = scheduleDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId));
        for (int i = 0; i < this.dataEntities.length; ++i) {
            DynamicObject currRowDy = this.dataEntities[i].getDataEntity();
            long attFileBoId = scheduleDy.getLong("attfileid.id");
            long loopAttFileBoId = currRowDy.getLong("attfileid.id");
            if (i <= j || attFileBoId != loopAttFileBoId) continue;
            Date beginDateRow = currRowDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)true, (String)pageId));
            Date endDateRow = currRowDy.getDate(AttFileScheduleEnum.getDateStrByPageId((boolean)false, (String)pageId));
            if (beginDate.compareTo(endDateRow) > 0 || endDate.compareTo(beginDateRow) < 0) continue;
            return String.format(ResManager.loadKDString((String)"\u4e0e\u5bfc\u5165\u6570\u636e\u7684\u751f\u6548\u65e5\u671f\u8303\u56f4\u201c%1$s\u81f3%2$s\u201d\u53d1\u751f\u91cd\u53e0\uff0c\u6570\u636e\u4e4b\u95f4\u4e0d\u5141\u8bb8\u91cd\u53e0\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"AttFileScheduleValidate_14", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)beginDateRow), WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)endDateRow));
        }
        return null;
    }

    private boolean isCurrRowHaveErrorMsg(int dataEntityIndex) {
        List allErrorInfo = this.validateResult.getAllErrorInfo();
        if (allErrorInfo != null) {
            Map<Integer, String> errorInfoMap = allErrorInfo.stream().collect(Collectors.toMap(OperateInfo::getDataEntityIndex, OperateInfo::getMessage));
            return errorInfoMap.get(dataEntityIndex) != null;
        }
        return false;
    }

    private Map<Long, DynamicObject> setPeriodMap() {
        List periodIdList = Arrays.stream(this.dataEntities).map(info -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)info.getDataEntity(), (String)"period")).collect(Collectors.toList());
        HRBaseServiceHelper periodHelper = new HRBaseServiceHelper("wtp_attperiod");
        QFilter periodIdQFilter = new QFilter("id", "in", periodIdList);
        DynamicObject[] dynamicObjects = periodHelper.loadDynamicObjectArray(new QFilter[]{periodIdQFilter});
        Map<Long, DynamicObject> periodMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(info -> info.getLong("id"), Function.identity(), (oldValue, newValue) -> oldValue));
        return periodMap;
    }

    private void setField(Map<Long, List<DynamicObject>> attFileGroupMap, DynamicObject scheduleDy) {
        String pageId = scheduleDy.getDataEntityType().getName();
        if (timeSeqPageIdSet.contains(pageId)) {
            AttFileScheduleBusiness.setStartEndDate(attFileGroupMap, (DynamicObject)scheduleDy);
        } else if (noTimeSeqPageIdSet.contains(pageId)) {
            AttFileScheduleBusiness.setPlanEndDate((DynamicObject)scheduleDy);
        }
        AttFileScheduleBusiness.setEndDateAttFileVid(attFileGroupMap, (DynamicObject)scheduleDy, (String)pageId);
    }
}

