/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.attfile.AttFileCheckService;
import kd.wtc.wtp.business.attfile.AttFileSyncService;
import kd.wtc.wtp.common.enums.AttFileTaskCacheInfoEnum;

public class AttFileSynValidator
extends HRDataBaseValidator {
    public void validate() {
        block6: {
            Set<Long> boIdSet;
            ExtendedDataEntity[] dataEntities;
            block5: {
                Map taskRunData;
                super.validate();
                dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length == 0) {
                    return;
                }
                boIdSet = Arrays.stream(dataEntities).map(d -> d.getDataEntity().getLong("boid")).collect(Collectors.toSet());
                boolean add = this.isAdd(boIdSet);
                if (!add) break block5;
                Set employeeIdSet = Arrays.stream(dataEntities).map(d -> d.getDataEntity().getLong("employee.id")).collect(Collectors.toSet());
                Map synFileBoIdMap = AttFileCheckService.getInstance().geFileBoToEmployeeMap(employeeIdSet);
                if (!WTCCollections.isNotEmpty((Map)synFileBoIdMap) || !WTCCollections.isNotEmpty((Map)(taskRunData = AttFileSyncService.getInstance().checkFileBoIds(synFileBoIdMap.keySet())))) break block6;
                HashMap employeeErrMsgMap = Maps.newHashMapWithExpectedSize((int)taskRunData.size());
                synFileBoIdMap.forEach((k, v) -> {
                    if (WTCStringUtils.isNotEmpty((String)((String)taskRunData.get(k)))) {
                        employeeErrMsgMap.put(v, taskRunData.get(k));
                    }
                });
                if (WTCCollections.isNotEmpty((Map)employeeErrMsgMap)) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        AttFileTaskCacheInfoEnum enumByCode;
                        long employeeId = dataEntity.getDataEntity().getLong("employee.id");
                        String msg = (String)employeeErrMsgMap.get(employeeId);
                        if (!WTCStringUtils.isNotEmpty((String)msg) || (enumByCode = AttFileTaskCacheInfoEnum.getEnumByCode((String)msg)) == null) continue;
                        this.addErrorMessage(dataEntity, enumByCode.getMsg().loadKDString());
                    }
                }
                break block6;
            }
            Map taskRunData = AttFileSyncService.getInstance().checkFileBoIds(boIdSet);
            if (WTCCollections.isNotEmpty((Map)taskRunData)) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    AttFileTaskCacheInfoEnum enumByCode;
                    long boId = dataEntity.getDataEntity().getLong("boid");
                    String msg = (String)taskRunData.get(boId);
                    if (!WTCStringUtils.isNotEmpty((String)msg) || (enumByCode = AttFileTaskCacheInfoEnum.getEnumByCode((String)msg)) == null) continue;
                    this.addErrorMessage(dataEntity, enumByCode.getMsg().loadKDString());
                }
            }
        }
    }

    private boolean isAdd(Set<Long> boIdSet) {
        if (WTCCollections.isNotEmpty(boIdSet)) {
            AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
            HashSet<String> usableStatusSet = new HashSet<String>();
            usableStatusSet.add("0");
            usableStatusSet.add("-1");
            attFileQueryParam.setUsableStatus(usableStatusSet);
            attFileQueryParam.setSetBoIds(boIdSet);
            List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
            return WTCCollections.isEmpty((Collection)files);
        }
        return true;
    }
}

