/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attfile.validator;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttFileToBeEffectValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(AttFileToBeEffectValidator.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Date nowDate = WTCDateUtils.getZeroDate((Date)new Date());
        Set toBeEffectEmployeeIdList = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).filter(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee") != 0L && d.getDate("bsed") != null && WTCDateUtils.getZeroDate((Date)d.getDate("bsed")).after(nowDate)).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam();
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setqFilter(new QFilter("enddate", ">", (Object)nowDate).and(new QFilter("bsled", ">", (Object)nowDate)));
        attFileQueryParam.setEmpPersonSetIds(toBeEffectEmployeeIdList);
        attFileQueryParam.setProperties("employee");
        Set existEmployeeIdList = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d, (String)"employee")).collect(Collectors.toSet());
        if (WTCCollections.isNotEmpty(existEmployeeIdList)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                long baseDataId;
                DynamicObject d2 = dataEntity.getDataEntity();
                if (d2.getDate("bsed") == null || !WTCDateUtils.getZeroDate((Date)d2.getDate("bsed")).after(nowDate) || !existEmployeeIdList.contains(baseDataId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d2, (String)"employee"))) continue;
                this.addFatalErrorMessage(dataEntity, AttFileKDString.toBeEffectFileMsg());
            }
        }
    }
}

