/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attperiod;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.opplugin.web.his.WTCSnapSaveOp;
import kd.wtc.wtp.business.attperiod.AttPeriodService;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.opplugin.web.attperiod.validator.AttPeriodValidator;

public class AttPeriodSaveOp
extends WTCSnapSaveOp {
    private static final String STATUS_A = "A";
    private static final String STATUS_B = "B";

    public void onAddValidators(AddValidatorsEventArgs evt) {
        if (!this.operateOption.containsVariable("isfromlist")) {
            evt.addValidator((AbstractValidator)new AttPeriodValidator());
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("perioddate");
        fieldKeys.add("firstperioddate");
        fieldKeys.add("periodnumber");
        fieldKeys.add("status");
        fieldKeys.add("looptype");
        fieldKeys.add("attperiodentry");
        fieldKeys.add("attperiodentry.begindate");
        fieldKeys.add("attperiodentry.enddate");
        fieldKeys.add("attperiodentry.mhsa");
        fieldKeys.add("attperiodentry.ascriptionmonth");
        fieldKeys.add("attperiodentry.periodcode");
        fieldKeys.add("attperiodentry.periodname");
        fieldKeys.add("attperiodentry.ascriptionyearview");
        fieldKeys.add("attperiodentry.ascriptionyear");
        fieldKeys.add("attperiodentry.seq");
        args.setFieldKeys(fieldKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        if (this.operateOption.containsVariable("isfromlist")) {
            return;
        }
        DynamicObject[] dataEntities = evt.getDataEntities();
        if (dataEntities == null) {
            return;
        }
        Arrays.stream(dataEntities).forEach(dynamic -> {
            String loopType = dynamic.getString("looptype");
            if (STATUS_A.equals(loopType)) {
                String periodDate = dynamic.getString("perioddate");
                dynamic.set("firstperioddate", (Object)periodDate);
            }
            DynamicObjectCollection dynamicObjectCollection = dynamic.getDynamicObjectCollection("attperiodentry");
            dynamic.set("periodnumber", (Object)dynamicObjectCollection.size());
            String operateKey = evt.getOperationKey();
            if ("submit".equals(operateKey)) {
                dynamic.set("status", (Object)STATUS_B);
            }
        });
        AttPeriodService.snapEntryHisSaveHis((DynamicObject[])dataEntities);
        HRBaseServiceHelper entryService = new HRBaseServiceHelper("wtp_attperiodentry");
        IDataEntityType dataEntityType = entryService.generateEmptyDynamicObject().getDataEntityType();
        DataEntityCacheManager cacheManager = new DataEntityCacheManager(dataEntityType);
        cacheManager.removeByDt();
        List attPeriodIdList = Arrays.stream(dataEntities).map(dy -> dy.getLong("id")).distinct().collect(Collectors.toList());
        if (StringUtils.equalsAny((CharSequence)evt.getOperationKey(), (CharSequence[])new CharSequence[]{"audit", "submiteffect"}) && !CollectionUtils.isEmpty(attPeriodIdList)) {
            PerAttPeriodDataService.getInstance().saveJobDataForAttPeriodUpdate(attPeriodIdList);
        }
        super.beginOperationTransaction(evt);
    }
}

