/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attperiod.validator;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.attperiod.AttPeriodService;

public class AttPeriodValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        Arrays.stream(this.dataEntities).forEach(data -> {
            String errorStatus;
            String checkYearMouthExist;
            String errorStatus2;
            DynamicObject dynamicObject = data.getDataEntity();
            String attPeriodCode = dynamicObject.getString("number");
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("attperiodentry");
            if (dynamicObjectCollection.isEmpty()) {
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8003\u52e4\u671f\u95f4\u201d\u3002", (String)"AttPeriodValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
            HashMap<String, Long> nameMap = new HashMap<String, Long>(dynamicObjectCollection.size());
            HashMap<String, Long> codeMap = new HashMap<String, Long>(dynamicObjectCollection.size());
            for (DynamicObject dynamic : dynamicObjectCollection) {
                String content;
                Long perSeq;
                Date beginDate = dynamic.getDate("begindate");
                Date endDate = dynamic.getDate("enddate");
                Object mhsa = dynamic.get("mhsa");
                String ascriptionMonth = dynamic.getString("ascriptionmonth");
                String yearview = dynamic.getString("ascriptionyear");
                if (beginDate == null || endDate == null || mhsa == null || ascriptionMonth == null || yearview == null) {
                    this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5f00\u59cb\u65e5\u671f\u201d\u3001\u201c\u7ed3\u675f\u65e5\u671f\u201d\u3001\u201c\u65e5\u671f\u5f52\u5c5e\u89c4\u5219\u201d\u3001\u201c\u6240\u5c5e\u5e74\u4efd\u201d\u3001\u201c\u6240\u5c5e\u6708\u4efd\u201d\u3002", (String)"AttPeriodValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                    return;
                }
                String periodName = dynamic.getString("periodname");
                String periodCode = dynamic.getString("periodcode");
                Long seq = dynamic.getLong("seq");
                boolean nameTag = AttPeriodService.validateDuplicateNameOrCode((DynamicObject)dynamic, (String)"periodname", nameMap);
                boolean codeTag = AttPeriodService.validateDuplicateNameOrCode((DynamicObject)dynamic, (String)"periodcode", codeMap);
                boolean codeFormat = AttPeriodService.validateCodeOrName((String)periodCode);
                if (nameTag) {
                    perSeq = (Long)nameMap.get(periodName);
                    nameMap.put(periodName, seq);
                    content = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8003\u52e4\u671f\u95f4\u7b2c%2$s,%3$s\u884c\u671f\u95f4\u540d\u79f0\u91cd\u590d\"%4$s\"\u3002", (String)"AttPeriodValidator_7", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), attPeriodCode, perSeq, seq, periodName);
                    this.addErrorMessage((ExtendedDataEntity)data, content);
                }
                if (codeTag) {
                    perSeq = (Long)codeMap.get(periodCode);
                    codeMap.put(periodCode, seq);
                    content = String.format(ResManager.loadKDString((String)"%1$s\uff1a\u8003\u52e4\u671f\u95f4\u7b2c%2$s,%3$s\u884c\u671f\u95f4\u7f16\u7801\u91cd\u590d\"%4$s\"\u3002", (String)"AttPeriodValidator_8", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), attPeriodCode, perSeq, seq, periodCode);
                    this.addErrorMessage((ExtendedDataEntity)data, content);
                }
                String seqStr = ResManager.loadKDString((String)"\u7b2c%s\u884c", (String)"AttPeriodValidator_4", (String)"wtc-wtp-opplugin", (Object[])new Object[]{seq});
                if (codeFormat) continue;
                this.addErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"%s\u201c\u671f\u95f4\u7f16\u7801\u201d\u4ec5\u652f\u6301\u82f1\u6587\u5927\u5c0f\u5199\u3001\u6570\u5b57\u53ca\u5305\u62ec\u201c@#$%^&*[]-_.\u201d\u5728\u5185\u7684\u7279\u6b8a\u5b57\u7b26\u3002", (String)"AttPeriodValidator_9", (String)"wtc-wtp-opplugin", (Object[])new Object[]{seqStr}));
            }
            boolean beginError = AttPeriodService.validateDate((DynamicObjectCollection)dynamicObjectCollection);
            if (!beginError) {
                this.addFatalErrorMessage((ExtendedDataEntity)data, ResManager.loadKDString((String)"\u8bf7\u91cd\u65b0\u586b\u5199,\u671f\u95f4\u7ed3\u675f\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u5f00\u59cb\u65e5\u671f\u3002", (String)"AttPeriodValidator_6", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
            if (dynamicObjectCollection.size() > 1 && null != (errorStatus2 = AttPeriodService.calculateDateConflict((DynamicObjectCollection)dynamicObjectCollection))) {
                this.addFatalErrorMessage((ExtendedDataEntity)data, errorStatus2);
            }
            if (StringUtils.isNotEmpty((CharSequence)(checkYearMouthExist = AttPeriodService.checkYearMouthExist((DynamicObjectCollection)dynamicObjectCollection)))) {
                this.addFatalErrorMessage((ExtendedDataEntity)data, checkYearMouthExist);
            }
            if (StringUtils.isNotEmpty((CharSequence)(errorStatus = AttPeriodService.checkDateAttributionRules((DynamicObjectCollection)dynamicObjectCollection)))) {
                this.addFatalErrorMessage((ExtendedDataEntity)data, errorStatus);
            }
            AttPeriodService.handleBoName((DynamicObjectCollection)dynamicObjectCollection);
        });
    }
}

