/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attstateinfo;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.history.service.WTCSnapService;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtp.business.attperiod.PerAttPeriodDataService;
import kd.wtc.wtp.business.attperiod.PeriodSyncFormService;
import kd.wtc.wtp.opplugin.web.attstateinfo.AttStateInfoSaveValidator;

public class AttStateInfoSaveOp
extends HRDataBaseOp {
    private static final HRBaseServiceHelper HELPER = new HRBaseServiceHelper("wtp_attinfoconf");
    private static final HRBaseServiceHelper ATTSTATEINFO_HELPER = new HRBaseServiceHelper("wtp_attstateinfo");

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new AttStateInfoSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("allowreaccounttime");
        fieldKeys.add("fileboid");
        args.setFieldKeys(fieldKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs evt) {
        super.beginOperationTransaction(evt);
        DynamicObject[] dataEntities = evt.getDataEntities();
        this.saveData(dataEntities[0]);
        if (dataEntities.length > 1) {
            Set fileBoIdSet = Arrays.stream(dataEntities).map(dynamicObject -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"fileboid")).collect(Collectors.toSet());
            PeriodSyncFormService.getInstance().savePeriodJobData(fileBoIdSet, "6");
        }
    }

    private void saveData(DynamicObject dynamicObject) {
        ATTSTATEINFO_HELPER.updateDataOne(dynamicObject);
        long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dynamicObject, (String)"fileboid");
        Date date = dynamicObject.getDate("allowreaccounttime");
        if (date != null) {
            QFilter qFilter = new QFilter("fileboid", "=", (Object)fileBoId);
            DynamicObject attInfoConfigDy = HELPER.loadDynamicObject(qFilter);
            MainEntityType hisEntityType = MetadataServiceHelper.getDataEntityType((String)"wtp_attinfoconfhis");
            HRBaseServiceHelper hisHelper = new HRBaseServiceHelper("wtp_attinfoconfhis");
            DynamicObjectCollection collection = new DynamicObjectCollection();
            Date now = new Date();
            if (attInfoConfigDy != null) {
                attInfoConfigDy.set("allowreaccounttime", (Object)date);
                attInfoConfigDy.set("modifier", (Object)RequestContext.get().getCurrUserId());
                attInfoConfigDy.set("modifytime", (Object)now);
                HELPER.updateDataOne(attInfoConfigDy);
                collection.add((Object)attInfoConfigDy);
                WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)hisHelper, (DynamicObjectCollection)collection);
            } else {
                DynamicObject emptyDynamicObject = HELPER.generateEmptyDynamicObject();
                emptyDynamicObject.set("fileboid", (Object)fileBoId);
                emptyDynamicObject.set("allowreaccounttime", (Object)date);
                emptyDynamicObject.set("status", (Object)"C");
                emptyDynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
                emptyDynamicObject.set("createtime", (Object)now);
                emptyDynamicObject.set("id", (Object)DB.genGlobalLongId());
                HELPER.saveOne(emptyDynamicObject);
                collection.add((Object)emptyDynamicObject);
                WTCSnapService.snapHisSave((MainEntityType)hisEntityType, (HRBaseServiceHelper)hisHelper, (DynamicObjectCollection)collection);
            }
            DynamicObject fileDy = AttFileQueryServiceImpl.getInstance().queryOneAttFile("id,attperson,attperson.id", (Object)fileBoId);
            HashMap<Long, Long> fileBoIdAndPersonIdMap = new HashMap<Long, Long>();
            fileBoIdAndPersonIdMap.put(fileDy.getLong("id"), fileDy.getLong("attperson.id"));
            PerAttPeriodDataService.getInstance().processAndSavePerAttPeriodData(fileBoIdAndPersonIdMap);
        }
    }
}

