/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.attstateinfo;

import java.util.Arrays;
import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.util.WTCInteDateUtil;
import kd.wtc.wtp.common.kdstring.AttFileKDString;

public class AttStateInfoSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set fileBoIdSet = Arrays.stream(dataEntities).map(d -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)d.getDataEntity(), (String)"fileboid")).collect(Collectors.toSet());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(false);
        attFileQueryParam.setBeCurrent(Boolean.TRUE);
        attFileQueryParam.setAuthCheck(Boolean.TRUE);
        attFileQueryParam.setProperties("boid");
        attFileQueryParam.setSetBoIds(fileBoIdSet);
        Set authFileBoIdSet = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam).stream().map(d -> d.getLong("boid")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject attStateInfoDy = dataEntity.getDataEntity();
            long fileBoId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)attStateInfoDy, (String)"fileboid");
            if (!authFileBoIdSet.contains(fileBoId)) {
                this.addFatalErrorMessage(dataEntity, AttFileKDString.getNonAttFileAuth());
            }
            Date fileStartDate = attStateInfoDy.getDate("fileboid.startdate");
            Date allowreAccountTime = attStateInfoDy.getDate("allowreaccounttime");
            if (allowreAccountTime == null || fileStartDate == null || allowreAccountTime.compareTo(fileStartDate) >= 0) continue;
            String fileStartDateStr = WTCInteDateUtil.formatDateBySysTzAndUserFmt((Date)fileStartDate);
            String tips = ResManager.loadKDString((String)"\u6700\u65e9\u5141\u8bb8\u91cd\u7b97\u65e5\u671f\u4e0d\u5f97\u65e9\u4e8e\u6863\u6848\u5f00\u59cb\u65e5\u671f %s\u3002", (String)"AttStateInfoSaveValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, String.format(tips, fileStartDateStr));
        }
    }
}

