/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.coordination;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.enums.coordination.CoordinationConfTypeEnums;
import kd.wtc.wtp.opplugin.web.coordination.CoordinationConfSaveValidator;

public class CoordinationConfSaveOp
extends HRDataBaseOp {
    private static final Log LOG = LogFactory.getLog(CoordinationConfSaveOp.class);
    public static final ThreadPool THREAD_POOL = ThreadPools.newFixedThreadPool((String)"wtc_wtp_coordinationConf", (int)(Runtime.getRuntime().availableProcessors() * 2));

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new CoordinationConfSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("msgsubscriber");
        args.getFieldKeys().add("org");
        args.getFieldKeys().add("applyentryentity");
        args.getFieldKeys().add("applyentryentity.applyorg");
        args.getFieldKeys().add("enable");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        if (!this.getOption().getVariables().containsKey("list")) {
            return;
        }
        DynamicObject[] dataEntities = args.getDataEntities();
        DynamicObject dynamicObject = dataEntities[0];
        String codeRuleNumber = RuleEngingService.getCodeRuleNumber();
        String dateEntityType = dynamicObject.getDataEntityType().getName() + codeRuleNumber;
        Long createBuId = dynamicObject.getLong("org.id");
        String name = dynamicObject.getString("name") + codeRuleNumber;
        DynamicObjectCollection entryList = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection orgEntryDys = dynamicObject.getDynamicObjectCollection("applyentryentity");
        if (entryList == null) {
            return;
        }
        Map<String, Long> haveSetMap = entryList.stream().filter(Objects::nonNull).collect(Collectors.toMap(e -> e.getString("type"), e -> e.getLong("policy"), (oldValue, newValue) -> newValue));
        CountDownLatch latch = new CountDownLatch(CoordinationConfTypeEnums.values().length);
        for (CoordinationConfTypeEnums value : CoordinationConfTypeEnums.values()) {
            THREAD_POOL.execute(() -> {
                try {
                    String cacheKey = value.getCode();
                    Map variables = this.getOption().getVariables();
                    if (variables.containsKey(cacheKey)) {
                        this.saveHrmpPolicyData(dateEntityType, createBuId, name, entryList, haveSetMap, cacheKey, orgEntryDys);
                    }
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            LOG.warn("latct.await error:", (Throwable)e2);
            throw new KDBizException(ResManager.loadKDString((String)"\u4eba\u5458\u534f\u540c\u914d\u7f6e\u4fdd\u5b58\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CoordinationConfSaveOp_01", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    public void saveHrmpPolicyData(String dateEntityType, Long createBuId, String name, DynamicObjectCollection entryList, Map<String, Long> haveSetMap, String cacheKey, DynamicObjectCollection orgEntryDys) {
        String cacheValue = this.getOption().getVariableValue(cacheKey);
        Long oldPolicyId = haveSetMap.get(cacheKey);
        Long l = oldPolicyId = oldPolicyId == null ? Long.valueOf(0L) : oldPolicyId;
        if (oldPolicyId == 0L && WTCStringUtils.isNotEmpty((String)cacheValue)) {
            this.addPolicy(dateEntityType, createBuId, name, entryList, cacheKey, orgEntryDys);
        } else if (oldPolicyId != 0L && WTCStringUtils.isEmpty((String)cacheValue)) {
            this.delPolicy(entryList, oldPolicyId, false);
        } else if (oldPolicyId != 0L && WTCStringUtils.isNotEmpty((String)cacheValue)) {
            this.delPolicy(entryList, oldPolicyId, true);
            this.addPolicy(dateEntityType, createBuId, name, entryList, cacheKey, orgEntryDys);
        }
    }

    private void addPolicy(String dateEntityType, Long createBuId, String name, DynamicObjectCollection entryList, String cacheKey, DynamicObjectCollection orgEntryDys) {
        Map<String, Object> paramMap = this.buildSavePolicyMap(cacheKey, createBuId, ID.genLongId(), dateEntityType, name, orgEntryDys);
        Map<String, Object> resultMap = this.callHRMPService(paramMap, "addPolicy");
        Long policyId = (Long)resultMap.get("policyId");
        boolean flag = true;
        for (DynamicObject row : entryList) {
            String type = row.getString("type");
            if (cacheKey.equals(type)) {
                row.set("policy", (Object)policyId);
                row.set("policyjson", (Object)JSONArray.toJSONString(paramMap));
                flag = false;
                break;
            }
            flag = true;
        }
        if (flag) {
            DynamicObject dynamicObject = entryList.addNew();
            dynamicObject.set("type", (Object)cacheKey);
            dynamicObject.set("policy", (Object)policyId);
            dynamicObject.set("policyjson", (Object)JSONArray.toJSONString(paramMap));
        }
    }

    private void delPolicy(DynamicObjectCollection entryList, Long oldPolicyId, boolean isModify) {
        ArrayList delPolicyList = Lists.newArrayList((Object[])new Long[]{oldPolicyId});
        Integer number = (Integer)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"deletePolicy", (Object[])new Object[]{delPolicyList});
        if (number == null || number < 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4e2d\u53f0\u89c4\u5219\u5f15\u64ce\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25\u3002", (String)"CoordinationConfSaveOp_02", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        for (DynamicObject next : entryList) {
            Long policyId = next.getLong("policy");
            if (!delPolicyList.contains(policyId)) continue;
            next.set("policy", null);
            next.set("policyjson", null);
        }
    }

    private Map<String, Object> callHRMPService(Map<String, Object> updatePolicyMap, String strModifyPolicy) {
        Map resultMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)strModifyPolicy, (Object[])new Object[]{updatePolicyMap});
        if (!resultMap.containsKey("resultCode")) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4e2d\u53f0\u89c4\u5219\u5f15\u64ce\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25\u3002", (String)"CoordinationConfSaveOp_02", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        if ((Integer)resultMap.get("resultCode") == 500) {
            throw new KDBizException((String)resultMap.get("errorMsg"));
        }
        return resultMap;
    }

    private Map<String, Object> buildSavePolicyMap(String cacheKey, Long createBuId, Long policyId, String dateEntityType, String name, DynamicObjectCollection orgEntryDys) {
        String ruleData = this.getOption().getVariableValue(cacheKey);
        Map policyMap = (Map)JSONArray.parseObject((String)ruleData, Map.class);
        policyMap.put("id", policyId);
        policyMap.put("createbu", createBuId);
        String codeRuleNumber = RuleEngingService.getCodeRuleNumber();
        policyMap.put("number", cacheKey + "_" + dateEntityType);
        name = name.length() > 30 ? name.substring(0, 30) : name;
        policyMap.put("name", name + codeRuleNumber);
        List list = (List)policyMap.get("entryrulelist");
        for (Map map : list) {
            map.put("id", ID.genLongId());
        }
        ArrayList entryBuList = Lists.newArrayListWithExpectedSize((int)orgEntryDys.size());
        for (DynamicObject applyOrgDy : orgEntryDys) {
            long applyOrgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)applyOrgDy, (String)"applyorg");
            LinkedHashMap entryBuMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
            entryBuMap.put("entitybu", applyOrgId);
            entryBuMap.put("containssub", Boolean.FALSE);
            entryBuList.add(entryBuMap);
        }
        policyMap.put("entrybulist", entryBuList);
        return policyMap;
    }

    private Map<String, Object> buildModifyPolicyMap(String cacheKey, Long createBuId, Long policyId) {
        String ruleData = this.getOption().getVariableValue(cacheKey);
        Map policyMap = (Map)JSONArray.parseObject((String)ruleData, Map.class);
        policyMap.put("id", policyId);
        policyMap.put("createbu", createBuId);
        List list = (List)policyMap.get("entryrulelist");
        for (Map map : list) {
            map.put("modifystatus", "modify");
            map.put("id", map.get("id"));
        }
        JSONObject jobj = (JSONObject)((JSONArray)policyMap.get("entrybulist")).get(0);
        jobj.put("modifystatus", (Object)"modify");
        jobj.put("entitybu", (Object)Long.valueOf(String.valueOf(((JSONObject)((JSONArray)policyMap.get("entrybulist")).get(0)).get((Object)"entitybu"))));
        return policyMap;
    }
}

