/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.coordination;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.common.kdstring.CoordinationKDString;
import kd.wtc.wtp.enums.coordination.CoordinationConfTypeEnums;
import kd.wtc.wtp.enums.coordination.SubscribeEnum;

public class CoordinationConfSaveValidator
extends AbstractValidator {
    boolean orgCheck = true;
    int tempIndex = 1;

    public void validate() {
        block7: {
            String operateKey;
            block6: {
                operateKey = this.getOperateKey();
                if (!"save".equals(operateKey) && !"submit".equals(operateKey)) break block6;
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    if (this.getOption().getVariables().containsKey("list")) {
                        this.entryValidate(dataEntity);
                    }
                    this.orgCheck = true;
                    this.tempIndex = 1;
                    DynamicObject currentDy = dataEntity.getDataEntity();
                    DynamicObjectCollection applyOrgEntryDys = currentDy.getDynamicObjectCollection("applyentryentity");
                    if (applyOrgEntryDys.size() == 0) {
                        this.addErrorMessage(dataEntity, CoordinationKDString.applyOrgEntryIsNotEmpty());
                    } else if (applyOrgEntryDys.size() > 100) {
                        this.addErrorMessage(dataEntity, CoordinationKDString.applyOrgEntryQuantityLimit());
                    }
                    this.orgAndMsgSubscriberUniqueValidate(dataEntity);
                    this.validatePlanWithOrg(dataEntity);
                }
                break block7;
            }
            if (!"enable".equals(operateKey)) break block7;
            for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                if ("1".equals(dataEntity.getDataEntity().get("enable"))) continue;
                this.orgAndMsgSubscriberUniqueValidate(dataEntity);
                this.multiSelectedRowCheck(dataEntity);
            }
        }
    }

    public void multiSelectedRowCheck(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        List<Long> applyOrgIds = dy.getDynamicObjectCollection("applyentryentity").stream().map(entryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"applyorg")).collect(Collectors.toList());
        long msgSubscriberId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"msgsubscriber.id");
        long pkValue = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"id");
        List repeatDataList = Arrays.stream(this.dataEntities).filter(extendedDataEntity -> pkValue != WTCDynamicObjectUtils.getBaseDataId((DynamicObject)extendedDataEntity.getDataEntity(), (String)"id")).filter(extendedDataEntity -> !"1".equals(extendedDataEntity.getDataEntity().getString("enable"))).filter(extendedDataEntity -> msgSubscriberId == WTCDynamicObjectUtils.getBaseDataId((DynamicObject)extendedDataEntity.getDataEntity(), (String)"msgsubscriber.id")).filter(extendedDataEntity -> {
            List otherApplyOrgIds = extendedDataEntity.getDataEntity().getDynamicObjectCollection("applyentryentity").stream().map(entryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"applyorg")).collect(Collectors.toList());
            return otherApplyOrgIds.stream().anyMatch(applyOrgIds::contains);
        }).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        for (DynamicObject repeatDataDy : repeatDataList) {
            this.genExistsConfTips(dataEntity, applyOrgIds, repeatDataDy);
        }
    }

    public void genExistsConfTips(ExtendedDataEntity dataEntity, List<Long> applyOrgIds, DynamicObject repeatDataDy) {
        DynamicObjectCollection entryDys = repeatDataDy.getDynamicObjectCollection("applyentryentity");
        List orgNameList = entryDys.stream().filter(entryDy -> applyOrgIds.contains(WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"applyorg"))).map(dy -> dy.getString("applyorg.name")).collect(Collectors.toList());
        String orgNameStr = WTCStringUtils.join(orgNameList, (String)"\u201d\uff0c\u201c");
        this.addErrorMessage(dataEntity, CoordinationKDString.existsConfTips((String)orgNameStr, (String)repeatDataDy.getString("number")));
    }

    private void entryValidate(ExtendedDataEntity dataEntity) {
        String msgSubscriberNumber = dataEntity.getDataEntity().getString("msgsubscriber.number");
        if (!SubscribeEnum.CONFIRM_ENTRY.getCode().equals(msgSubscriberNumber)) {
            return;
        }
        Map variables = this.getOption().getVariables();
        for (CoordinationConfTypeEnums value : CoordinationConfTypeEnums.values()) {
            String code;
            if (CoordinationConfTypeEnums.EMPGROUP != value && CoordinationConfTypeEnums.DEPENDENC != value && CoordinationConfTypeEnums.WORKPLACE != value && CoordinationConfTypeEnums.ATTTAG != value || variables.containsKey(code = value.getCode()) && !HRStringUtils.isEmpty((String)((String)variables.get(code)))) continue;
            String errMsg = String.format(ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e%s\u7684\u89c4\u5219\u7ed3\u679c\u3002", (String)"CoordinationConfSaveValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), value.getName());
            this.addErrorMessage(dataEntity, errMsg);
        }
    }

    private void orgAndMsgSubscriberUniqueValidate(ExtendedDataEntity dataEntity) {
        DynamicObject[] existsApplyOrgDys;
        DynamicObject currentDy = dataEntity.getDataEntity();
        DynamicObjectCollection applyOrgDys = currentDy.getDynamicObjectCollection("applyentryentity");
        List<Long> applyOrgIds = applyOrgDys.stream().map(entryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"applyorg")).collect(Collectors.toList());
        QFilter qFilter = new QFilter("applyentryentity.applyorg", "in", applyOrgIds);
        qFilter.and(new QFilter("msgsubscriber", "=", (Object)currentDy.getLong("msgsubscriber.id")));
        qFilter.and(new QFilter("id", "!=", currentDy.getPkValue()));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_coordinationconf");
        for (DynamicObject existsApplyOrgDy : existsApplyOrgDys = helper.loadDynamicObjectArray(new QFilter[]{qFilter})) {
            this.genExistsConfTips(dataEntity, applyOrgIds, existsApplyOrgDy);
        }
    }

    private void validatePlanWithOrg(ExtendedDataEntity dataEntity) {
        for (int i = 0; i < CoordinationConfTypeEnums.values().length; ++i) {
            String pageId;
            Map variablesMap;
            String ruleData;
            Map policyMap;
            CoordinationConfTypeEnums value = CoordinationConfTypeEnums.values()[i];
            if (!value.isCtrlStrategy() || WTCCollections.isEmpty((Map)(policyMap = (Map)JSONArray.parseObject((String)(ruleData = (String)(variablesMap = this.getOption().getVariables()).get(value.getCode())), Map.class))) || HRStringUtils.isEmpty((String)(pageId = value.getPageId()))) continue;
            HashSet resultValueList = Sets.newHashSetWithExpectedSize((int)10);
            String defaultStr = (String)this.getOption().getVariables().get(value.getCode());
            if (HRStringUtils.isNotEmpty((String)defaultStr)) {
                Object entryRuleListObject;
                Map map = (Map)SerializationUtils.fromJsonString((String)defaultStr, Map.class);
                Object resultsObject = map.get("results");
                if (resultsObject != null) {
                    RuleResultInfo ruleResultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)String.valueOf(resultsObject), RuleResultInfo.class);
                    resultValueList.addAll(ruleResultInfo.getResultList().stream().map(info -> Long.valueOf(info.getValue())).collect(Collectors.toSet()));
                }
                if ((entryRuleListObject = map.get("entryrulelist")) != null) {
                    List entryRuleList = (List)entryRuleListObject;
                    for (Map entryRuleMap : entryRuleList) {
                        Object filterResultObject = entryRuleMap.get("filterresult");
                        if (filterResultObject == null) continue;
                        RuleResultInfo ruleResultInfo1 = (RuleResultInfo)SerializationUtils.fromJsonString((String)String.valueOf(filterResultObject), RuleResultInfo.class);
                        resultValueList.addAll(ruleResultInfo1.getResultList().stream().map(info -> Long.valueOf(info.getValue())).collect(Collectors.toSet()));
                    }
                }
            }
            if (WTCCollections.isEmpty((Collection)resultValueList)) continue;
            this.getScheduleWithoutOrgTips(dataEntity, value, resultValueList);
        }
    }

    private void getScheduleWithoutOrgTips(ExtendedDataEntity dataEntity, CoordinationConfTypeEnums typeEnums, Set<Long> resultValueList) {
        DynamicObject[] notPassDys;
        DynamicObject[] dys;
        DynamicObject currentDy = dataEntity.getDataEntity();
        List applyOrgIds = currentDy.getDynamicObjectCollection("applyentryentity").stream().map(dy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)dy, (String)"applyorg")).collect(Collectors.toList());
        long createOrgId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)currentDy, (String)"org");
        String pageId = typeEnums.getPageId();
        if (HRStringUtils.isEmpty((String)pageId)) {
            return;
        }
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)pageId, (Long)createOrgId);
        for (Long applyOrgId : applyOrgIds) {
            baseDataFilter.and(BaseDataServiceHelper.getBaseDataFilter((String)pageId, (Long)applyOrgId));
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper(pageId);
        HashSet idSet = Sets.newHashSetWithExpectedSize((int)16);
        HashSet noPassIdSet = Sets.newHashSetWithExpectedSize((int)16);
        if (baseDataFilter != null && (dys = helper.queryOriginalArray("id", new QFilter[]{baseDataFilter})) != null) {
            idSet.addAll(Arrays.stream(dys).map(dy -> dy.getLong("id")).collect(Collectors.toSet()));
            noPassIdSet.addAll(resultValueList.stream().filter(currentId -> !idSet.contains(currentId)).collect(Collectors.toSet()));
        }
        for (DynamicObject notPassDy : notPassDys = helper.queryOriginalArray("name, number", new QFilter[]{new QFilter("id", "in", (Object)noPassIdSet)})) {
            if (this.orgCheck) {
                this.addErrorMessage(dataEntity, CoordinationKDString.hasNotApplyOrgPermTips());
                this.orgCheck = false;
            }
            this.addErrorMessage(dataEntity, CoordinationKDString.hasNotCreateOrgPermTips((String)String.valueOf(this.tempIndex), (String)typeEnums.getName(), (String)notPassDy.getString("name"), (String)notPassDy.getString("number")));
            ++this.tempIndex;
        }
    }
}

