/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.coordination.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.coordination.CoordinationTask;
import kd.wtc.wtp.common.kdstring.AttFileKDString;
import kd.wtc.wtp.common.model.coordination.CoordinationTaskResponse;
import kd.wtc.wtp.enums.coordination.CoordinationExecutionStatusEnum;

public class CoordinationTaskValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        Arrays.stream(this.getDataEntities()).forEach(extendedDataEntity -> {
            DynamicObject currentDy;
            if (HRStringUtils.isEmpty((String)extendedDataEntity.getBillNo()) && (currentDy = extendedDataEntity.getDataEntity()) != null) {
                extendedDataEntity.setBillNo(currentDy.getString("number"));
            }
        });
        if ("discard".equals(operateKey)) {
            this.discardValidate();
        } else if ("execute".equals(operateKey)) {
            this.execute();
        }
    }

    public void execute() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List logIds = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("coordinationlog")).collect(Collectors.toList());
        DynamicObject[] logDyArray = (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"ICoordinationService", (String)"load", (Object[])new Object[]{logIds});
        HashSet allNumber = Sets.newHashSetWithExpectedSize((int)16);
        for (ExtendedDataEntity dataEntity2 : dataEntities) {
            DynamicObject logDy;
            if (this.executeValidate(dataEntity2) || (logDy = (DynamicObject)Arrays.stream(logDyArray).filter(currentLogDy -> currentLogDy.getLong("id") == dataEntity2.getDataEntity().getLong("coordinationlog")).findFirst().orElse(null)) == null) continue;
            CoordinationTaskResponse taskResponse = CoordinationTask.getInstance().createTask(logDy, true);
            CoordinationTask.getInstance().execute(taskResponse, logDy);
            String executionStatus = taskResponse.getExecutionStatus();
            if (CoordinationExecutionStatusEnum.EXEFAILED.getCode().equals(executionStatus)) {
                this.addErrorMessage(dataEntity2, taskResponse.getTaskMsg());
            }
            if (!WTCCollections.isNotEmpty((Map)taskResponse.getRollbackResult()) || null == taskResponse.getRollbackResult().get("rollbackFileOnly")) continue;
            allNumber.add(taskResponse.getRollbackResult().get("rollbackFileOnly").toString());
        }
        if (WTCCollections.isNotEmpty((Collection)allNumber)) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String fileNumber : allNumber) {
                stringBuilder.append(fileNumber);
            }
            this.getOption().setVariableValue("rollbackFileOnly", AttFileKDString.fileRollbackOnly((String)stringBuilder.toString()));
        }
    }

    private boolean executeValidate(ExtendedDataEntity dataEntity) {
        DynamicObject dy = dataEntity.getDataEntity();
        String executionStatus = dy.getString("executionstatus");
        if (CoordinationExecutionStatusEnum.UNEXECUTED.getCode().equals(executionStatus) || CoordinationExecutionStatusEnum.EXEFAILED.getCode().equals(executionStatus)) {
            return false;
        }
        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7684\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u6267\u884c\u3002", (String)"CoordinationTaskValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), CoordinationExecutionStatusEnum.getEnumByCode((String)executionStatus).getDescription()));
        return true;
    }

    private void discardValidate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dy = dataEntity.getDataEntity();
            String executionStatus = dy.getString("executionstatus");
            if (CoordinationExecutionStatusEnum.UNEXECUTED.getCode().equals(executionStatus) || CoordinationExecutionStatusEnum.EXEFAILED.getCode().equals(executionStatus)) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%s\u7684\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5e9f\u5f03\u3002", (String)"CoordinationTaskValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), CoordinationExecutionStatusEnum.getEnumByCode((String)executionStatus).getDescription()));
        }
    }
}

