/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.incrdecrrules.validate;

import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class IncrDecrRuleValidator
extends HRDataBaseValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObjectCollection entries = dataEntity.getDataEntity().getDynamicObjectCollection("wtp_rulessettingentity");
            if (CollectionUtils.isEmpty((Collection)entries)) {
                String tip = ResManager.loadKDString((String)"\u8bf7\u6ce8\u610f\uff1a\u201c\u65e5\u660e\u7ec6\u589e\u51cf\u201d\u548c\u201c\u671f\u95f4\u6c47\u603b\u589e\u51cf\u201d\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"IncrDecrRuleValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, tip);
                continue;
            }
            this.checkEntry(dataEntity, "wtp_rulessettingentity", "incdecconfig");
            this.checkEntry(dataEntity, "daydetailentry", "dayincdecconfig");
            this.checkEntry(dataEntity, "periodentry", "periodincdecconfig");
            Date effect = dataEntity.getDataEntity().getDate("bsed");
            if (effect == null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u751f\u6548\u65e5\u671f\u201d\u3002", (String)"IncrDecrRuleValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
            this.checkEffect(dataEntity, "wtp_rulessettingentity", "incdecconfig", effect);
        }
    }

    private void checkEntry(ExtendedDataEntity dataEntity, String entryKey, String configKey) {
        DynamicObjectCollection entries = dataEntity.getDataEntity().getDynamicObjectCollection(entryKey);
        HashSet<Long> exist = new HashSet<Long>(16);
        for (DynamicObject entry : entries) {
            DynamicObject configDy = entry.getDynamicObject(configKey);
            if (configDy == null) continue;
            long configPkId = configDy.getLong("id");
            if (exist.contains(configPkId)) {
                String fix = ResManager.loadKDString((String)"\u91cd\u590d\u6dfb\u52a0\u3002", (String)"IncrDecrRuleValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, configDy.getLocaleString("name").getLocaleValue() + fix);
                continue;
            }
            exist.add(configPkId);
        }
    }

    private void checkEffect(ExtendedDataEntity dataEntity, String entryKey, String configKey, Date startDate) {
        DynamicObjectCollection entries = dataEntity.getDataEntity().getDynamicObjectCollection(entryKey);
        for (DynamicObject entry : entries) {
            Date configEffStartDate;
            DynamicObject configDy = entry.getDynamicObject(configKey);
            if (configDy == null || (configEffStartDate = configDy.getDate("firstbsed")).compareTo(startDate) <= 0) continue;
            String tip = ResManager.loadKDString((String)"\u589e\u51cf\u914d\u7f6e\u201c%s\u201d\u7684\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u5f53\u524d\u6570\u636e\u751f\u6548\u65e5\u671f\u3002", (String)"IncrDecrRuleValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(tip, configDy.getLocaleString("name").getLocaleValue()));
        }
    }
}

