/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.overtime.validate;

import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.util.WtcNumericalUtil;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;

public class OtBaseSetValidator
extends HRDataBaseValidator {
    private static final int MAX_RANGE_LENGTH = 4000;

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            this.verifyAdvanceCrlAndAfterCrl(dataEntity);
            this.verifyJsonSize(dataEntity);
            this.verifyApplySpan(dataEntity);
        }
    }

    private void verifyApplySpan(ExtendedDataEntity dataEntity) {
        Boolean isApplySpan = (Boolean)dataEntity.getValue("isapplyspan");
        boolean appSpanCtrl = isApplySpan != null && isApplySpan != false;
        String applySpan = (String)dataEntity.getValue("applyspan");
        if (appSpanCtrl && HRStringUtils.isBlank((CharSequence)applySpan)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u63a7\u5236\u5355\u4f4d\u65f6\u957f\u5f00\u542f\u65f6\uff0c\u5355\u4f4d\u65f6\u957f\u7684\u503c\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtBaseSetValidator_7", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private void verifyJsonSize(ExtendedDataEntity dataEntity) {
        String dateRangeCondition = (String)dataEntity.getValue("daterangecondition");
        if (dateRangeCondition != null && dateRangeCondition.length() > 4000) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b57\u6bb5\u201c\u9002\u7528\u65e5\u671f\u8303\u56f4\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4[0,4000]\u3002", (String)"OtBaseSetValidator_6", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private void verifyAdvanceCrlAndAfterCrl(ExtendedDataEntity dataEntity) {
        String advanceUnitMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9884\u63d0\u5468\u671f\u201d\u3002", (String)"OtBaseSetValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        String advanceNumMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u9884\u63d0\u671f\u9650\u201d\u3002", (String)"OtBaseSetValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        String maxAdvanceUnitMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5927\u53ef\u9884\u63d0\u65e5\u671f\u9650\u5236\u5468\u671f\u201d\u3002", (String)"OtBaseSetValidator_4", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        String maxAdvanceNumMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u6700\u5927\u9884\u63d0\u671f\u9650\u201d\u3002", (String)"OtBaseSetValidator_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        String afterUnitMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8865\u63d0\u5468\u671f\u201d\u3002", (String)"OtBaseSetValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        String afterNumMsg = ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u8865\u63d0\u671f\u9650\u201d\u3002", (String)"OtBaseSetValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        this.verifyEmptyByControl(dataEntity, "isadvancecrl", "advanceunit", "advancenum", advanceUnitMsg, advanceNumMsg);
        this.verifyEmptyByControl(dataEntity, "ismaxadvancecrl", "maxadvanceunit", "maxadvancenum", maxAdvanceUnitMsg, maxAdvanceNumMsg);
        this.verifyEmptyByControl(dataEntity, "isaftercrl", "afterunit", "afternum", afterUnitMsg, afterNumMsg);
        this.verifyNum(dataEntity, "isadvancecrl", "advancenum", 1);
        this.verifyNum(dataEntity, "ismaxadvancecrl", "maxadvancenum", 1);
        String unit = (String)dataEntity.getValue("afterunit");
        if (HRStringUtils.equals((String)unit, (String)BaseSetUnitTypeEnum.PERIOD.getCode())) {
            this.verifyNum(dataEntity, "isaftercrl", "afternum", 0);
        } else {
            this.verifyNum(dataEntity, "isaftercrl", "afternum", 1);
        }
    }

    private void verifyNum(ExtendedDataEntity dataEntity, String controlName, String numName, int minNum) {
        String errorInfo;
        Boolean crl = (Boolean)dataEntity.getValue(controlName);
        if (!crl.booleanValue()) {
            return;
        }
        Object num = dataEntity.getValue(numName);
        if (num != null && HRStringUtils.isNotEmpty((String)(errorInfo = WtcNumericalUtil.verifyIllegalNum((BigDecimal)new BigDecimal(minNum + ""), (BigDecimal)new BigDecimal("999"), (boolean)true, (boolean)true, (BigDecimal)new BigDecimal(num + ""), (String)"")))) {
            this.addErrorMessage(dataEntity, errorInfo);
        }
    }

    private void verifyEmptyByControl(ExtendedDataEntity dataEntity, String controlName, String unitName, String numName, String unitMsg, String numMsg) {
        Boolean crl = (Boolean)dataEntity.getValue(controlName);
        String unit = (String)dataEntity.getValue(unitName);
        Object num = dataEntity.getValue(numName);
        if (crl.booleanValue()) {
            if (HRStringUtils.isEmpty((String)unit)) {
                this.addErrorMessage(dataEntity, unitMsg);
            }
            if (num == null) {
                this.addErrorMessage(dataEntity, numMsg);
                return;
            }
        }
    }
}

