/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.overtime.validate;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.predata.wtbd.PreDataOtTimeSource;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.business.overtime.OverworkRuleUtil;

public class OtRuleValidator
extends HRDataBaseValidator {
    private static final int MAX_RANGE_LENGTH = 4000;
    private static final Set<String> SUB_PROJECT = Sets.newHashSet((Object[])new String[]{"originalprj", "originalcalprj", "overtimesub", "subprj", "resultprj"});

    public void validate() {
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            this.checkEntryNum(dataEntity);
            this.checkTime(dataEntity);
            this.checkRepeatType(dataEntity);
            this.verifyJsonSize(ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u671f\u8303\u56f4", (String)"OtRuleValidator_9", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), "daterangecondition", dataEntity);
            this.verifyJsonSize(ResManager.loadKDString((String)"\u9650\u5b9a\u6761\u4ef6", (String)"OtRuleValidator_10", (String)"wtc-wtp-opplugin", (Object[])new Object[0]), "limitscope", dataEntity);
        }
    }

    private void verifyJsonSize(String tip, String key, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryColl = dataEntity.getDataEntity().getDynamicObjectCollection("overworkcalentry");
        for (int index = 0; index < entryColl.size(); ++index) {
            DynamicObject entryDy = (DynamicObject)entryColl.get(index);
            String val = entryDy.getString(key);
            if (val == null || val.length() <= 4000) continue;
            String error = ResManager.loadKDString((String)"\u201c\u52a0\u73ed\u65f6\u957f\u8ba1\u7b97\u89c4\u5219\u201d\u7b2c{0}\u884c\uff0c\u5b57\u6bb5\u201c{1}\u201d\u8f93\u5165\u957f\u5ea6\u8d85\u51fa\u9650\u5b9a\u8303\u56f4\uff0c\u9650\u5b9a\u8303\u56f4\u4e3a[0,4000]\u3002", (String)"OtRuleValidator_8", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, MessageFormat.format(error, index + 1, tip));
        }
    }

    private void checkRepeatType(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryColl = dataEntity.getDataEntity().getDynamicObjectCollection("overworkcalentry");
        HashSet otType = Sets.newHashSetWithExpectedSize((int)entryColl.size());
        for (DynamicObject entryDy : entryColl) {
            DynamicObject otTypeDy = entryDy.getDynamicObject("ottype");
            if (otTypeDy == null) continue;
            long otTypeId = otTypeDy.getLong("id");
            if (otType.contains(otTypeId)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u52a0\u73ed\u7c7b\u578b\u4e0d\u5141\u8bb8\u91cd\u590d\u3002", (String)"OtRuleValidator_6", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            otType.add(otTypeId);
        }
    }

    private void checkEntryNum(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryColl = dataEntity.getDataEntity().getDynamicObjectCollection("overworkcalentry");
        if (CollectionUtils.isEmpty((Collection)entryColl)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u884c\u6570\u636e\u5230\u8ba1\u7b97\u89c4\u5219\u4e2d\u3002", (String)"OtRuleValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject entryDy : entryColl) {
            boolean empChoice = entryDy.getBoolean("isempchoice");
            Long pkValue = Optional.ofNullable(entryDy.getDynamicObject("datasource")).map(dy -> (Long)dy.getPkValue()).orElseGet(() -> null);
            if (empChoice && PreDataOtTimeSource.PD_1030_S.equals(pkValue)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u52a0\u73ed\u65f6\u6570\u6765\u6e90\u4e3a\u201c\u6253\u5361\u201d\u65f6\u4e0d\u80fd\u5f00\u542f\u5458\u5de5\u53ef\u81ea\u9009\u8865\u507f\u65b9\u5f0f\u3002", (String)"OtRuleValidator_7", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection("overworkcaldetail");
            if (CollectionUtils.isEmpty((Collection)subEntryColl)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u52a0\u73ed\u9879\u76ee\u8bbe\u7f6e\u9700\u8981\u6dfb\u52a0\u4e00\u884c\u6570\u636e\u3002", (String)"OtRuleValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                return;
            }
            HashSet compenIdSets = Sets.newHashSetWithExpectedSize((int)subEntryColl.size());
            if (!empChoice) continue;
            for (DynamicObject subEntry : subEntryColl) {
                DynamicObject compenModeDy = subEntry.getDynamicObject("otcompenmode");
                if (compenModeDy == null) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u4e3a\u5458\u5de5\u81ea\u9009\u65f6,\u52a0\u73ed\u8865\u507f\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtRuleValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                    return;
                }
                long compenId = compenModeDy.getLong("id");
                if (compenIdSets.contains(compenId)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u4e3a\u5458\u5de5\u81ea\u9009\u65f6,\u52a0\u73ed\u8865\u507f\u65b9\u5f0f\u4e0d\u53ef\u91cd\u590d\u3002", (String)"OtRuleValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                    return;
                }
                compenIdSets.add(compenId);
            }
        }
    }

    private void checkTime(ExtendedDataEntity dataEntity) {
        DynamicObjectCollection entryColl;
        Date bsed = dataEntity.getDataEntity().getDate("bsed");
        if (bsed == null) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6548\u65f6\u95f4\u3002", (String)"OtRuleValidator_4", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        if (!CollectionUtils.isEmpty((Collection)(entryColl = dataEntity.getDataEntity().getDynamicObjectCollection("overworkcalentry")))) {
            for (DynamicObject entryDy : entryColl) {
                DynamicObject baseSetDy = entryDy.getDynamicObject("otbaseset");
                if (!this.checkDyTime(baseSetDy, bsed)) {
                    String tip = ResManager.loadKDString((String)"{0}\u7684\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u52a0\u73ed\u89c4\u5219\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u8c03\u6574\u3002", (String)"OtRuleValidator_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                    String mutiLangInfo = OverworkRuleUtil.getMutiLangInfo((String)"otbaseset");
                    String finalTip = MessageFormat.format(tip, mutiLangInfo);
                    this.addErrorMessage(dataEntity, finalTip);
                }
                this.checkSub(dataEntity, bsed, entryDy);
            }
        }
    }

    private void checkSub(ExtendedDataEntity dataEntity, Date bsed, DynamicObject entryDy) {
        DynamicObjectCollection subEntryColl = entryDy.getDynamicObjectCollection("overworkcaldetail");
        if (!CollectionUtils.isEmpty((Collection)subEntryColl)) {
            for (DynamicObject subEntryDy : subEntryColl) {
                for (String project : SUB_PROJECT) {
                    if (this.checkDyTime(subEntryDy.getDynamicObject(project), bsed)) continue;
                    String tip = ResManager.loadKDString((String)"{0}\u7684\u751f\u6548\u65e5\u671f\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u52a0\u73ed\u89c4\u5219\u751f\u6548\u65e5\u671f\uff0c\u8bf7\u8c03\u6574\u3002", (String)"OtRuleValidator_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
                    String finalTip = MessageFormat.format(tip, OverworkRuleUtil.getMutiLangInfo((String)project));
                    this.addErrorMessage(dataEntity, finalTip);
                }
            }
        }
    }

    private boolean checkDyTime(DynamicObject checkDy, Date mainBsed) {
        if (checkDy == null) {
            return true;
        }
        Date firstDate = checkDy.getDate("firstbsed");
        return !firstDate.after(mainBsed);
    }
}

