/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.overtime.validate;

import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.util.WtcNumericalUtil;
import kd.wtc.wtp.business.overtime.WTPTipsEnum;

public class OtSubValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        if (!this.checkIsSummitDirectly() && Arrays.asList("submit", "audit").contains(this.getOperateKey())) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject entity = dataEntity.getDataEntity();
            String subType = entity.getString("subtype");
            if ("E".equals(subType)) {
                DynamicObjectCollection entry = entity.getDynamicObjectCollection("entryentity");
                this.checkDateByFixPeriod(dataEntity, entry);
            }
            this.checkNum(dataEntity);
        }
    }

    private void checkNum(ExtendedDataEntity dataEntity) {
        String type = dataEntity.getDataEntity().getString("subtype");
        WTPTipsEnum enumByType = WTPTipsEnum.getEnumByType((String)type);
        String error = "";
        BigDecimal fixtimes = dataEntity.getDataEntity().getBigDecimal("fixtimes");
        if (enumByType == WTPTipsEnum.DEDUCTION_FIXED_DURATION) {
            error = fixtimes == null ? ResManager.loadKDString((String)"\u6263\u9664\u56fa\u5b9a\u65f6\u957f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtSubValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]) : WtcNumericalUtil.verifyIllegalNum((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("9999"), (boolean)false, (boolean)true, (BigDecimal)fixtimes, (String)ResManager.loadKDString((String)"\u6263\u51cf\u56fa\u5b9a\u65f6\u957f\uff08\u5c0f\u65f6\uff09", (String)"OtSubValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        String selectsub = dataEntity.getDataEntity().getString("selectsub");
        BigDecimal destimes = dataEntity.getDataEntity().getBigDecimal("destimes");
        if (enumByType == WTPTipsEnum.DEDUCTION_RESTRERIOD && "1".equals(selectsub)) {
            error = destimes == null ? ResManager.loadKDString((String)"\u6263\u9664\u9ed8\u8ba4\u4f11\u606f\u65f6\u6bb5\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtSubValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]) : WtcNumericalUtil.verifyIllegalNum((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("999"), (boolean)false, (boolean)true, (BigDecimal)destimes, (String)ResManager.loadKDString((String)"\u6263\u9664\u9ed8\u8ba4\u4f11\u606f\u65f6\u6bb5", (String)"OtSubValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        if (enumByType == WTPTipsEnum.FULL_DEDUCTION) {
            BigDecimal satisfyhours = dataEntity.getDataEntity().getBigDecimal("satisfyhours");
            BigDecimal deducthours = dataEntity.getDataEntity().getBigDecimal("deducthours");
            if (satisfyhours == null || deducthours == null) {
                error = ResManager.loadKDString((String)"\u6ee1\u8db3\u5c0f\u65f6\u6570\u6216\u6263\u51cf\u5c0f\u65f6\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtSubValidator_4", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
            } else {
                error = WtcNumericalUtil.verifyIllegalNum((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("999"), (boolean)false, (boolean)true, (BigDecimal)satisfyhours, (String)ResManager.loadKDString((String)"\u6ee1\u8db3\u5c0f\u65f6\u6570", (String)"OtSubValidator_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                if (HRStringUtils.isEmpty((String)error)) {
                    error = WtcNumericalUtil.verifyIllegalNum((BigDecimal)new BigDecimal("0"), (BigDecimal)new BigDecimal("999"), (boolean)false, (boolean)true, (BigDecimal)deducthours, (String)ResManager.loadKDString((String)"\u6263\u51cf\u5c0f\u65f6\u6570", (String)"OtSubValidator_6", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
            }
        }
        if (!"".equals(error)) {
            this.addErrorMessage(dataEntity, error);
        }
    }

    private void checkDateByFixPeriod(ExtendedDataEntity dataEntity, DynamicObjectCollection entry) {
        if (!entry.isEmpty()) {
            for (DynamicObject dynamicObject : entry) {
                int start = dynamicObject.getInt("starttime");
                int end = dynamicObject.getInt("endtime");
                if (start == -1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"OtSubValidator_7", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
                if (end == -1) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6309\u8981\u6c42\u586b\u5199\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u3002", (String)"OtSubValidator_8", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
                if (start < end) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u7ed3\u675f\u65f6\u95f4\u201d\u9700\u5927\u4e8e\u201c\u5f00\u59cb\u65f6\u95f4\u201d\u3002", (String)"OtSubValidator_9", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
        } else {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6263\u9664\u56fa\u5b9a\u65f6\u6bb5\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"OtSubValidator_10", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkIsSummitDirectly() {
        return this.getOption().containsVariable("param_is_submit_directly");
    }
}

