/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.quota.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtp.enums.quota.QTAttItemDescEnum;

public class QTCarryDownValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        this.numberValueMustInputValidate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String number = dynamicObject.getString("number");
            this.checkAttitemEqual(dynamicObject, dataEntity, number);
        }
    }

    private void numberValueMustInputValidate() {
        for (ExtendedDataEntity extDataEntity : this.getDataEntities()) {
            String cdvDelay;
            String cdMode;
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            String dpvDelay = dataEntity.getString("dpvdelay");
            if ("1".equals(dpvDelay)) {
                this.validateNumberFieldGT0(extDataEntity, dataEntity, "dpvdelayvalue");
            }
            if ("B".equals(cdMode = dataEntity.getString("cdmode"))) {
                String cdtype;
                String cdEDelay;
                String cdSDelay = dataEntity.getString("cdsdelay");
                if ("1".equals(cdSDelay)) {
                    this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdsdelayvalue");
                }
                if ("1".equals(cdEDelay = dataEntity.getString("cdedelay"))) {
                    this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdedelayvalue");
                }
                if (!"A".equals(cdtype = dataEntity.getString("cdtype"))) continue;
                this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdvalue");
                continue;
            }
            if (!"C".equals(cdMode) || !"1".equals(cdvDelay = dataEntity.getString("cdvdelay"))) continue;
            this.validateNumberFieldGT0(extDataEntity, dataEntity, "cdvdelayvalue");
        }
    }

    private void validateNumberFieldGT0(ExtendedDataEntity extDataEntity, DynamicObject dataEntity, String numberField) {
        BigDecimal numberVal = dataEntity.getBigDecimal(numberField);
        if (numberVal == null || BigDecimal.ZERO.compareTo(numberVal) >= 0) {
            IDataEntityProperty field = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)numberField);
            this.addErrorMessage(extDataEntity, field == null ? "" : this.getValueGT0Tip(field.getDisplayName().getLocaleValue()));
        }
    }

    private String getValueGT0Tip(String fieldName) {
        return ResManager.loadKDString((String)"\u201c{0}\u201d\u9700\u5927\u4e8e0\u3002", (String)"QTCarryDownValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[]{fieldName});
    }

    private void checkAttitemEqual(DynamicObject dynamicObject, ExtendedDataEntity dataEntity, String number) {
        ArrayList<String> pros = new ArrayList<String>();
        String cdMode = dynamicObject.getString("cdmode");
        pros.add("departduration");
        pros.add("slmentattitem");
        if ("A".equals(cdMode)) {
            pros.add("pastduration");
        } else if ("B".equals(cdMode)) {
            pros.add("cdpastduration");
            pros.add("cdduration");
        } else {
            pros.add("cdduration");
        }
        LinkedHashMap map = Maps.newLinkedHashMapWithExpectedSize((int)pros.size());
        for (String string : pros) {
            String pro = string + "." + "id";
            Long itemId = dynamicObject.getLong(pro);
            List<String> proList = map.get(itemId) != null ? (List)map.get(itemId) : new ArrayList();
            String msg = WTCSymbolMultiLanguageUtil.getOpenQuotaSymbol() + QTAttItemDescEnum.getEnumDesc((String)string) + WTCSymbolMultiLanguageUtil.getCloseQuotaSymbol();
            proList.add(msg);
            map.put(itemId, proList);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            String itemMsg = String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCaesuraSymbol(), (Iterable)entry.getValue());
            String msg = ResManager.loadKDString((String)"\u7f16\u7801{0}\u7684\u5b9a\u989d\u7ed3\u8f6c\u914d\u7f6e\uff0c{1}\u4e0d\u80fd\u4e3a\u540c\u4e00\u4e2a\u8003\u52e4\u9879\u76ee\u3002", (String)"QTCarryDownValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[]{number, itemMsg});
            this.addErrorMessage(dataEntity, msg);
        }
    }
}

