/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.quota.validator;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.hr.ruleengine.infos.ConditionExpressInfo;
import kd.bos.ext.hr.ruleengine.infos.ConditionInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleConditionInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtbs.common.util.WTCSerializationUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.business.ex.ExConditionFilterService;
import kd.wtc.wtp.enums.quota.QTAttItemDescEnum;

public class QTGenConfigValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String genType = dynamicObject.getString("qttype.gentype");
            String number = dynamicObject.getString("number");
            DynamicObjectCollection collections = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
            for (DynamicObject entryDy : collections) {
                boolean isEmpty;
                boolean isEquale;
                int seq = entryDy.getInt("seq");
                this.checkAttitemEqual(entryDy, genType, dataEntity, number, seq);
                String conditionStr = entryDy.getString("conditionfilter");
                Long attitemId = entryDy.getLong("attitem.id");
                if ("A".equals(genType) || (isEquale = this.dyConditionAndAttiemIsOnly(collections, isEmpty = StringUtils.isEmpty((CharSequence)conditionStr), conditionStr, attitemId, seq))) continue;
                String param = "";
                param = StringUtils.isEmpty((CharSequence)conditionStr) ? ExConditionFilterService.getUnLimitStr() : ExConditionFilterService.getStrOfSettingCondition((String)conditionStr);
                String msg = ResManager.loadKDString((String)"\u7f16\u7801{0}\u7684\u5b9a\u989d\u751f\u6210\u914d\u7f6e\u4e0b\uff0c\u573a\u666f\u6761\u4ef6\uff1a\u5f53\u524d\u573a\u666f\u6761\u4ef6\u4e0b{1}\uff0c{2}\u5df2\u5b58\u5728\u76f8\u540c\u7684\u8ba1\u7b97\u89c4\u5219\uff0c\u8bf7\u66f4\u6362\u52a8\u6001\u751f\u6210\u7684\u8003\u52e4\u9879\u76ee\u6216\u4fee\u6539\u573a\u666f\u6761\u4ef6\u3002", (String)"QTGenConfigValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[]{number, param, entryDy.getString("attitem.name")});
                this.addErrorMessage(dataEntity, msg);
            }
        }
    }

    private void checkAttitemEqual(DynamicObject dynamicObject, String genType, ExtendedDataEntity dataEntity, String number, int seq) {
        ArrayList<String> pros = new ArrayList<String>();
        pros.add("enjoyattitem");
        pros.add("usableattitem");
        pros.add("resultattitem");
        if ("B".equals(genType)) {
            pros.add("maxattitem");
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)pros.size());
        for (String string : pros) {
            String pro = string + "." + "id";
            Long itemId = dynamicObject.getLong(pro);
            List<String> proList = map.get(itemId) != null ? (List)map.get(itemId) : new ArrayList();
            String msg = WTCSymbolMultiLanguageUtil.getOpenQuotaSymbol() + QTAttItemDescEnum.getEnumDesc((String)string) + WTCSymbolMultiLanguageUtil.getCloseQuotaSymbol();
            proList.add(msg);
            map.put(itemId, proList);
        }
        for (Map.Entry entry : map.entrySet()) {
            if (((List)entry.getValue()).size() <= 1) continue;
            String itemMsg = String.join((CharSequence)WTCSymbolMultiLanguageUtil.getCaesuraSymbol(), (Iterable)entry.getValue());
            String msg = ResManager.loadKDString((String)"\u7f16\u7801{0}\u7684\u5b9a\u989d\u751f\u6210\u914d\u7f6e\uff0c\u5176\u4e2d\u5206\u5f55#{1}\uff0c{2}\u4e0d\u80fd\u4e3a\u540c\u4e00\u4e2a\u8003\u52e4\u9879\u76ee\u3002", (String)"QTGenConfigValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[]{number, seq, itemMsg});
            this.addErrorMessage(dataEntity, msg);
        }
    }

    private boolean dyConditionAndAttiemIsOnly(DynamicObjectCollection dynamicObjects, boolean emptyJudge, String conditionFilter, Long newAttitemId, int seq) {
        if (CollectionUtils.isEmpty((Collection)dynamicObjects)) {
            return true;
        }
        List<List<String>> newConditionStr = this.splitCondition(conditionFilter);
        for (DynamicObject dy : dynamicObjects) {
            List<String> strs;
            Long attitemId;
            Long newSeq = dy.getLong("seq");
            if (newSeq <= (long)seq || !(attitemId = Long.valueOf(dy.getLong("attitem.id"))).equals(newAttitemId)) continue;
            String conditionStr = dy.getString("conditionfilter");
            if (StringUtils.isEmpty((CharSequence)conditionStr) && emptyJudge) {
                return false;
            }
            if (emptyJudge) continue;
            List<List<String>> oldConditionStr = this.splitCondition(conditionStr);
            if (newConditionStr.size() != oldConditionStr.size()) continue;
            boolean isEqual = true;
            Iterator<List<String>> iterator = newConditionStr.iterator();
            while (iterator.hasNext() && (isEqual = this.isEqualCondition(strs = iterator.next(), oldConditionStr))) {
            }
            if (!isEqual) continue;
            return false;
        }
        return true;
    }

    private boolean isEqualCondition(List<String> strs, List<List<String>> oldConditionStr) {
        boolean tag = true;
        for (List<String> oldStrs : oldConditionStr) {
            tag = true;
            if (oldStrs.size() != strs.size()) {
                tag = false;
                continue;
            }
            for (String str : strs) {
                if (oldStrs.contains(str)) continue;
                tag = false;
                break;
            }
            if (!tag) continue;
            break;
        }
        return tag;
    }

    private List<List<String>> splitCondition(String conditionFilter) {
        List<List<String>> expressList = new ArrayList<List<String>>();
        if (HRStringUtils.isEmpty((String)conditionFilter)) {
            return expressList;
        }
        RuleConditionInfo accessDto = (RuleConditionInfo)WTCSerializationUtils.fromJsonString((String)conditionFilter, RuleConditionInfo.class);
        List conditionList = accessDto.getConditionList();
        if (conditionList == null || conditionList.isEmpty()) {
            return expressList;
        }
        HashMap map = Maps.newHashMapWithExpectedSize((int)conditionList.size());
        for (ConditionInfo dto : conditionList) {
            String part1 = dto.getParam();
            String part2 = dto.getOperators();
            String part3 = " \"" + dto.getDisplayValue() + "\"";
            String str = "";
            str = RuleOperatorEnum.IS_NULL.getValue().equals(dto.getOperators()) || RuleOperatorEnum.IS_NOT_NULL.getValue().equals(dto.getOperators()) ? part1 + part2 : part1 + part2 + part3;
            map.put(dto.getName(), str);
        }
        if (map.isEmpty()) {
            return expressList;
        }
        List expressInfos = accessDto.getConditionExpressList();
        expressList.add(new ArrayList());
        ArrayList<List<String>> bracketList = new ArrayList<List<String>>();
        boolean isBracket = false;
        for (ConditionExpressInfo expressInfo : expressInfos) {
            boolean isCloseBracket = false;
            if (expressInfo.getLeftBracket() != null && "(".equals(expressInfo.getLeftBracket().trim())) {
                bracketList = new ArrayList();
                bracketList.add(new ArrayList());
                isBracket = true;
            }
            if (expressInfo.getRightBracket() != null && ")".equals(expressInfo.getRightBracket().trim())) {
                isCloseBracket = true;
                isBracket = false;
            }
            if (expressInfo.getLogical() != null && "or".equals(expressInfo.getLogical().trim())) {
                this.splitOrCondition(isBracket, isCloseBracket, bracketList, expressList, (String)map.get(expressInfo.getName()));
                continue;
            }
            this.splitAndCondition(isBracket, isCloseBracket, bracketList, expressList, (String)map.get(expressInfo.getName()));
        }
        expressList.forEach(list -> {
            List conditionStrs = list.stream().distinct().collect(Collectors.toList());
            list.clear();
            list.addAll(conditionStrs);
        });
        expressList = expressList.stream().distinct().collect(Collectors.toList());
        return expressList;
    }

    private void splitAndCondition(boolean isBracket, boolean isCloseBracket, List<List<String>> bracketList, List<List<String>> expressList, String conditionStr) {
        if (isBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
        } else if (isCloseBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
            if (bracketList.size() == 1) {
                expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
            } else {
                Collections.sort(bracketList.get(bracketList.size() - 1));
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                for (List<String> list : bracketList) {
                    List conditionStrs = list.stream().distinct().collect(Collectors.toList());
                    list.clear();
                    list.addAll(conditionStrs);
                }
                if ((bracketList = bracketList.stream().distinct().collect(Collectors.toList())).size() == 1) {
                    expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                } else {
                    String str = JSON.toJSONString(bracketList);
                    expressList.get(expressList.size() - 1).add(str);
                }
            }
        } else {
            expressList.get(expressList.size() - 1).add(conditionStr);
        }
    }

    private void splitOrCondition(boolean isBracket, boolean isCloseBracket, List<List<String>> bracketList, List<List<String>> expressList, String conditionStr) {
        ArrayList lists = new ArrayList();
        if (isBracket) {
            List<String> tempList = bracketList.get(bracketList.size() - 1);
            tempList.add(conditionStr);
            Collections.sort(bracketList.get(bracketList.size() - 1));
            bracketList.add(lists);
        } else if (!isBracket && isCloseBracket) {
            bracketList.get(bracketList.size() - 1).add(conditionStr);
            if (bracketList.size() == 1) {
                expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                expressList.add(lists);
            } else {
                Collections.sort(bracketList.get(bracketList.size() - 1));
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                bracketList = bracketList.stream().sorted(Comparator.comparing(v -> (String)v.get(0))).collect(Collectors.toList());
                for (List<String> list : bracketList) {
                    List conditionStrs = list.stream().distinct().collect(Collectors.toList());
                    list.clear();
                    list.addAll(conditionStrs);
                }
                if ((bracketList = bracketList.stream().distinct().collect(Collectors.toList())).size() == 1) {
                    expressList.get(expressList.size() - 1).addAll((Collection<String>)bracketList.get(0));
                } else {
                    String str = JSON.toJSONString(bracketList);
                    expressList.get(expressList.size() - 1).add(str);
                }
                expressList.add(lists);
            }
        } else {
            expressList.get(expressList.size() - 1).add(conditionStr);
            expressList.add(lists);
        }
    }
}

