/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.quota.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.enums.quota.QTAttItemDescEnum;

public class QTUseConfigValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        this.numberValueMustInputValidate();
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String number = dynamicObject.getString("number");
            this.checkAttitemEqual(dynamicObject, dataEntity, number);
        }
    }

    private void numberValueMustInputValidate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            String eDelay;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String sDelay = dataEntity.getString("sdelay");
            if ("1".equals(sDelay)) {
                this.validateNumberFieldGT0(extendedDataEntity, dataEntity, "startdelay");
            }
            if (!"1".equals(eDelay = dataEntity.getString("edelay"))) continue;
            this.validateNumberFieldGT0(extendedDataEntity, dataEntity, "enddelay");
        }
    }

    private void validateNumberFieldGT0(ExtendedDataEntity extDataEntity, DynamicObject dataEntity, String numberField) {
        BigDecimal numberVal = dataEntity.getBigDecimal(numberField);
        if (numberVal == null || BigDecimal.ZERO.compareTo(numberVal) >= 0) {
            IDataEntityProperty field = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)numberField);
            this.addErrorMessage(extDataEntity, field == null ? "" : this.getValueGT0Tip(field.getDisplayName().getLocaleValue()));
        }
    }

    private String getValueGT0Tip(String fieldName) {
        return ResManager.loadKDString((String)"\u201c{0}\u201d\u9700\u5927\u4e8e0\u3002", (String)"QTCarryDownValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[]{fieldName});
    }

    private void checkAttitemEqual(DynamicObject dynamicObject, ExtendedDataEntity dataEntity, String number) {
        HashMap<Long, String> map = new HashMap<Long, String>();
        ArrayList<String> pros = new ArrayList<String>();
        pros.add("freeze");
        pros.add("useduration");
        for (String str : pros) {
            String pro = str + "." + "id";
            Long itemId = dynamicObject.getLong(pro);
            String oldItem = (String)map.get(itemId);
            if (!StringUtils.isEmpty((CharSequence)oldItem)) {
                String msg = ResManager.loadKDString((String)"\u7f16\u7801{0}\u7684\u5b9a\u989d\u4f7f\u7528\u914d\u7f6e\uff0c\u201c{1}\u201d\u3001\u201c{2}\u201d\u4e0d\u80fd\u4e3a\u540c\u4e00\u4e2a\u8003\u52e4\u9879\u76ee\u3002", (String)"QTUseConfigValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[]{number, QTAttItemDescEnum.getEnumDesc((String)oldItem), QTAttItemDescEnum.getEnumDesc((String)str)});
                this.addErrorMessage(dataEntity, msg);
                continue;
            }
            map.put(itemId, str);
        }
    }
}

