/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.ruleenging;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRDynamicObjectUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.history.service.WTCHisServiceHelper;
import kd.wtc.wtbs.business.servicehelper.WTCServiceHelper;
import kd.wtc.wtp.business.ruleenging.RuleEngingHelper;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.common.constants.RuleEngingConstants;
import kd.wtc.wtp.opplugin.web.ruleenging.validator.RuleEngingSaveValidator;

public class RuleEngingSaveOp
extends HRDataBaseOp
implements RuleEngingConstants {
    private static final String HISVERSION = "hisversion";

    public void onAddValidators(AddValidatorsEventArgs evt) {
        evt.addValidator((AbstractValidator)new RuleEngingSaveValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        args.getFieldKeys().add("setruleway");
        args.getFieldKeys().add(HISVERSION);
    }

    public void endOperationTransaction(EndOperationTransactionArgs evt) {
        super.endOperationTransaction(evt);
        String modelTypeForWf = (String)this.getOption().getVariables().get("modeltypeforwf");
        if ("list".equals(modelTypeForWf)) {
            return;
        }
        this.saveRuleAssociation(evt.getDataEntities());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(args);
        String operationKey = args.getOperationKey();
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_ruleassociation");
        block12: for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            DynamicObject dy;
            String modelTypeForWf = (String)this.getOption().getVariables().get("modeltypeforwf");
            if ("list".equals(modelTypeForWf)) {
                Object pkValue = dataEntity.getPkValue();
                HRBaseServiceHelper baseServiceHelper = new HRBaseServiceHelper(dataEntity.getDataEntityType().getName());
                dataEntity = baseServiceHelper.loadSingle(pkValue);
            }
            if ((dy = RuleEngingHelper.queryPolicyDataByPlanId((long)dataEntity.getLong("id"))) == null) continue;
            String setRuleWay = dy.getString("ruleset");
            if (RuleEngingService.checkRuleEngingEnableSet() || !"2".equals(setRuleWay)) {
                this.handleOldRuleEngineData(helper, dataEntity);
            }
            switch (operationKey) {
                case "audit": {
                    this.saveHisRuleEngineData(helper, dataEntity);
                    continue block12;
                }
                case "his_disable": 
                case "enable": {
                    String status = dataEntity.getString("status");
                    if (!"C".equals(status)) continue block12;
                    this.saveHisRuleEngineData(helper, dataEntity);
                    continue block12;
                }
                case "auditconfirmchange": 
                case "confirmchange": {
                    this.handleOtherRuleEngingVersion(helper, dataEntity);
                    continue block12;
                }
            }
        }
    }

    private void handleOtherRuleEngingVersion(HRBaseServiceHelper helper, DynamicObject dataEntity) {
        if (!Objects.equals(dataEntity.getPkValue(), dataEntity.get("boid"))) {
            long basedataid;
            HRBaseServiceHelper planHelper;
            DynamicObject planBoDy;
            long policyId = 0L;
            DynamicObject currentPolicyDy = RuleEngingHelper.queryPolicyDataByPlanId((long)dataEntity.getLong("id"));
            if (currentPolicyDy != null) {
                policyId = currentPolicyDy.getLong("policyid");
            }
            if ((planBoDy = (planHelper = new HRBaseServiceHelper(dataEntity.getDataEntityType().getName())).queryOne("sourcevid", (Object)(basedataid = dataEntity.getLong("boid")))) != null && dataEntity.getLong("id") == planBoDy.getLong("sourcevid")) {
                Object pkValue = dataEntity.getPkValue();
                DynamicObject versionAssociationDy = RuleEngingHelper.queryPolicyDataByPlanId((long)((Long)pkValue));
                DynamicObject dynamicObject = helper.queryOne("policyid, ruleset", new QFilter("planid", "=", (Object)dataEntity.getLong("boid")));
                if (dynamicObject == null) {
                    dynamicObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtp_ruleassociation"));
                    dynamicObject.set("planid", (Object)basedataid);
                    dynamicObject.set("policyid", (Object)policyId);
                    dynamicObject.set("ruleset", (Object)versionAssociationDy.getString("ruleset"));
                    helper.saveOne(dynamicObject);
                } else {
                    dynamicObject.set("policyid", (Object)policyId);
                    dynamicObject.set("ruleset", (Object)versionAssociationDy.getString("ruleset"));
                    helper.updateOne(dynamicObject);
                }
            }
            HRBaseServiceHelper serviceHelper = new HRBaseServiceHelper(dataEntity.getDataEntityType().getName());
            DynamicObject[] allVersionDys = serviceHelper.query("id, hisversion, bsed, bsled, datastatus", new QFilter[]{new QFilter("boid", "=", (Object)basedataid), WTCHisServiceHelper.dataStatusValidQFilter()}, "bsed");
            Set allVersionId = Arrays.stream(allVersionDys).map(allVersionDy -> allVersionDy.getLong("id")).collect(Collectors.toSet());
            DynamicObject[] allAssociationDys = helper.queryOriginalArray("planid, policyid, ruleset", new QFilter[]{new QFilter("planid", "in", allVersionId)});
            List successPkIds = this.getOperationResult().getSuccessPkIds();
            if (successPkIds.isEmpty()) {
                return;
            }
            String successMaxVersion = Arrays.stream(allVersionDys).filter(allVersionDy -> successPkIds.contains(allVersionDy.getLong("id"))).map(successPkIdDy -> successPkIdDy.getString(HISVERSION)).max(String::compareTo).get();
            List newVersionDys = Arrays.stream(allVersionDys).filter(allVersionDy -> allVersionDy.getString(HISVERSION).compareTo(successMaxVersion) > 0).collect(Collectors.toList());
            if (newVersionDys.isEmpty()) {
                return;
            }
            String successMinVersion = Arrays.stream(allVersionDys).filter(allVersionDy -> successPkIds.contains(allVersionDy.getLong("id"))).map(successPkIdDy -> successPkIdDy.getString(HISVERSION)).min(String::compareTo).get();
            List oldVersionDys = Arrays.stream(allVersionDys).filter(allVersionDy -> allVersionDy.getString(HISVERSION).compareTo(successMinVersion) < 0 && HRStringUtils.isNotEmpty((String)allVersionDy.getString(HISVERSION))).collect(Collectors.toList());
            HashMap<Long, Long> map = new HashMap<Long, Long>(newVersionDys.size());
            block0: for (DynamicObject newVersionDy : newVersionDys) {
                for (int i = 0; i < oldVersionDys.size(); ++i) {
                    DynamicObject oldVersionDy = (DynamicObject)oldVersionDys.get(i);
                    if (newVersionDy.getDate("bsed").compareTo(oldVersionDy.getDate("bsed")) <= 0 && i != oldVersionDys.size() - 1) continue;
                    map.put(newVersionDy.getLong("id"), oldVersionDy.getLong("id"));
                    continue block0;
                }
            }
            DynamicObjectCollection resultDys = new DynamicObjectCollection();
            MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtp_ruleassociation");
            for (Map.Entry mapEntry : map.entrySet()) {
                Long oldPlanId = (Long)mapEntry.getValue();
                Optional<DynamicObject> any = Arrays.stream(allAssociationDys).filter(allAssociationDy -> oldPlanId.equals(allAssociationDy.getLong("planid"))).findAny();
                if (!any.isPresent()) continue;
                DynamicObject sourceDy = any.get();
                Long currentPlanId = (Long)mapEntry.getKey();
                DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)metaType);
                dynamicObject.set("planid", (Object)currentPlanId);
                dynamicObject.set("policyid", (Object)sourceDy.getLong("policyid"));
                dynamicObject.set("ruleset", (Object)sourceDy.getString("ruleset"));
                resultDys.add((Object)dynamicObject);
            }
            helper.save(resultDys);
        }
    }

    private void saveRuleAssociation(DynamicObject[] dataEntities) {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtp_ruleassociation");
        for (DynamicObject dataEntity : dataEntities) {
            String setRuleWay = this.getOption().getVariableValue("setruleway");
            if ("2".equals(setRuleWay)) {
                this.addPolicy(dataEntity);
            } else {
                QFilter idQFilter = new QFilter("planid", "=", dataEntity.getPkValue());
                DynamicObject dy = helper.queryOne("ruleset", new QFilter[]{idQFilter});
                if (dy != null) {
                    dy.set("ruleset", (Object)"1");
                    helper.updateOne(dy);
                }
                setRuleWay = "1";
            }
            this.saveRuleAssociation(helper, dataEntity, setRuleWay);
        }
    }

    private void saveRuleAssociation(HRBaseServiceHelper helper, DynamicObject dataEntity, String setRuleWay) {
        DynamicObject relateObject = helper.loadDynamicObject(new QFilter[]{new QFilter("planid", "=", (Object)dataEntity.getLong("id"))});
        if (relateObject == null) {
            relateObject = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtp_ruleassociation"));
        }
        relateObject.set("planid", (Object)dataEntity.getLong("id"));
        relateObject.set("policyid", (Object)dataEntity.getLong("policyid"));
        relateObject.set("ruleset", (Object)setRuleWay);
        helper.saveOne(relateObject);
    }

    private void addPolicy(DynamicObject pageDy) {
        String ruleData = this.getOption().getVariableValue("entryrulelist");
        Map policyMap = (Map)JSONArray.parseObject((String)ruleData, Map.class);
        policyMap.put("id", ID.genLongId());
        policyMap.put("createbu", pageDy.getLong("createorg.id"));
        String codeRuleNumber = RuleEngingService.getCodeRuleNumber();
        policyMap.put("number", pageDy.getDataEntityType().getName() + codeRuleNumber);
        String name = pageDy.getString("name");
        name = name.length() > 30 ? name.substring(0, 30) : name;
        policyMap.put("name", name + codeRuleNumber);
        List list = (List)policyMap.get("entryrulelist");
        for (Map map : list) {
            map.put("id", ID.genLongId());
        }
        ((JSONObject)((JSONArray)policyMap.get("entrybulist")).get(0)).put("entitybu", (Object)Long.valueOf(String.valueOf(((JSONObject)((JSONArray)policyMap.get("entrybulist")).get(0)).get((Object)"entitybu"))));
        Map resultMap = (Map)WTCServiceHelper.invokeHRMPService((String)"brm", (String)"IBRMPolicyService", (String)"addPolicy", (Object[])new Object[]{policyMap});
        if (!resultMap.containsKey("resultCode")) {
            this.clearOption();
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u4e2d\u53f0\u89c4\u5219\u5f15\u64ce\u4fdd\u5b58\u63a5\u53e3\u5931\u8d25\u3002", (String)"RuleEngingSaveOp_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
        if ((Integer)resultMap.get("resultCode") == 500) {
            this.clearOption();
            throw new KDBizException((String)resultMap.get("errorMsg"));
        }
        Long policyId = (Long)resultMap.get("policyId");
        pageDy.set("policyid", (Object)policyId);
    }

    private void clearOption() {
        this.getOption().removeVariable("vid");
        this.getOption().removeVariable("WTCHisSaveOp_update");
        this.getOption().removeVariable("confirmresult");
    }

    private void updateOldRuleEngineData(HRBaseServiceHelper helper, DynamicObject dataEntity) {
        long policyId = dataEntity.getLong("policyid");
        DynamicObject dynamicObject = helper.queryOne("policyid, planid", new QFilter[]{new QFilter("planid", "=", dataEntity.getPkValue())});
        if (Objects.nonNull(dynamicObject)) {
            dynamicObject.set("policyid", (Object)policyId);
        } else {
            MainEntityType metaType = MetadataServiceHelper.getDataEntityType((String)"wtbd_daterange");
            dynamicObject = new DynamicObject((DynamicObjectType)metaType);
            dynamicObject.set("planid", (Object)dataEntity.getLong("id"));
            dynamicObject.set("policyid", (Object)dataEntity.getLong("policyid"));
            dynamicObject.set("ruleset", (Object)"2");
        }
        helper.saveOne(dynamicObject);
    }

    private void saveHisRuleEngineData(HRBaseServiceHelper helper, DynamicObject dataEntity) {
        long boid = dataEntity.getLong("boid");
        long currentHisId = this.getCurrentHisId(boid, dataEntity.getDataEntityType().getName());
        DynamicObject ruleOldAssociationDy = helper.loadDynamicObject(new QFilter[]{new QFilter("planid", "=", (Object)boid)});
        DynamicObject ruleNewAssociationDy = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtp_ruleassociation"));
        HRDynamicObjectUtils.copy((DynamicObject)ruleOldAssociationDy, (DynamicObject)ruleNewAssociationDy);
        ruleNewAssociationDy.set("planid", (Object)currentHisId);
        ruleNewAssociationDy.set("id", (Object)DB.genGlobalLongId());
        helper.saveOne(ruleNewAssociationDy);
    }

    private void handleOldRuleEngineData(HRBaseServiceHelper helper, DynamicObject dataEntity) {
        if ("1".equals(dataEntity.getString("datastatus"))) {
            long boid = dataEntity.getLong("boid");
            QFilter idQFilter = new QFilter("planid", "=", (Object)boid);
            DynamicObject dy = helper.queryOne("ruleset", new QFilter[]{idQFilter});
            if (dy != null) {
                dy.set("ruleset", (Object)"1");
                helper.updateOne(dy);
            }
        }
    }

    private long getCurrentHisId(long boid, String formId) {
        HRBaseServiceHelper currentPageHelper = new HRBaseServiceHelper(formId);
        QFilter qFilter = new QFilter("id", "=", (Object)boid);
        DynamicObject boDy = currentPageHelper.queryOriginalOne("sourcevid", qFilter);
        long sourceId = boDy.getLong("sourcevid");
        QFilter versionQFilter = new QFilter("id", "=", (Object)sourceId);
        DynamicObject currentPageDy = currentPageHelper.queryOriginalOne("id", versionQFilter);
        return currentPageDy.getLong("id");
    }
}

