/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.ruleenging.validator;

import com.alibaba.fastjson.JSONArray;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.hr.ruleengine.infos.ResultInfo;
import kd.bos.ext.hr.ruleengine.infos.RuleResultInfo;
import kd.bos.toolkit.utils.SerializationUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.common.enums.bill.BillTypeEnum;
import kd.wtc.wtbs.common.predata.wtbd.PreBrmScene;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtp.business.ruleenging.RuleEngingService;
import kd.wtc.wtp.common.constants.RuleEngingConstants;

public class RuleEngingSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        super.validate();
        String modelTypeForWf = (String)this.getOption().getVariables().get("modeltypeforwf");
        if ("list".equals(modelTypeForWf)) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject pageDy = dataEntity.getDataEntity();
            String setRuleWay = this.getOption().getVariableValue("setruleway");
            if (!"2".equals(setRuleWay)) continue;
            this.policyDataValidate(dataEntity, pageDy);
        }
    }

    private String checkDefaultRulMustInput(String resultJson, Long sceneId) {
        if (PreBrmScene.PD_WTC_SCENE_EXCEPTION_V2.equals(sceneId) && !this.checkHashRule(resultJson, "wtp_exrule")) {
            return ResManager.loadKDString((String)"\u9ed8\u8ba4\u7ed3\u679c\u7684\u5f02\u5e38\u89c4\u5219\u5fc5\u586b", (String)"RuleEngingSaveValidator_6", (String)"wtc-wtp-opplugin", (Object[])new Object[0]);
        }
        if ((PreBrmScene.PD_WTC_SCENE_OTP_V2.equals(sceneId) || PreBrmScene.PD_WTC_SCENE_OTP_V3.equals(sceneId)) && !this.checkHashRule(resultJson, "rule")) {
            return ResManager.loadKDString((String)"\u9ed8\u8ba4\u7ed3\u679c\u7684{0}\u89c4\u5219\u5fc5\u586b", (String)"RuleEngingSaveValidator_4", (String)"wtc-wtp-opplugin", (Object[])new Object[]{BillTypeEnum.OVERTIMEBILL.getBillName()});
        }
        return null;
    }

    private String checkRulMustInput(List<Map<String, Object>> list, Long sceneId) {
        boolean hashRule;
        Object ruleenable;
        if (PreBrmScene.PD_WTC_SCENE_EXCEPTION_V2.equals(sceneId)) {
            for (Map<String, Object> ruleMap : list) {
                ruleenable = ruleMap.get("ruleenable");
                hashRule = this.checkHashRule(String.valueOf(ruleMap.get("filterresult")), "wtp_exrule");
                if (!Boolean.TRUE.toString().equals(String.valueOf(ruleenable)) || hashRule) continue;
                return ResManager.loadKDString((String)"{0}\u7684\u8fd4\u56de\u7ed3\u679c\uff0c\u5f02\u5e38\u89c4\u5219\u5fc5\u586b", (String)"RuleEngingSaveValidator_5", (String)"wtc-wtp-opplugin", (Object[])new Object[]{ruleMap.get("rulename")});
            }
        }
        if (PreBrmScene.PD_WTC_SCENE_OTP_V2.equals(sceneId) || PreBrmScene.PD_WTC_SCENE_OTP_V3.equals(sceneId)) {
            for (Map<String, Object> ruleMap : list) {
                ruleenable = ruleMap.get("ruleenable");
                hashRule = this.checkHashRule(String.valueOf(ruleMap.get("filterresult")), "rule");
                if (!Boolean.TRUE.toString().equals(String.valueOf(ruleenable)) || hashRule) continue;
                return ResManager.loadKDString((String)"{0}\u7684\u8fd4\u56de\u7ed3\u679c\uff0c{1}\u89c4\u5219\u5fc5\u586b", (String)"RuleEngingSaveValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[]{ruleMap.get("rulename"), BillTypeEnum.OVERTIMEBILL.getBillName()});
            }
        }
        return null;
    }

    private boolean checkHashRule(String resultJson, String tag) {
        if ("null".equals(resultJson) || WTCStringUtils.isEmpty((String)resultJson)) {
            return false;
        }
        boolean hashRule = false;
        RuleResultInfo ruleResultInfo = (RuleResultInfo)SerializationUtils.fromJsonString((String)resultJson, RuleResultInfo.class);
        for (ResultInfo resultInfo : ruleResultInfo.getResultList()) {
            hashRule = hashRule || resultInfo.getParam().startsWith(tag);
        }
        return hashRule;
    }

    private void policyDataValidate(ExtendedDataEntity dataEntity, DynamicObject pageDy) {
        String ruleData = this.getOption().getVariableValue("entryrulelist");
        if (HRStringUtils.isEmpty((String)ruleData)) {
            return;
        }
        Map policyMap = (Map)JSONArray.parseObject((String)ruleData, Map.class);
        List list = (List)policyMap.get("entryrulelist");
        if (list.isEmpty()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u6761\u4ef6\u548c\u7ed3\u679c\u3002", (String)"RuleEngingSaveValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            return;
        }
        Object sceneObj = policyMap.get("scene");
        Long sceneId = Long.valueOf(sceneObj == null ? "0" : sceneObj.toString());
        String errorMsg = this.checkRulMustInput(list, sceneId);
        if (WTCStringUtils.isNotEmpty((String)errorMsg)) {
            this.addErrorMessage(dataEntity, errorMsg);
            return;
        }
        String formId = pageDy.getDataEntityType().getName();
        String planFlag = RuleEngingConstants.Plan.getPlanFlagByFormId((String)formId);
        String ruleFormId = RuleEngingConstants.Plan.getRuleFormIdByPlanFlag((String)planFlag);
        this.comparePlanBsedWithRuleFirstBsed(list, pageDy, dataEntity, ruleFormId);
        boolean retrunDefault = Boolean.parseBoolean(String.valueOf(policyMap.get("defaultresultap")));
        if (retrunDefault) {
            String resultJson = String.valueOf(policyMap.get("results"));
            resultJson = "null".equals(resultJson) ? null : resultJson;
            Map map = RuleEngingService.validDefaultResult((String)resultJson);
            boolean isSuccess = Boolean.parseBoolean(String.valueOf(map.get("isSuccess")));
            if (!isSuccess) {
                this.addErrorMessage(dataEntity, String.valueOf(map.get("msg")));
                return;
            }
            this.checkDefaultResult(pageDy, dataEntity, ruleFormId, resultJson, ResManager.loadKDString((String)"\u9ed8\u8ba4\u7ed3\u679c", (String)"RuleEngingSaveValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            errorMsg = this.checkDefaultRulMustInput(resultJson, sceneId);
            if (WTCStringUtils.isNotEmpty((String)errorMsg)) {
                this.addErrorMessage(dataEntity, errorMsg);
                return;
            }
        }
        policyMap.put("id", 0L);
        policyMap.put("createbu", pageDy.getLong("createorg.id"));
    }

    private void comparePlanBsedWithRuleFirstBsed(List<Map<String, Object>> list, DynamicObject pageDy, ExtendedDataEntity dataEntity, String ruleFormId) {
        List ruleList = list.stream().map(ruleMap -> String.valueOf(ruleMap.get("filterresult"))).collect(Collectors.toList());
        for (String resultJson : ruleList) {
            this.checkDefaultResult(pageDy, dataEntity, ruleFormId, resultJson, ResManager.loadKDString((String)"\u8fd4\u56de\u7ed3\u679c", (String)"RuleEngingSaveValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkDefaultResult(DynamicObject pageDy, ExtendedDataEntity dataEntity, String ruleFormId, String resultJson, String tipTitle) {
        List collect = Arrays.stream(RuleEngingConstants.Plan.values()).filter(value -> ruleFormId.equals(value.getPlanRule())).collect(Collectors.toList());
        if (collect.isEmpty()) {
            return;
        }
        RuleEngingConstants.Plan plan = (RuleEngingConstants.Plan)collect.get(0);
        Date planStartDate = pageDy.getDate("bsed");
        String tips = RuleEngingService.compareBsedWithPlanFirstBsed((String)resultJson, (Date)planStartDate, (String)ruleFormId, (String)plan.getPlanName().loadKDString(), (String)tipTitle);
        if (HRStringUtils.isNotEmpty((String)tips)) {
            this.addErrorMessage(dataEntity, tips);
        }
        if (HRStringUtils.isNotEmpty((String)(tips = RuleEngingService.getInstance().customValidator(resultJson, plan.getPlanFlag(), planStartDate)))) {
            this.addErrorMessage(dataEntity, tips);
        }
    }
}

