/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.supple;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDynamicFormOp;
import kd.wtc.wtp.constants.supple.SuppleKDString;

public class SuppleCountByReasonLimitOp
extends HRDynamicFormOp {
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length <= 0) {
                    return;
                }
                this.doValidate(dataEntities);
            }

            private void doValidate(ExtendedDataEntity[] dataEntities) {
                String errorMsg = SuppleKDString.mustInput();
                DataEntityPropertyCollection dataEntityProperties = dataEntities[0].getDataEntity().getDataEntityType().getProperties();
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    Object entiCountObj;
                    int entiCount;
                    String entiCountSco;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    Object reason = dataEntity.get("reason");
                    if (reason == null) {
                        this.addDataEntityErrorMsg(dataEntityProperties, "reason", extendedDataEntity, errorMsg);
                    }
                    if (HRStringUtils.isEmpty((String)(entiCountSco = (String)dataEntity.get("enticountsco")))) {
                        this.addDataEntityErrorMsg(dataEntityProperties, "enticountsco", extendedDataEntity, errorMsg);
                    }
                    int n = entiCount = (entiCountObj = dataEntity.get("enticount")) == null ? 0 : (Integer)entiCountObj;
                    if (entiCount >= 1) continue;
                    this.addDataEntityErrorMsg(dataEntityProperties, "enticount", extendedDataEntity, errorMsg);
                }
            }

            private void addDataEntityErrorMsg(DataEntityPropertyCollection dataEntityProperties, String propKey, ExtendedDataEntity extendedDataEntity, String errorMsg) {
                IDataEntityProperty countRangeProp = (IDataEntityProperty)dataEntityProperties.get((Object)propKey);
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, errorMsg, countRangeProp.getDisplayName().getLocaleValue()));
            }
        });
    }
}

