/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.supple;

import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtp.constants.supple.SuppleKDString;

public class SuppleRuleOp
extends HRDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs agrs) {
        super.onAddValidators(agrs);
        agrs.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                this.doValidate(dataEntities);
            }

            private void doValidate(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    DynamicObjectCollection reasonPolicyEntryColl;
                    DynamicObjectCollection exTypeEntryColl;
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    boolean onlyExSupple = dataEntity.getBoolean("onlyexsupple");
                    if (onlyExSupple && CollectionUtils.isEmpty((Collection)(exTypeEntryColl = dataEntity.getDynamicObjectCollection("extypeentry")))) {
                        this.addErrorMessage(extendedDataEntity, SuppleKDString.abnEntryMustOne());
                    }
                    if (!CollectionUtils.isEmpty((Collection)(reasonPolicyEntryColl = dataEntity.getDynamicObjectCollection("entryentity")))) continue;
                    this.addErrorMessage(extendedDataEntity, SuppleKDString.mustOne());
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(args);
        for (DynamicObject dynamicObject : dataEntities = args.getDataEntities()) {
            boolean onlyExSupple = dynamicObject.getBoolean("onlyexsupple");
            if (onlyExSupple) continue;
            dynamicObject.set("extypeentry", null);
        }
    }
}

