/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.supple;

import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtp.constants.supple.SuppleKDString;

public class SuppleTimeLimitOp
extends HRDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("timescope");
        fieldKeys.add("advdaysco");
        fieldKeys.add("daytype");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator(new AbstractValidator(){

            public void validate() {
                this.doValidate();
            }

            private void doValidate() {
                String errorMsg = SuppleKDString.mustInput();
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                if (dataEntities == null || dataEntities.length <= 0) {
                    return;
                }
                DataEntityPropertyCollection properties = dataEntities[0].getDataEntity().getDataEntityType().getProperties();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject dynamicObject = dataEntity.getDataEntity();
                    String timeScope = dynamicObject.getString("timescope");
                    if (!"F".equals(timeScope)) continue;
                    int advDaySco = dynamicObject.getInt("advdaysco");
                    String dayType = dynamicObject.getString("daytype");
                    if (advDaySco < 1) {
                        this.addDataEntityErrorMsg(properties, "advdaysco", dataEntity, errorMsg);
                    }
                    if (!HRStringUtils.isEmpty((String)dayType)) continue;
                    this.addDataEntityErrorMsg(properties, "daytype", dataEntity, errorMsg);
                }
            }

            private void addDataEntityErrorMsg(DataEntityPropertyCollection dataEntityProperties, String propKey, ExtendedDataEntity extendedDataEntity, String errorMsg) {
                IDataEntityProperty countRangeProp = (IDataEntityProperty)dataEntityProperties.get((Object)propKey);
                this.addErrorMessage(extendedDataEntity, String.format(Locale.ROOT, errorMsg, countRangeProp.getDisplayName().getLocaleValue()));
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dataEntities;
        super.beforeExecuteOperationTransaction(args);
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            String timeScope = dataEntity.getString("timescope");
            if ("F".equals(timeScope)) continue;
            dataEntity.set("advdaysco", (Object)0);
            dataEntity.set("daytype", (Object)"A");
        }
    }
}

