/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.supple.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtp.constants.supple.SuppleKDString;

public class SuppleCountLimitValidator
extends HRDataBaseValidator {
    public void validate() {
        if (this.getDataEntities() == null || this.getDataEntities().length <= 0) {
            return;
        }
        String errorMsg = SuppleKDString.mustInput();
        DataEntityPropertyCollection dataEntityProperties = this.getDataEntities()[0].getDataEntity().getDataEntityType().getProperties();
        Arrays.asList(this.getDataEntities()).forEach(dataEntity -> {
            DynamicObjectCollection reasonCountColl;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String limitType = dynamicObject.getString("limittype");
            if ("A".equals(limitType)) {
                Object countObj;
                int count;
                String countSco = dynamicObject.getString("countsco");
                if (HRStringUtils.isEmpty((String)countSco)) {
                    IDataEntityProperty countRangeProp = (IDataEntityProperty)dataEntityProperties.get((Object)"countsco");
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, String.format(Locale.ROOT, errorMsg, countRangeProp.getDisplayName().getLocaleValue()));
                }
                int n = count = (countObj = dynamicObject.get("count")) == null ? 0 : (Integer)countObj;
                if (count < 1) {
                    IDataEntityProperty countRangeProp = (IDataEntityProperty)dataEntityProperties.get((Object)"count");
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, String.format(Locale.ROOT, errorMsg, countRangeProp.getDisplayName().getLocaleValue()));
                }
            } else if ("B".equals(limitType) && CollectionUtils.isEmpty((Collection)(reasonCountColl = dynamicObject.getDynamicObjectCollection("entryentity")))) {
                this.addErrorMessage((ExtendedDataEntity)dataEntity, SuppleKDString.mustInputReasonCountLimit());
            }
        });
    }
}

