/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.swshift.validate;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtp.constants.swshift.SwShiftKDString;

public class SwShiftBaseSetValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(SwShiftBaseSetValidator.class);

    public void validate() {
        this.validateNumberGT0();
        this.validateMustInput();
    }

    private void validateMustInput() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!dataEntity.getBoolean("allowplan") && !dataEntity.getBoolean("allowactual")) {
                this.addErrorMessage(extendedDataEntity, SwShiftKDString.getAtLeastChooseOneRosterTypeTip());
            }
            if (dataEntity.getBoolean("modifyroster") || dataEntity.getBoolean("selfexchange") || dataEntity.getBoolean("otherexchange")) continue;
            this.addErrorMessage(extendedDataEntity, SwShiftKDString.getAtLeastChooseOneSwShiftTypeTip());
        }
    }

    private void validateNumberGT0() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            ArrayList<String> fields = new ArrayList<String>(3);
            if (dataEntity.getBoolean("isahead") && dataEntity.getInt("maxaheadtime") == 0 && !"C".equals(dataEntity.getString("aheadperiod"))) {
                fields.add("maxaheadtime");
            }
            if (dataEntity.getBoolean("isaheadmax") && dataEntity.getInt("aheadmaxval") == 0 && !"C".equals(dataEntity.getString("aheadmaxunit"))) {
                fields.add("aheadmaxval");
            }
            if (dataEntity.getBoolean("isrepair") && dataEntity.getInt("maxrepairtime") == 0 && !"C".equals(dataEntity.getString("repairperiod"))) {
                fields.add("maxrepairtime");
            }
            for (String field : fields) {
                String fieldName = null;
                IDataEntityProperty property = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)field);
                if (property != null) {
                    fieldName = property.getDisplayName().getLocaleValue();
                }
                String tip = String.format("%1$s:%2$s", fieldName, SwShiftKDString.getAttPeriodValZeroTip());
                this.addErrorMessage(extendedDataEntity, tip);
            }
        }
    }
}

