/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.swshift.validate;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtp.business.swshift.SwShiftPlanService;
import kd.wtc.wtp.constants.swshift.SwShiftKDString;

public class SwShiftRuleValidator
extends AbstractValidator {
    private static final Log LOG = LogFactory.getLog(SwShiftRuleValidator.class);

    public void validate() {
        this.validatePolicy();
        this.validateConditionJson();
    }

    private void validateConditionJson() {
        block0: for (ExtendedDataEntity extDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            DynamicObjectCollection entryCollDys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryCollDy : entryCollDys) {
                String limitScope = entryCollDy.getString("limitscope");
                String msg = SwShiftPlanService.getInstance().validateCondition(limitScope);
                if (!HRStringUtils.isNotEmpty((String)msg)) continue;
                this.addErrorMessage(extDataEntity, SwShiftKDString.getEntryRowFmt((int)entryCollDy.getInt("seq")) + msg);
                continue block0;
            }
        }
    }

    private void validatePolicy() {
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtbd_attpolicy");
        DynamicObject[] policyDys = helper.loadDynamicObjectArray(Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getDataEntity).flatMap(dy -> dy.getDynamicObjectCollection("entryentity").stream()).map(entryDy -> WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryDy, (String)"swshiftpolicy")).toArray());
        Map policyDyMap = Arrays.stream(policyDys).collect(Collectors.toMap(dy -> dy.getLong("id"), Function.identity(), (o1, o2) -> o2));
        block0: for (ExtendedDataEntity extDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extDataEntity.getDataEntity();
            DynamicObjectCollection entryCollDys = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryCollDy : entryCollDys) {
                long policyId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entryCollDy, (String)"swshiftpolicy");
                DynamicObject policyDy = (DynamicObject)policyDyMap.get(policyId);
                if (policyDy == null || "SW".equals(policyDy.getString("type"))) continue;
                this.addErrorMessage(extDataEntity, SwShiftKDString.getEntryRowFmt((int)entryCollDy.getInt("seq")) + SwShiftKDString.getSwShiftPolicyTip());
                continue block0;
            }
        }
    }
}

