/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.teamhome;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtp.business.mobile.TeamHomeHelper;

public class DaiPerStaConfigValidator
extends HRDataBaseValidator {
    private static final List<String> CHECK_DISPLAY_LIST = Arrays.asList("entryentity", "rankentryentity", "chartentryentity");

    public void validate() {
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        this.check(dataEntity);
        this.checkSave(dataEntity);
    }

    private void check(ExtendedDataEntity dataEntity) {
        for (String proName : CHECK_DISPLAY_LIST) {
            String displayMsg = TeamHomeHelper.checkDisplay((DynamicObjectCollection)dataEntity.getDataEntity().getDynamicObjectCollection(proName), (String)proName);
            if (!HRStringUtils.isNotEmpty((String)displayMsg)) continue;
            this.addFatalErrorMessage(dataEntity, displayMsg);
        }
    }

    private void checkSave(ExtendedDataEntity dataEntity) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntity().getDynamicObjectType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"entryentity");
        if (iDataEntityProperty == null) {
            return;
        }
        DynamicObjectCollection entryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        DynamicObjectCollection rankEntryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("rankentryentity");
        DynamicObjectCollection chartEntryEntity = dataEntity.getDataEntity().getDynamicObjectCollection("chartentryentity");
        if (entryEntity.size() != 0) {
            if (entryEntity.size() > 15 || rankEntryEntity.size() > 15 || chartEntryEntity.size() > 15) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u884c\u6570\u636e\u4e0d\u80fd\u8d85\u8fc7\u4e0a\u9650\u503c\uff0815\u6761\uff09\u3002", (String)"DaiPerStaConfigValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            }
        } else {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u81f3\u5c11\u4e00\u6761\u8003\u52e4\u7edf\u8ba1\u5206\u5f55\u6570\u636e\u3002", (String)"DaiPerStaConfigValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }
}

