/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.teamhome;

import java.io.UnsupportedEncodingException;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;

public class DaiPerStaSourceValidator
extends HRDataBaseValidator {
    private static final Log LOG = LogFactory.getLog(DaiPerStaSourceValidator.class);

    public void validate() {
        String operateKey;
        ExtendedDataEntity dataEntity = this.getDataEntities()[0];
        switch (operateKey = this.getOperateKey()) {
            case "save": 
            case "submit": {
                this.checkSave(dataEntity);
            }
        }
    }

    private void checkSave(ExtendedDataEntity dataEntity) {
        String valTakMethod = dataEntity.getDataEntity().getString("valtakmethod");
        if ("1".equals(valTakMethod)) {
            this.checkAttItemEntry(dataEntity);
        }
        int nameLength = 0;
        try {
            nameLength = dataEntity.getDataEntity().getString("name").getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException e) {
            LOG.warn("DaiPerStaSourceValidator.checkSave  name.getBytes error.", (Throwable)e);
        }
        if (nameLength > 16) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d\u6700\u591a\u5f55\u516516\u4e2a\u5b57\u7b26\u3002", (String)"DaiPerStaCommValidator_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkAttItemEntry(ExtendedDataEntity dataEntity) {
        DataEntityPropertyCollection properties = dataEntity.getDataEntity().getDynamicObjectType().getProperties();
        IDataEntityProperty iDataEntityProperty = (IDataEntityProperty)properties.get((Object)"entryentity");
        if (iDataEntityProperty == null) {
            return;
        }
        DynamicObjectCollection entryDys = dataEntity.getDataEntity().getDynamicObjectCollection("entryentity");
        if (entryDys.size() == 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u884c\u5206\u5f55\u6570\u636e\u3002", (String)"DaiPerStaCommValidator_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            return;
        }
        if (entryDys.size() > 99) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u6700\u591a\u652f\u6301\u6dfb\u52a099\u6761\u6570\u636e\u3002", (String)"DaiPerStaCommValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            return;
        }
        long count = entryDys.stream().map(entryDy -> entryDy.getString("attitem.datatype")).distinct().count();
        if (count > 1L) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5206\u5f55\u5404\u8003\u52e4\u9879\u76ee\u7684\u201c\u6570\u636e\u7c7b\u578b\u201d\u9700\u4fdd\u6301\u4e00\u81f4\u3002", (String)"DaiPerStaCommValidator_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }
}

