/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.teamhome;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtp.business.mobile.TeamHomeHelper;

public class MobileSchemeSaveValidator
extends HRDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        this.doValidate(dataEntities);
    }

    private void doValidate(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            String showTeam = dynamicObject.getString("workspace");
            if (!HRStringUtils.equals((String)"B", (String)showTeam)) continue;
            DynamicObjectCollection entry = dynamicObject.getDynamicObjectCollection("adminorgentry");
            if (CollectionUtils.isEmpty((Collection)entry)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u6761\u9002\u7528\u8303\u56f4\u6570\u636e\u3002", (String)"MobileRuleRangeEdit_01", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                return;
            }
            Set adminOrgSet = entry.stream().map(ob -> ob.getLong("adminorgname.id")).collect(Collectors.toSet());
            DynamicObject[] dynamicObjects = TeamHomeHelper.queryTeamMobileSchemeByAdminOrgId(adminOrgSet, (String)"id");
            if (dynamicObjects == null || dynamicObjects.length < 1) continue;
            Long id = dynamicObject.getLong("id");
            if (dynamicObjects.length < 2 && dynamicObjects[0].getLong("id") == id.longValue()) continue;
            String number = this.getDiff(dynamicObjects, id);
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u9002\u7528\u8303\u56f4\u91cd\u590d\u7684\u5047\u52e4\u95e8\u6237\u65b9\u6848\uff0c\u7f16\u7801\u4e3a{0}\u3002", (String)"MobileRuleRangeEdit_02", (String)"wtc-wtp-opplugin", (Object[])new Object[]{number}));
        }
    }

    private String getDiff(DynamicObject[] dynamicObjects, Long id) {
        for (DynamicObject obj : dynamicObjects) {
            if (null == obj || id.longValue() == obj.getLong("id")) continue;
            return obj.getString("number");
        }
        return "";
    }
}

