/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.tp;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.opplugin.web.common.op.WtpMustInputOp;
import kd.wtc.wtp.opplugin.web.common.validator.WtpMustInputValidator;

public class TripConfigMustInputOp
extends WtpMustInputOp {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().addAll(Lists.newArrayList((Object[])new String[]{"isadvanceapple", "advancenumber", "advanceunit", "islateadvanceapple", "lateadvancenumber", "lateadvanceunit", "isafterapple", "afternumber", "afterunit"}));
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new WtpMustInputValidator(){

            @Override
            public void validate() {
                ExtendedDataEntity[] dataEntities;
                super.validate();
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    this.validate(dataEntity);
                }
            }

            private void validate(ExtendedDataEntity dataEntity) {
                boolean isAfterApple;
                boolean isLateAdvanceApple;
                DynamicObject dy = dataEntity.getDataEntity();
                ArrayList nullPropKey = Lists.newArrayListWithCapacity((int)16);
                boolean isAdvanceApple = dy.getBoolean("isadvanceapple");
                if (isAdvanceApple) {
                    String advanceUnit;
                    Object advanceNumber = dy.get("advancenumber");
                    if (null == advanceNumber) {
                        nullPropKey.add("advancenumber");
                    }
                    if (HRStringUtils.isEmpty((String)(advanceUnit = dy.getString("advanceunit")))) {
                        nullPropKey.add("advanceunit");
                    }
                }
                if (isLateAdvanceApple = dy.getBoolean("islateadvanceapple")) {
                    String lateAdvanceUnit;
                    Object lateAdvanceNumber = dy.get("lateadvancenumber");
                    if (null == lateAdvanceNumber) {
                        nullPropKey.add("lateadvancenumber");
                    }
                    if (HRStringUtils.isEmpty((String)(lateAdvanceUnit = dy.getString("lateadvanceunit")))) {
                        nullPropKey.add("lateadvanceunit");
                    }
                }
                if (isAfterApple = dy.getBoolean("isafterapple")) {
                    String afterUnit;
                    Object afterNumber = dy.get("afternumber");
                    if (null == afterNumber) {
                        nullPropKey.add("afternumber");
                    }
                    if (HRStringUtils.isEmpty((String)(afterUnit = dy.getString("afterunit")))) {
                        nullPropKey.add("afterunit");
                    }
                }
                if (WTCCollections.isNotEmpty((Collection)nullPropKey)) {
                    this.addErrorMessage(dataEntity, TripConfigMustInputOp.this.getErrorMsg(dy, nullPropKey));
                }
                if (TripConfigMustInputOp.this.checkAdvanceAndTonicConf(dataEntity.getDataEntity())) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u8003\u52e4\u671f\u95f4\u624d\u53ef\u8bbe\u7f6e\u6700\u5927\u671f\u9650\u6570\u4e3a0\u3002", (String)"WtpMustInputOp_02", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    private boolean checkAdvanceAndTonicConf(DynamicObject dy) {
        boolean tonicOpen = dy.getBoolean("isafterapple");
        boolean minAdvanceOpen = dy.getBoolean("isadvanceapple");
        boolean maxAdvanceOpen = dy.getBoolean("islateadvanceapple");
        String tonicUnit = dy.getString("afterunit");
        String minAdvanceUnit = dy.getString("advanceunit");
        String maxAdvanceUnit = dy.getString("lateadvanceunit");
        BigDecimal tonicValue = dy.getBigDecimal("afternumber");
        BigDecimal minAdvanceValue = dy.getBigDecimal("advancenumber");
        BigDecimal maxAdvanceValue = dy.getBigDecimal("lateadvancenumber");
        boolean tonicError = tonicOpen && !HRStringUtils.equals((String)"C", (String)tonicUnit) && tonicValue != null && tonicValue.compareTo(BigDecimal.ZERO) == 0;
        boolean minAdvanceError = minAdvanceOpen && !HRStringUtils.equals((String)"C", (String)minAdvanceUnit) && minAdvanceValue != null && minAdvanceValue.compareTo(BigDecimal.ZERO) == 0;
        boolean maxAdvanceError = maxAdvanceOpen && !HRStringUtils.equals((String)"C", (String)maxAdvanceUnit) && maxAdvanceValue != null && maxAdvanceValue.compareTo(BigDecimal.ZERO) == 0;
        return tonicError || minAdvanceError || maxAdvanceError;
    }
}

