/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.tp;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtp.opplugin.web.common.op.WtpMustInputOp;
import kd.wtc.wtp.opplugin.web.common.validator.WtpMustInputValidator;

public class TripPlanMustInputOp
extends WtpMustInputOp {
    @Override
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        super.onPreparePropertys(args);
        args.getFieldKeys().add("setruleway");
        args.getFieldKeys().add("triprule");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs args) {
        super.onAddValidators(args);
        args.addValidator((AbstractValidator)new WtpMustInputValidator(){

            @Override
            public void validate() {
                super.validate();
                Map<Long, String> ruleSetWayMap = this.getRuleSetWay();
                for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
                    this.validate(dataEntity, ruleSetWayMap);
                }
            }

            private void validate(ExtendedDataEntity dataEntity, Map<Long, String> ruleSetWayMap) {
                String msg;
                Object rule;
                DynamicObject dy = dataEntity.getDataEntity();
                long id = dy.getLong("id");
                String setRuleWayVal = dy.getString("setruleway");
                if (HRStringUtils.isEmpty((String)setRuleWayVal)) {
                    setRuleWayVal = ruleSetWayMap.get(id);
                }
                if (!"2".equals(setRuleWayVal) && null == (rule = dy.get("triprule")) && HRStringUtils.isNotEmpty((String)(msg = TripPlanMustInputOp.this.getErrorMsg(dy, Lists.newArrayList((Object[])new String[]{"triprule"}))))) {
                    this.addErrorMessage(dataEntity, msg);
                }
            }

            private Map<Long, String> getRuleSetWay() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                List planIdList = Arrays.stream(dataEntities).map(item -> item.getDataEntity().getLong("id")).collect(Collectors.toList());
                String queryProp = WTCStringUtils.joinOnComma((String[])new String[]{"planid", "ruleset"});
                QFilter qFilter = new QFilter("planid", "in", planIdList);
                DynamicObject[] ruleAssociationDys = HRBaseServiceHelper.create((String)"wtp_ruleassociation").queryOriginalArray(queryProp, qFilter.toArray());
                return Arrays.stream(ruleAssociationDys).collect(Collectors.toMap(item -> item.getLong("planid"), item -> item.getString("ruleset"), (o1, o2) -> o1));
            }
        });
    }
}

