/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.vacation.validate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.wtc.wtbs.common.enums.bill.BaseSetUnitTypeEnum;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.util.StringUtils;

public class VacationBaseSetValidate
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        this.numberValueMustInputValidate();
        for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
            this.validate(entity);
        }
    }

    private void numberValueMustInputValidate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            boolean isAHead = dataEntity.getBoolean("isahead");
            boolean aheadPeriodIsPeriod = BaseSetUnitTypeEnum.PERIOD.getCode().equals(dataEntity.getString("aheadperiod"));
            if (isAHead && !aheadPeriodIsPeriod) {
                this.validateNumberFieldGT0(extendedDataEntity, dataEntity, "maxaheadtime_real");
            }
            boolean isAHeadMax = dataEntity.getBoolean("isaheadmax");
            boolean aheadMaxUnitPeriod = BaseSetUnitTypeEnum.PERIOD.getCode().equals(dataEntity.getString("aheadmaxunit"));
            if (isAHeadMax && !aheadMaxUnitPeriod) {
                this.validateNumberFieldGT0(extendedDataEntity, dataEntity, "aheadmaxval");
            }
            boolean isRepair = dataEntity.getBoolean("isrepair");
            boolean isAttPeriod = BaseSetUnitTypeEnum.PERIOD.getCode().equals(dataEntity.getString("repairperiod"));
            if (!isRepair || isAttPeriod) continue;
            this.validateNumberFieldGT0(extendedDataEntity, dataEntity, "maxrepairtime_real");
        }
    }

    public void validate(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObjectCollection vaTypeEntries = dataEntity.getDynamicObjectCollection("vatypeentry");
        if (dataEntity.getBoolean("isspecialholiday")) {
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("wtp_vabasesetbreast");
            if (collection == null || collection.size() == 0) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u54fa\u4e73\u5047\u914d\u7f6e\u5206\u5f55\u201d\u3002", (String)"VacationBaseSetValidate_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                return;
            }
            for (int i = 0; i < collection.size(); ++i) {
                DynamicObject object = (DynamicObject)collection.get(i);
                ArrayList emptyFields = Lists.newArrayListWithExpectedSize((int)3);
                if (object.get("babynum") == null || Objects.equals(object.get("babynum"), 0)) {
                    emptyFields.add(ResManager.loadKDString((String)"\u672c\u6b21\u80de\u80ce\u6570", (String)"VacationBaseSetValidate_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
                if (object.get("offtimeperday") == null || BigDecimal.ZERO.compareTo((BigDecimal)object.get("offtimeperday")) == 0) {
                    emptyFields.add(ResManager.loadKDString((String)"\u5355\u65e5\u53ef\u4f11\u65f6\u957f", (String)"VacationBaseSetValidate_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isBlank((CharSequence)object.getString("offtimeunit"))) {
                    emptyFields.add(ResManager.loadKDString((String)"\u5355\u4f4d", (String)"VacationBaseSetValidate_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
                if (emptyFields.isEmpty()) continue;
                this.addMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u54fa\u4e73\u5047\u914d\u7f6e\u5206\u5f55\u201d\u7b2c{0}\u884c\uff1a{1}\u3002", (String)"VacationBaseSetValidate_4", (String)"wtc-wtp-opplugin", (Object[])new Object[]{i + 1, emptyFields.stream().map(str -> "\u201c" + str + "\u201d").collect(Collectors.joining(ResManager.loadKDString((String)"\u3001", (String)"VacationBaseSetValidate_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0])))}));
            }
            if (dataEntity.getBoolean("isallowoverlap")) {
                if (vaTypeEntries == null || vaTypeEntries.size() == 0) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"{0}\u4e0d\u53ef\u540c\u65f6\u7ed1\u5b9a\u591a\u4e2a\u4f11\u5047\u7c7b\u578b\u3002", (String)"VacationBaseSetValidate_7", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                    return;
                }
            } else {
                vaTypeEntries.clear();
            }
        } else {
            dataEntity.set("isallowoverlap", (Object)false);
            vaTypeEntries.clear();
        }
        BigDecimal minHolidayTime = dataEntity.getBigDecimal("minholidaytime");
        BigDecimal maxHolidayTime = dataEntity.getBigDecimal("maxholidaytime");
        if (minHolidayTime != null && maxHolidayTime != null && minHolidayTime.compareTo(BigDecimal.ZERO) > 0 && maxHolidayTime.compareTo(BigDecimal.ZERO) > 0 && minHolidayTime.compareTo(maxHolidayTime) > 0) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u201c\u6700\u5927\u4f11\u5047\u65f6\u957f\u201d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e\u201c\u6700\u5c0f\u4f11\u5047\u65f6\u957f\u201d\u3002", (String)"VacationBaseSetValidate_6", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateNumberFieldGT0(ExtendedDataEntity extDataEntity, DynamicObject dataEntity, String numberField) {
        BigDecimal numberVal = dataEntity.getBigDecimal(numberField);
        if (numberVal == null || BigDecimal.ZERO.compareTo(numberVal) >= 0) {
            IDataEntityProperty field = (IDataEntityProperty)dataEntity.getDataEntityType().getProperties().get((Object)numberField);
            this.addErrorMessage(extDataEntity, field == null ? "" : this.getValueGT0Tip(field.getDisplayName().getLocaleValue()));
        }
    }

    private String getValueGT0Tip(String fieldName) {
        return ResManager.loadKDString((String)"\u201c{0}\u201d\u9700\u5927\u4e8e0\u3002", (String)"QTCarryDownValidator_1", (String)"wtc-wtp-opplugin", (Object[])new Object[]{fieldName});
    }
}

