/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.vacation.validate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.util.WTCDynamicObjectUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;

public class VacationRuleValidate
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity entity : dataEntities = this.getDataEntities()) {
            this.validate(entity);
        }
    }

    public void validate(ExtendedDataEntity entity) {
        DynamicObject dataEntity = entity.getDataEntity();
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("entryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            this.addMessage(entity, ResManager.loadKDString((String)"\u8ba1\u7b97\u89c4\u5219\u4e2d\u81f3\u5c11\u9700\u8981\u6dfb\u52a0\u4e00\u884c\u6570\u636e\u3002", (String)"VacationRuleValidate_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
            return;
        }
        for (int i = 0; i < entryEntity.size(); ++i) {
            String dateRangeCondition;
            long roundRuleId;
            DynamicObject entry = (DynamicObject)entryEntity.get(i);
            ArrayList emptyFields = Lists.newArrayList();
            this.validateMustInputBaseData(entry, emptyFields, "vatype");
            this.validateMustInputBaseData(entry, emptyFields, "vabasesetid");
            this.validateMustInputBaseData(entry, emptyFields, "vaitem");
            this.validateMustInputBaseData(entry, emptyFields, "timebyshiftitem");
            this.validateMustInputBaseData(entry, emptyFields, "resultitem");
            boolean isQuota = entry.getBoolean("isquota");
            if (isQuota) {
                this.validateMustInputBaseData(entry, emptyFields, "deductrule");
            }
            if ((roundRuleId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry, (String)"roundrule")) != 0L) {
                this.validateMustInputBaseData(entry, emptyFields, "roundruleitem");
            }
            if (HRStringUtils.isEmpty((String)(dateRangeCondition = entry.getString("daterangecondition")))) {
                this.addEmptyField(entry, emptyFields, "daterangecondition");
            }
            if (emptyFields.isEmpty()) continue;
            this.addMessage(entity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u7b97\u89c4\u5219\u201d\u7b2c{0}\u884c\uff1a{1}\u3002", (String)"VacationRuleValidate_4", (String)"wtc-wtp-opplugin", (Object[])new Object[]{i + 1, emptyFields.stream().map(str -> "\u201c" + str + "\u201d").collect(Collectors.joining(ResManager.loadKDString((String)"\u3001", (String)"VacationBaseSetValidate_5", (String)"wtc-wtp-opplugin", (Object[])new Object[0])))}));
        }
    }

    private void validateMustInputBaseData(DynamicObject entry, List<String> emptyFields, String basedataField) {
        long vaTypeId = WTCDynamicObjectUtils.getBaseDataId((DynamicObject)entry, (String)basedataField);
        if (vaTypeId == 0L) {
            this.addEmptyField(entry, emptyFields, basedataField);
        }
    }

    private void addEmptyField(DynamicObject entry, List<String> emptyFields, String field) {
        IDataEntityProperty property = (IDataEntityProperty)entry.getDataEntityType().getProperties().get((Object)field);
        emptyFields.add(property.getDisplayName().getLocaleValue());
    }
}

