/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.opplugin.web.validate;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.wtc.wtp.business.timesplit.Section;
import kd.wtc.wtp.business.timesplit.SectionUtils;

public class TimeTypeValidate
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObjectCollection weekDate;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String datatype = dataEntity.getString("datatype");
            DynamicObjectCollection holiday = dataEntity.getDynamicObjectCollection("entryentity");
            DynamicObjectCollection specialday = dataEntity.getDynamicObjectCollection("entryentity1");
            if ("A".equals(datatype) && CollectionUtils.isEmpty((Collection)holiday) && CollectionUtils.isEmpty((Collection)specialday)) {
                this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5728\u201c\u5047\u671f\u7ec4\u5408\u201d\u6216\u201c\u7279\u6b8a\u65e5\u671f\u201d\u533a\u6bb5\u7ef4\u62a4\u4e00\u884c\u6570\u636e\u3002", (String)"TimeTypeValidate_0", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("B".equals(datatype)) {
                ArrayList sectionList = new ArrayList();
                DynamicObjectCollection regularTime = dataEntity.getDynamicObjectCollection("entryentity2");
                if (CollectionUtils.isEmpty((Collection)regularTime)) {
                    this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u7ef4\u62a4\u56fa\u5b9a\u65f6\u6bb5\u4fe1\u606f", (String)"TimeTypeValidate_1", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                }
                regularTime.stream().forEach(item -> {
                    String etagdate;
                    BigDecimal starttime = item.getBigDecimal("begintime");
                    BigDecimal outtime = item.getBigDecimal("outtime");
                    String stagdate = item.getString("stagdate");
                    if (Objects.equals(stagdate, etagdate = item.getString("etagdate")) && stagdate != null && starttime.compareTo(outtime) >= 0) {
                        this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5e94\u65e9\u4e8e\u7ed3\u675f\u65f6\u95f4\u3002", (String)"TimeTypeValidate_2", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                    }
                    if (Objects.nonNull(starttime) && Objects.nonNull(outtime) && Objects.nonNull(stagdate) && Objects.nonNull(etagdate)) {
                        if (Objects.equals(stagdate, "B")) {
                            starttime = starttime.add(new BigDecimal("86400"));
                        }
                        if (Objects.equals(etagdate, "B")) {
                            outtime = outtime.add(new BigDecimal("86400"));
                        }
                        Section section = new Section(starttime, outtime);
                        sectionList.add(section);
                    }
                });
                if (!SectionUtils.complateCf(sectionList)) continue;
                this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u5305\u542b\u8be5\u65f6\u6bb5\u7684\u65f6\u6bb5\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u586b\u5199\u3002", (String)"TimeTypeValidate_3", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"C".equals(datatype) || !CollectionUtils.isEmpty((Collection)(weekDate = dataEntity.getDynamicObjectCollection("entryentity3")))) continue;
            this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u9009\u62e9\u4e00\u4e2a\u201c\u5468\u201d\u65f6\u6bb5", (String)"TimeTypeValidate_4", (String)"wtc-wtp-opplugin", (Object[])new Object[0]));
        }
    }
}

