/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.common.model.attconfirm;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import kd.bos.dataentity.entity.DynamicObject;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileF7QueryParam;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtbs.common.model.period.PerAttPeriod;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtp.common.enums.attconfirm.AttConDayTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordDataSourceEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordOverHandleTypeEnum;
import kd.wtc.wtp.common.enums.attconfirm.AttConRecordTypeEnum;

public class AttConfirmRecordGenModel
implements Serializable {
    private static final long serialVersionUID = -3063917863897997340L;
    @NotNull
    private Set<Long> fileBoIdSet;
    @Deprecated
    private Set<Long> fileAuthIdSet;
    @NotNull
    private Set<Long> personIdSet;
    private Tuple<Integer, AttConDayTypeEnum> genScope;
    private Tuple<Date, Date> genScopePeriod;
    @NotNull
    private Tuple<Integer, AttConDayTypeEnum> confirmScope;
    private List<Date> dataScope;
    private Set<PerAttPeriod> perAttPeriodSet;
    @NotNull
    private AttConRecordTypeEnum type;
    @NotNull
    private AttConRecordOverHandleTypeEnum overHandleType;
    private boolean confirmLock;
    private boolean showLast;
    private boolean zeroItemNoGen;
    @NotNull
    private AttConRecordDataSourceEnum genSource;
    private Long genRuleId;
    @NotNull
    private Map<Long, List<AttConfirmAttFile>> attConfirmAuthFileMap;

    public List<Date> getDataScope() {
        return this.dataScope;
    }

    public Set<Long> getFileBoIdSet() {
        return this.fileBoIdSet;
    }

    public void setFileBoIdSet(Set<Long> fileBoIdSet) {
        this.fileBoIdSet = fileBoIdSet;
    }

    public Set<PerAttPeriod> getPerAttPeriodSet() {
        return this.perAttPeriodSet;
    }

    public void setPerAttPeriodSet(Set<PerAttPeriod> perAttPeriodSet) {
        this.perAttPeriodSet = perAttPeriodSet;
    }

    public AttConRecordTypeEnum getType() {
        return this.type;
    }

    public void setType(AttConRecordTypeEnum type) {
        this.type = type;
    }

    public AttConRecordOverHandleTypeEnum getOverHandleType() {
        return this.overHandleType;
    }

    public void setOverHandleType(AttConRecordOverHandleTypeEnum overHandleType) {
        this.overHandleType = overHandleType;
    }

    public boolean isConfirmLock() {
        return this.confirmLock;
    }

    public void setConfirmLock(boolean confirmLock) {
        this.confirmLock = confirmLock;
    }

    public boolean isShowLast() {
        return this.showLast;
    }

    public void setShowLast(boolean showLast) {
        this.showLast = showLast;
    }

    public Tuple<Integer, AttConDayTypeEnum> getGenScope() {
        return this.genScope;
    }

    public void setGenScope(Tuple<Integer, AttConDayTypeEnum> genScope) {
        this.genScope = genScope;
    }

    public Tuple<Integer, AttConDayTypeEnum> getConfirmScope() {
        return this.confirmScope;
    }

    public void setConfirmScope(Tuple<Integer, AttConDayTypeEnum> confirmScope) {
        this.confirmScope = confirmScope;
    }

    public void setDataScope(List<Date> dataScope) {
        this.dataScope = dataScope;
    }

    public Set<Long> getPersonIdSet() {
        return this.personIdSet;
    }

    public void setPersonIdSet(Set<Long> personIdSet) {
        this.personIdSet = personIdSet;
        this.setAttConfirmAuthFileMap(personIdSet);
    }

    public Set<Long> getFileAuthIdSet() {
        return this.fileAuthIdSet;
    }

    public void setFileAuthIdSet(Set<Long> fileAuthIdSet) {
        this.fileAuthIdSet = fileAuthIdSet;
    }

    public Tuple<Date, Date> getGenScopePeriod() {
        return this.genScopePeriod;
    }

    public void setGenScopePeriod(Tuple<Date, Date> genScopePeriod) {
        this.genScopePeriod = genScopePeriod;
    }

    public boolean isZeroItemNoGen() {
        return this.zeroItemNoGen;
    }

    public void setZeroItemNoGen(boolean zeroItemNoGen) {
        this.zeroItemNoGen = zeroItemNoGen;
    }

    public AttConRecordDataSourceEnum getGenSource() {
        return this.genSource;
    }

    public void setGenSource(AttConRecordDataSourceEnum genSource) {
        this.genSource = genSource;
    }

    public Long getGenRuleId() {
        return this.genRuleId;
    }

    public void setGenRuleId(Long genRuleId) {
        this.genRuleId = genRuleId;
    }

    public Map<Long, List<AttConfirmAttFile>> getAttConfirmAuthFileMap() {
        return this.attConfirmAuthFileMap;
    }

    private void setAttConfirmAuthFileMap(Set<Long> filePersonIdSet) {
        this.attConfirmAuthFileMap = new HashMap<Long, List<AttConfirmAttFile>>(filePersonIdSet == null ? 16 : filePersonIdSet.size());
        AttFileQueryParam attFileQueryParam = new AttFileQueryParam(true);
        attFileQueryParam.setPersonSetIds(filePersonIdSet);
        attFileQueryParam.setAuthCheck(Boolean.FALSE);
        attFileQueryParam.setProperties("id,boid,bsed,bsled,startdate,enddate,person.id");
        if (WTCCollections.isNotEmpty(this.getDataScope())) {
            Optional first = WTCCollectionIndexUtil.getEleFromList(this.getDataScope(), (int)0);
            Optional last = WTCCollectionIndexUtil.getEleFromList(this.getDataScope(), (int)(this.getDataScope().size() - 1));
            if (first.isPresent() && last.isPresent()) {
                attFileQueryParam.setStartDate((Date)first.get());
                attFileQueryParam.setEndDate((Date)last.get());
            }
        }
        if (WTCCollections.isNotEmpty(this.getPerAttPeriodSet())) {
            Set needFileBoId = this.getPerAttPeriodSet().stream().map(PerAttPeriod::getFileBoId).collect(Collectors.toSet());
            attFileQueryParam.setSetBoIds(needFileBoId);
        }
        List files = AttFileQueryServiceImpl.getInstance().queryAttFiles(attFileQueryParam);
        Set<Long> authFileIdSet = this.getAuthFileVersions(filePersonIdSet);
        Map<Long, List<AttConfirmAttFile>> resMap = files.stream().filter(Objects::nonNull).map(d -> this.genAttConfirmAttFile((DynamicObject)d, authFileIdSet)).collect(Collectors.groupingBy(AttConfirmAttFile::getBoId));
        this.attConfirmAuthFileMap.putAll(resMap);
        this.setFileBoIdSet(new HashSet<Long>(resMap.keySet()));
    }

    private Set<Long> getAuthFileVersions(Set<Long> filePersonIdSet) {
        AttFileF7QueryParam attFileQueryParam = new AttFileF7QueryParam();
        attFileQueryParam.setPersonSetIds(filePersonIdSet);
        attFileQueryParam.setProperties("id");
        attFileQueryParam.setPermField("attfileversion");
        attFileQueryParam.setAppId("wtam");
        attFileQueryParam.setFormId("wtam_attconrecord");
        return AttFileQueryServiceImpl.getInstance().queryAttFilesByCustomAuth(attFileQueryParam).stream().map(d -> d.getLong("id")).collect(Collectors.toSet());
    }

    private AttConfirmAttFile genAttConfirmAttFile(DynamicObject file, Set<Long> authFileIdSet) {
        AttConfirmAttFile attConfirmAttFile = new AttConfirmAttFile();
        attConfirmAttFile.setId(file.getLong("id"));
        if (authFileIdSet.contains(file.getLong("id"))) {
            attConfirmAttFile.setHasAuth(true);
        }
        attConfirmAttFile.setBoId(file.getLong("boid"));
        attConfirmAttFile.setPersonId(file.getLong("person.id"));
        attConfirmAttFile.setStartDate(file.getDate("bsed"));
        attConfirmAttFile.setEndDate(file.getDate("bsled").after(file.getDate("enddate")) ? file.getDate("enddate") : file.getDate("bsled"));
        return attConfirmAttFile;
    }

    public static class AttConfirmAttFile {
        private long id;
        private long boId;
        private long personId;
        private Date startDate;
        private Date endDate;
        private boolean hasAuth;

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public void setStartDate(Date startDate) {
            this.startDate = startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public long getBoId() {
            return this.boId;
        }

        public void setBoId(long boId) {
            this.boId = boId;
        }

        public long getPersonId() {
            return this.personId;
        }

        public void setPersonId(long personId) {
            this.personId = personId;
        }

        public boolean isHasAuth() {
            return this.hasAuth;
        }

        public void setHasAuth(boolean hasAuth) {
            this.hasAuth = hasAuth;
        }
    }
}

