/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.constants.mobile.quota;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.wtc.wtbs.common.util.WTCSymbolMultiLanguageUtil;
import kd.wtc.wtp.constants.quota.QTQualificationConstants;
import kd.wtc.wtp.enums.quota.QTInspectRangEnum;
import kd.wtc.wtp.enums.quota.QTLimitMethodEnum;
import kd.wtc.wtp.enums.quota.QTQualityTypeEnum;
import kd.wtc.wtp.enums.quota.QTRelationEnum;

public class QTQualificationInfo
implements QTQualificationConstants,
Serializable {
    String ruleCondition;
    String result;
    QTInspectRangEnum inspectRang;
    QTQualityTypeEnum qualityType;
    QTRelationEnum relation;
    String attitem;
    String varCondition;
    BigDecimal quatity;
    BigDecimal limitQuatity;
    BigDecimal limitPrecentg;
    QTLimitMethodEnum limitMethod;
    String unit;

    public QTQualificationInfo changToMobile(DynamicObject dynamicObject) {
        BigDecimal limitPrecentgTemp;
        if (dynamicObject == null) {
            return this;
        }
        this.inspectRang = QTInspectRangEnum.getEnumByCode(dynamicObject.getString("inspectrangm"));
        BigDecimal limitQuatityTemp = dynamicObject.getBigDecimal("limitquatitym");
        if (limitQuatityTemp != null) {
            this.limitQuatity = limitQuatityTemp.setScale(2, RoundingMode.HALF_UP);
        }
        if ((limitPrecentgTemp = dynamicObject.getBigDecimal("limitprecentgm")) != null) {
            this.limitPrecentg = limitPrecentgTemp.setScale(2, RoundingMode.HALF_UP);
        }
        this.limitMethod = QTLimitMethodEnum.getEnumByCode(dynamicObject.getString("limitmethodm"));
        return this;
    }

    public String getRuleCondition() {
        String quatityUnit;
        String qualityTypeName = QTQualityTypeEnum.ATTITEM.getCode().equals(this.qualityType.getCode()) ? this.attitem : this.varCondition;
        String string = quatityUnit = QTQualityTypeEnum.ATTITEM.getCode().equals(this.qualityType.getCode()) ? this.quatity + this.unit : this.quatity + "";
        if (!StringUtils.isEmpty((String)qualityTypeName) && !StringUtils.isEmpty((String)quatityUnit)) {
            String resStr = ResManager.loadKDString((String)"\u5728%1$s\uff0c\u4e14%2$s%3$s%4$s\u3002", (String)"QTQualificationInfo_0", (String)"wtc-wtp-common", (Object[])new Object[0]);
            String relDesc = ResManager.loadKDString((String)this.relation.getDesc(), (String)this.relation.getDesc(), (String)this.relation.getResourceID(), (Object[])new Object[]{"wtc-wtp-common"});
            this.ruleCondition = String.format(Locale.ROOT, resStr, this.inspectRang.getDesc(), qualityTypeName, relDesc, quatityUnit);
        }
        return this.ruleCondition;
    }

    public String getInspectRangDesc() {
        return this.inspectRang.getDesc() + WTCSymbolMultiLanguageUtil.getCommonSymbol();
    }

    public String getInspectRangDescV2(String condStr) {
        String limit = QTLimitMethodEnum.FIXED_VALE.getCode().equals(this.limitMethod.getCode()) ? this.limitQuatity + "" : this.limitPrecentg + "%";
        String resStr = ResManager.loadKDString((String)"%1$s\uff0c%2$s\uff0c\u5b9a\u989d\u751f\u6210\u6570\u91cf\u6309%3$s\u751f\u6210%4$s\u3002", (String)"QTQualificationInfo_3", (String)"wtc-wtp-common", (Object[])new Object[0]);
        return String.format(Locale.ROOT, resStr, this.inspectRang.getDesc(), condStr, this.limitMethod.getDesc(), limit);
    }

    public String getResult() {
        String limit;
        String string = limit = QTLimitMethodEnum.FIXED_VALE.getCode().equals(this.limitMethod.getCode()) ? this.limitQuatity + "" : this.limitPrecentg + "%";
        if (!StringUtils.isEmpty((String)limit)) {
            String resStr = ResManager.loadKDString((String)"\u5b9a\u989d\u751f\u6210\u6570\u91cf\u6309%1$s\u751f\u6210%2$s\u3002", (String)"QTQualificationInfo_1", (String)"wtc-wtp-common", (Object[])new Object[0]);
            this.result = String.format(Locale.ROOT, resStr, this.limitMethod.getDesc(), limit);
        }
        return this.result;
    }
}

