/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.business.daterange.access.ConditionDto;
import kd.wtc.wtbs.business.personfilter.enums.RuleOperatorEnum;
import kd.wtc.wtp.utils.PunchCardTagEnum;

public class AccessFilter {
    private Map<String, Function<Map<String, Object>, Object>> mapping = new HashMap<String, Function<Map<String, Object>, Object>>(16);
    private static final Log log = LogFactory.getLog(AccessFilter.class);

    public AccessFilter() {
        this.mapping.put("dateattribute", tb -> Objects.isNull(tb.get("dateAttributeCode")) ? "" : tb.get("dateAttributeCode"));
        this.mapping.put("off", tb -> "Y".equals(String.valueOf(tb.get("OFFShift"))) ? "true" : "false");
        this.mapping.put("shifttimebucketproperty", tb -> Objects.isNull(tb.get("timeBucketAttributeCode")) ? "" : tb.get("timeBucketAttributeCode"));
        this.mapping.put("timebucketposition", tb -> tb.get("timeBucketPosition"));
        this.mapping.put("attendancebilltag", tb -> {
            ArrayList<String> result = new ArrayList<String>();
            if (tb.get("travelRequestBillID") != null) {
                result.add("1030_S");
            }
            if (tb.get("leaveRequestBillID") != null) {
                result.add("1020_S");
            }
            if (tb.get("overtimeRequestCode") != null) {
                result.add("1010_S");
            }
            return result;
        });
        this.mapping.put("punchcardtag.code", tb -> tb.get("exceptionTagCode"));
        this.mapping.put("datetype.id", tb -> tb.get("dateTypeId"));
        this.mapping.put("punchcardtag.id", tb -> PunchCardTagEnum.getByCode((String)tb.get("exceptionTagCode")).getId());
        for (String key : new ArrayList<String>(this.mapping.keySet())) {
            this.mapping.put("bucket.wtte_buckettime." + key, this.mapping.get(key));
        }
    }

    public List<Map<String, Object>> accessFilterByConditionI(List<Map<String, Object>> rawtimeList, AccessDto conditions) {
        List conditionList = conditions.getConditionList();
        String[] condiToken = conditions.getConditionExpressToken();
        HashMap map = new HashMap(16);
        List<Map<String, Object>> filterList = rawtimeList.stream().filter(rawtime -> this.accessFilterByCondition(conditionList, (Map<String, Object>)rawtime, map, condiToken)).collect(Collectors.toList());
        return filterList;
    }

    private boolean accessFilterByCondition(List<ConditionDto> conditionList, Map<String, Object> rawtime, Map<String, Boolean> map, String[] condiToken) {
        for (ConditionDto dto : conditionList) {
            String bucketProp;
            String param = dto.getParam();
            Object invoke = this.mapping.get(param).apply(rawtime);
            if (invoke instanceof List) {
                List bucketProps = (List)invoke;
                if (CollectionUtils.isEmpty((Collection)bucketProps)) {
                    this.putMap(dto, "", map);
                    continue;
                }
                this.putMap(dto, bucketProps, map);
                continue;
            }
            if (invoke instanceof String) {
                bucketProp = (String)invoke;
                this.putMap(dto, bucketProp, map);
                continue;
            }
            if (!(invoke instanceof Long)) continue;
            bucketProp = String.valueOf(invoke);
            this.putMap(dto, bucketProp, map);
        }
        return this.getResultWithOptimization(condiToken, map);
    }

    private void putMap(ConditionDto dto, List<String> bucketProp, Map<String, Boolean> map) {
        String name = dto.getName();
        String operators = dto.getOperators();
        RuleOperatorEnum ruleOperatorEnum = RuleOperatorEnum.getEnum((String)operators);
        switch (ruleOperatorEnum) {
            case EQUAL: {
                map.put(name, bucketProp.contains(dto.getValue()));
                break;
            }
            case NOT_EQUAL: {
                map.put(name, !bucketProp.contains(dto.getValue()));
                break;
            }
            case IN: {
                Set list = dto.getValueList();
                map.put(name, this.equalsAnyOne(bucketProp, list));
                break;
            }
            case NOT_IN: {
                Set list = dto.getValueList();
                map.put(name, !this.equalsAnyOne(bucketProp, list));
                break;
            }
            case IS_NULL: {
                map.put(name, CollectionUtils.isEmpty(bucketProp));
                break;
            }
            case IS_NOT_NULL: {
                map.put(name, CollectionUtils.isNotEmpty(bucketProp));
            }
        }
    }

    private boolean equalsAnyOne(List<String> bucketProp, Set<String> set) {
        for (String bucketOne : bucketProp) {
            for (String target : set) {
                if (!HRStringUtils.equals((String)target, (String)bucketOne)) continue;
                return true;
            }
        }
        return false;
    }

    private void putMap(ConditionDto dto, String bucketProp, Map<String, Boolean> map) {
        String operators;
        String name = dto.getName();
        switch (operators = dto.getOperators()) {
            case "==": {
                map.put(name, HRStringUtils.equals((String)dto.getValue(), (String)bucketProp));
                break;
            }
            case "!=": {
                map.put(name, !HRStringUtils.equals((String)dto.getValue(), (String)bucketProp));
                break;
            }
            case "in": {
                Set list = dto.getValueList();
                map.put(name, list.contains(bucketProp));
                break;
            }
            case "not_in": {
                Set list = dto.getValueList();
                map.put(name, !list.contains(bucketProp));
                break;
            }
            case "is_null": {
                map.put(name, HRStringUtils.isEmpty((String)bucketProp));
                break;
            }
            case "is_not_null": {
                map.put(name, HRStringUtils.isNotEmpty((String)bucketProp));
            }
        }
    }

    private boolean getResultWithOptimization(String[] tokens, Map<String, Boolean> params) {
        CharSequence[] changeTokens = new String[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            Boolean value;
            String token = tokens[i];
            changeTokens[i] = token.equals("and") ? "&" : (token.equals("or") ? "|" : ((value = params.get(token)) != null ? (value != false ? "1" : "0") : token));
        }
        String str = String.join((CharSequence)"", changeTokens);
        int pro = this.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    public boolean get(String str) {
        int pro = this.pro(str.toCharArray(), 0);
        return (pro & 0x8000000) != 0;
    }

    private int pro(char[] arr, int beginIdx) {
        int idx;
        int culResult = 0x8000000;
        int preSign = 38;
        int len = arr.length;
        for (idx = beginIdx; idx < len; ++idx) {
            int ch = arr[idx];
            if (ch == 41) {
                return idx | culResult;
            }
            if (ch == 40) {
                int pro = this.pro(arr, idx + 1);
                int subAns = pro & 0x8000000;
                int newIdx = pro & 0xF7FFFFFF;
                ch = subAns == 0 ? 48 : 49;
                idx = newIdx;
            }
            if (ch == 124) {
                preSign = ch;
                if (culResult == 0) continue;
                idx = this.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (ch == 38) {
                preSign = ch;
                if (culResult != 0) continue;
                idx = this.getIdx4CurLevel(arr, idx + 1) - 1;
                continue;
            }
            if (ch == 49) {
                if (preSign != 124) continue;
                culResult = 0x8000000;
                continue;
            }
            if (ch != 48 || preSign != 38) continue;
            culResult = 0;
        }
        return idx | culResult;
    }

    private int getIdx4CurLevel(char[] arr, int beginIdx) {
        int idx;
        int len = arr.length;
        int count = 0;
        for (idx = beginIdx; idx < len; ++idx) {
            char ch = arr[idx];
            if (ch == '(') {
                ++count;
                continue;
            }
            if (ch != ')') continue;
            if (count == 0) {
                return idx;
            }
            --count;
        }
        return idx;
    }
}

