/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.business.daterange.access.AccessDto;
import kd.wtc.wtbs.common.enums.TimeBucketPositionEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtp.utils.AccessFilter;
import kd.wtc.wtp.utils.FlxTimeBucketUtils;
import kd.wtc.wtp.utils.PunchCardTagEnum;
import kd.wtc.wtp.utils.ShiftInfo;

public class BillFuncUtil {
    private static final Log LOG = LogFactory.getLog(BillFuncUtil.class);

    public static String getBillInfo(Object[] billArry, String billEntryId, String fieldName) {
        if (BillFuncUtil.checkIsNull(billEntryId, fieldName)) {
            LOG.warn("getBillInfo fieldName is error");
            return "error field";
        }
        for (Object bill : billArry) {
            if (!(bill instanceof Map)) continue;
            Map bill1 = (Map)bill;
            Object fieldValue = bill1.get(fieldName);
            Object fieldBillEntryId = bill1.get("requestBillID");
            if (fieldValue == null || !billEntryId.equals(String.valueOf(fieldBillEntryId))) continue;
            return String.valueOf(fieldValue);
        }
        return "error field";
    }

    public static Object[] getFlxTimeBucketObjectArray(Date effectiveStartCard, Date effectiveEndtCard, Object[] allTimes, Object[] otBills, Object[] tlBills, Object[] vaBills, Object[] flxShift) {
        if (BillFuncUtil.checkIsNull(allTimes, flxShift) || flxShift.length != 2 || allTimes.length == 0) {
            LOG.warn("getFlxTimeBucketObjectArray fieldName is error");
            return null;
        }
        if (BillFuncUtil.checkIsNull(flxShift) || flxShift.length != 2) {
            LOG.warn("getFlxTimeBucketObjectArray flxShift is error");
            return allTimes;
        }
        Date shiftDate = FlxTimeBucketUtils.getValue((Map)allTimes[0], "shiftDate", Date.class);
        ShiftInfo shiftInfo = new ShiftInfo((Date)flxShift[0], (Date)flxShift[1], effectiveStartCard, effectiveEndtCard, shiftDate);
        List<Map<String, Object>> splitFlxTimes = FlxTimeBucketUtils.splitFlxTimes(allTimes, otBills, BillFuncUtil.mergeArrays(tlBills, vaBills), shiftInfo);
        return splitFlxTimes.toArray();
    }

    public static BigDecimal flxExLate(Object[] flxTimes, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes, accessFilters, alldayhour, unit)) {
            LOG.warn("flxExLate fieldName is error");
            return BigDecimal.ZERO;
        }
        List splitFlxTimes = Arrays.stream(flxTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        List<Map<String, Object>> accessFilterList = BillFuncUtil.filterByS("LATE", splitFlxTimes.toArray(), -1, accessFilters);
        return BillFuncUtil.calcRes(accessFilterList, alldayhour, unit);
    }

    public static BigDecimal flxExLvely(Object[] flxTimes, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes, generalDura, accessFilters, unit)) {
            LOG.warn("flxExLvely fieldName is error");
            return BigDecimal.ZERO;
        }
        if (BillFuncUtil.checkIsNull(flxTimes)) {
            LOG.warn("flxExLvely flxTimes is null");
            return generalDura;
        }
        List splitFlxTimes = Arrays.stream(flxTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        List<Map<String, Object>> accessFilterList = BillFuncUtil.filterByS("EARLY", splitFlxTimes.toArray(), -1, accessFilters);
        return BillFuncUtil.calcRes(accessFilterList, alldayhour, unit);
    }

    public static BigDecimal flxAbsent(Object[] flxTimes, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes, generalDura, accessFilters, unit)) {
            LOG.warn("flxExLvely fieldName is error");
            return BigDecimal.ZERO;
        }
        if (BillFuncUtil.checkIsNull(flxTimes)) {
            LOG.warn("flxExLvely flxTimes is null");
            return generalDura;
        }
        List splitFlxTimes = Arrays.stream(flxTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        List<Map<String, Object>> accessFilterList = BillFuncUtil.filterByS("absent", splitFlxTimes.toArray(), -1, accessFilters);
        return BillFuncUtil.calcRes(accessFilterList, alldayhour, unit);
    }

    public static BigDecimal flxSupple(Object[] flxTimes, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes, generalDura, accessFilters, unit)) {
            LOG.warn("flxExLvely fieldName is error");
            return BigDecimal.ZERO;
        }
        if (BillFuncUtil.checkIsNull(flxTimes)) {
            LOG.warn("flxExLvely flxTimes is null");
            return generalDura;
        }
        List splitFlxTimes = Arrays.stream(flxTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        List<Map<String, Object>> accessFilterList = BillFuncUtil.filterByS("supple", splitFlxTimes.toArray(), -1, accessFilters);
        return BillFuncUtil.calcRes(accessFilterList, alldayhour, unit);
    }

    public static BigDecimal tlFlxDura(Object[] flxTimes, Integer dataSoure, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes, dataSoure, accessFilters, unit)) {
            LOG.warn("tlFlxDura fieldName is error");
            return BigDecimal.ZERO;
        }
        return BillFuncUtil.tlAndVaFlxDura(flxTimes, "BT", dataSoure, accessFilters, alldayhour, unit);
    }

    public static BigDecimal vaFlxDura(Object[] flxTimes, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes, accessFilters, generalDura, unit)) {
            LOG.warn("vaFlxDura fieldName is error");
            return BigDecimal.ZERO;
        }
        return BillFuncUtil.tlAndVaFlxDura(flxTimes, "VA", -1, accessFilters, alldayhour, unit);
    }

    public static BigDecimal tlAndVaFlxDura(Object[] flxTimes, String billType, Integer dataSoure, Object[] accessFilters, BigDecimal alldayhour, String unit) {
        if (BillFuncUtil.checkIsNull(flxTimes)) {
            LOG.warn("tlFlxDura flxTimes is null");
            return BigDecimal.ZERO;
        }
        List splitFlxTimes = Arrays.stream(flxTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        List<Map<String, Object>> accessFilterList = BillFuncUtil.filterByS(billType, splitFlxTimes.toArray(), dataSoure, accessFilters);
        if ("VA".equals(billType)) {
            accessFilterList = accessFilterList.stream().filter(vaTime -> {
                String timeBucketPositionCode = FlxTimeBucketUtils.getValue(vaTime, "timeBucketPositionCode", String.class);
                return TimeBucketPositionEnum.IN_SHIFT.code.equals(timeBucketPositionCode);
            }).collect(Collectors.toList());
        }
        return BillFuncUtil.calcRes(accessFilterList, alldayhour, unit);
    }

    private static Map<String, Object> billInfo(List<Map<String, Object>> bills, String entryId) {
        for (Map<String, Object> bill : bills) {
            if (!String.valueOf(entryId).equals(String.valueOf(bill.get("requestBillID")))) continue;
            return bill;
        }
        return new HashMap<String, Object>();
    }

    public static BigDecimal otFlxDura(Object[] flxTimes, String subTimeArray, Integer dataSoure, Object[] accessFilters, BigDecimal alldayhour, BigDecimal generalDura, String unit) {
        if (BillFuncUtil.checkIsNull(dataSoure, accessFilters, generalDura, unit)) {
            LOG.warn("otFlxDura fieldName is error");
            return BigDecimal.ZERO;
        }
        if (flxTimes == null || flxTimes.length == 0) {
            LOG.warn("otFlxDura flxTimes is null");
            return generalDura;
        }
        List splitFlxTimes = Arrays.stream(flxTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        List<Map<String, Object>> accessFilterList = BillFuncUtil.filterByS("OT", splitFlxTimes.toArray(), dataSoure, accessFilters);
        accessFilterList = BillFuncUtil.subFixTime(accessFilterList, subTimeArray);
        return BillFuncUtil.calcRes(accessFilterList, alldayhour, unit);
    }

    private static List<Map<String, Object>> subTime(Map<String, Object> map, Tuple<Date, Date> fixDate) {
        Date startTime = FlxTimeBucketUtils.getValue(map, "startTime", Date.class);
        Date endTime = FlxTimeBucketUtils.getValue(map, "endTime", Date.class);
        ArrayList res = Lists.newArrayListWithCapacity((int)2);
        if (endTime.compareTo((Date)fixDate.getKey()) <= 0 || ((Date)fixDate.getValue()).compareTo(startTime) <= 0) {
            res.add(map);
            return res;
        }
        if (startTime.compareTo((Date)fixDate.getKey()) >= 0 && endTime.compareTo((Date)fixDate.getValue()) <= 0) {
            return res;
        }
        if (startTime.compareTo((Date)fixDate.getKey()) <= 0 && ((Date)fixDate.getKey()).compareTo(endTime) <= 0 && endTime.compareTo((Date)fixDate.getValue()) <= 0) {
            map.put("startTime", startTime);
            map.put("endTime", fixDate.getKey());
            res.add(map);
            return res;
        }
        if (startTime.compareTo((Date)fixDate.getKey()) >= 0 && startTime.compareTo((Date)fixDate.getValue()) <= 0 && ((Date)fixDate.getValue()).compareTo(endTime) <= 0) {
            map.put("startTime", fixDate.getValue());
            map.put("endTime", endTime);
            res.add(map);
            return res;
        }
        if (startTime.compareTo((Date)fixDate.getKey()) <= 0 && endTime.compareTo((Date)fixDate.getValue()) >= 0) {
            HashMap map1 = Maps.newHashMap(map);
            map.put("startTime", startTime);
            map.put("endTime", fixDate.getKey());
            map1.put("startTime", fixDate.getValue());
            map1.put("endTime", endTime);
            res.add(map);
            res.add(map1);
            return res;
        }
        LOG.warn("subTime filterDate:{},{},fixDate:{}", new Object[]{startTime, endTime, fixDate.toString()});
        return res;
    }

    private static List<Map<String, Object>> subFixTime(List<Map<String, Object>> filterList, String subTimeArray) {
        if (WTCStringUtils.isEmpty((String)subTimeArray)) {
            return filterList;
        }
        String[] split = subTimeArray.split(",");
        ArrayList filterListSplit = Lists.newArrayList(filterList);
        ArrayList filterListSplitTemp = Lists.newArrayList(filterList);
        for (String fixTime : split) {
            LocalTime localTimeStart = null;
            LocalTime localTimeEnd = null;
            try {
                String[] splitArray = fixTime.split("-");
                localTimeStart = LocalTime.parse(String.valueOf(splitArray[0]));
                localTimeEnd = LocalTime.parse(String.valueOf(splitArray[1]));
            }
            catch (DateTimeParseException e) {
                LOG.warn("subTimeArray format is error:{}", (Object)subTimeArray);
                return filterList;
            }
            Date fixTimeStart = null;
            Date fixTimeEnd = null;
            filterListSplitTemp = Lists.newArrayList((Iterable)filterListSplit);
            filterListSplit = Lists.newArrayListWithExpectedSize((int)(filterListSplitTemp.size() * 2));
            for (Map map : filterListSplitTemp) {
                if (map == null) continue;
                Date startTime = FlxTimeBucketUtils.getValue(map, "startTime", Date.class);
                Date endTime = FlxTimeBucketUtils.getValue(map, "endTime", Date.class);
                if (WTCDateUtils.toLocalDate((Date)startTime).isEqual(WTCDateUtils.toLocalDate((Date)endTime))) {
                    fixTimeStart = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)startTime), localTimeStart));
                    fixTimeEnd = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)startTime), localTimeEnd));
                    filterListSplit.addAll(BillFuncUtil.subTime(map, (Tuple<Date, Date>)new Tuple((Object)fixTimeStart, (Object)fixTimeEnd)));
                    continue;
                }
                fixTimeStart = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)startTime), localTimeStart));
                fixTimeEnd = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)startTime), localTimeEnd));
                filterListSplit.addAll(BillFuncUtil.subTime(map, (Tuple<Date, Date>)new Tuple((Object)fixTimeStart, (Object)fixTimeEnd)));
                fixTimeStart = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)endTime), localTimeStart));
                fixTimeEnd = WTCDateUtils.toDate((LocalDateTime)LocalDateTime.of(WTCDateUtils.toLocalDate((Date)endTime), localTimeEnd));
                filterListSplit.addAll(BillFuncUtil.subTime(map, (Tuple<Date, Date>)new Tuple((Object)fixTimeStart, (Object)fixTimeEnd)));
            }
        }
        List<Map<String, Object>> uniqueList = BillFuncUtil.removeDuplicates(Sets.newHashSet((Iterable)filterListSplit), "startTime", "endTime");
        return uniqueList;
    }

    private static List<Map<String, Object>> removeDuplicates(Set<Map<String, Object>> list, String ... keyField) {
        HashMap uniqueMap = Maps.newHashMapWithExpectedSize((int)list.size());
        for (Map<String, Object> map : list) {
            StringBuffer keyValue = new StringBuffer();
            for (String s : keyField) {
                keyValue.append(map.get(s));
            }
            uniqueMap.put(keyValue, map);
        }
        return new ArrayList<Map<String, Object>>(uniqueMap.values());
    }

    public static List<Map<String, Object>> filterByS(String billType, Object[] allBillTimes, int dataSoure, Object[] accessFilters) {
        List<Map<String, Object>> timesCollect;
        List<Map<String, Object>> mapList = timesCollect = Arrays.stream(allBillTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList());
        if ("OT".equals(billType)) {
            mapList = timesCollect.stream().filter(splitAllTime -> BillFuncUtil.otFilterByDataSoure(dataSoure, splitAllTime)).collect(Collectors.toList());
        } else if ("BT".equals(billType)) {
            mapList = timesCollect.stream().filter(splitAllTime -> BillFuncUtil.tlFilterByDataSoure(dataSoure, splitAllTime)).collect(Collectors.toList());
        }
        AccessDto conditions = null;
        for (Object accessFilter : accessFilters) {
            Map.Entry map = (Map.Entry)accessFilter;
            switch (billType) {
                case "OT": {
                    if (!"OT".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "BT": {
                    if (!"BT".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "VA": {
                    if (!"VA".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "EARLY": {
                    if (!"EARLY".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "LATE": {
                    if (!"LATE".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "ATT_ORI": {
                    if (!"ATT_ORI".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "absent": {
                    if (!"absent".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
                case "supple": {
                    if (!"supple".equals(map.getKey())) break;
                    conditions = (AccessDto)map.getValue();
                    break;
                }
            }
            if (conditions != null) break;
        }
        if (conditions == null) {
            LOG.warn("{},conditions not found", (Object)billType);
            return mapList;
        }
        List<Map<String, Object>> accessFilterList = new AccessFilter().accessFilterByConditionI(mapList, conditions);
        return accessFilterList;
    }

    public static BigDecimal calcRes(List<Map<String, Object>> accessFilterList, BigDecimal alldayhour, String unit) {
        long flxMilliTime = BillFuncUtil.getMilliTime(accessFilterList);
        BigDecimal decimal = BigDecimal.valueOf(flxMilliTime);
        switch (unit) {
            case "h": {
                return decimal.divide(BigDecimal.valueOf(3600000L), 6, RoundingMode.HALF_UP);
            }
            case "min": {
                return decimal.divide(BigDecimal.valueOf(60000L), 6, RoundingMode.HALF_UP);
            }
            case "day": {
                return decimal.divide(alldayhour.multiply(BigDecimal.valueOf(3600000L)), 6, RoundingMode.HALF_UP);
            }
        }
        LOG.warn("The unit only supports days, hours, minutes, and seconds\uff0cunit error\uff1a" + unit);
        return BigDecimal.ZERO;
    }

    private static long getMilliTime(List<Map<String, Object>> accessFilterList) {
        long millisecond = 0L;
        for (Map<String, Object> map : accessFilterList) {
            Date startTime = FlxTimeBucketUtils.getValue(map, "startTime", Date.class);
            Date endTime = FlxTimeBucketUtils.getValue(map, "endTime", Date.class);
            if (startTime == null || endTime == null) {
                LOG.warn("getMilliTime error");
                return 0L;
            }
            millisecond += endTime.getTime() - startTime.getTime();
        }
        return millisecond;
    }

    private static boolean otFilterByDataSoure(int dataSoure, Map<String, Object> timeMap) {
        boolean isOtBill = timeMap.get("overtimeRequestBillID") != null;
        boolean isTlBill = timeMap.get("travelRequestBillID") != null;
        boolean isCard = String.valueOf(timeMap.get("exceptionTagCode")).contains(PunchCardTagEnum.NORMAL.code);
        switch (dataSoure) {
            case 1: {
                return isOtBill;
            }
            case 2: {
                return isCard && isOtBill;
            }
            case 3: {
                return isCard;
            }
            case 4: {
                return isCard || isTlBill;
            }
            case 5: {
                return (isCard || isTlBill) && isOtBill;
            }
        }
        return true;
    }

    private static boolean tlFilterByDataSoure(int dataSoure, Map<String, Object> timeMap) {
        boolean isBill = timeMap.get("travelRequestBillID") != null;
        boolean isCard = String.valueOf(timeMap.get("exceptionTagCode")).contains(PunchCardTagEnum.NORMAL.code);
        switch (dataSoure) {
            case 1: {
                return isBill;
            }
            case 2: {
                return isCard && isBill;
            }
        }
        return false;
    }

    private static BigDecimal getValueByUnit(String unit, long second) {
        if ("min".equals(unit)) {
            return BigDecimal.valueOf(second).divide(BigDecimal.valueOf(60L));
        }
        if ("h".equals(unit)) {
            return BigDecimal.valueOf(second).divide(BigDecimal.valueOf(3600L));
        }
        return BigDecimal.ZERO;
    }

    private static Object[] mergeArrays(Object[] array1, Object[] array2) {
        Object[] result = new Object[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    private static boolean checkIsNull(Object ... objects) {
        for (Object object : objects) {
            if (object != null) continue;
            return true;
        }
        return false;
    }
}

