/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.utils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.wtc.wtbd.business.retrieval.service.RetrievalMCConfig;
import kd.wtc.wtbs.common.enums.BillSystemParamConfigEnum;
import kd.wtc.wtbs.common.enums.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtbs.common.enums.TimeBucketPositionEnum;
import kd.wtc.wtbs.common.enums.bill.va.SpecialVaTypeEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtbs.common.util.WTCCollections;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Lists;
import kd.wtc.wtbs.common.util.third.collect.Maps;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtbs.wtp.enums.vaplan.BaseSetTimeBreastDayTypeEnum;
import kd.wtc.wtp.utils.PunchCardTagEnum;
import kd.wtc.wtp.utils.ShiftInfo;
import kd.wtc.wtp.utils.ShiftPeriod;

public class FlxTimeBucketUtils {
    private static final String APPLYTYPE_0 = "0";
    private static final String APPLYTYPE_1 = "1";
    private static final String APPLYTYPE_2 = "2";
    private static final String APPLYTYPE_3 = "3";
    private static final Log LOG = LogFactory.getLog(FlxTimeBucketUtils.class);

    private static List<Map<String, Object>> notTbOwerDateBills(List<Map<String, Object>> allTimes, List<Map<String, Object>> billInfos) {
        Date shiftDate = FlxTimeBucketUtils.getValue(allTimes.get(0), "shiftDate", Date.class);
        if (shiftDate == null) {
            Lists.newArrayList();
        }
        HashSet billCode = Sets.newHashSetWithExpectedSize((int)billInfos.size());
        for (Map<String, Object> map2 : allTimes) {
            billCode.add(FlxTimeBucketUtils.getValue(map2, "leaveRequestBillID", String.class));
            billCode.add(FlxTimeBucketUtils.getValue(map2, "travelRequestBillID", String.class));
            billCode.add(FlxTimeBucketUtils.getValue(map2, "overtimeRequestBillID", String.class));
        }
        billCode.remove(null);
        List<Map<String, Object>> notTbBills = billInfos.stream().filter(map -> !billCode.contains(FlxTimeBucketUtils.getValue(map, "requestBillID", String.class))).collect(Collectors.toList());
        notTbBills = notTbBills.stream().filter(map -> FlxTimeBucketUtils.getValue(map, "assignmentDate", Date.class) != null).collect(Collectors.toList());
        notTbBills = notTbBills.stream().filter(map -> shiftDate.compareTo(FlxTimeBucketUtils.getValue(map, "assignmentDate", Date.class)) == 0).collect(Collectors.toList());
        return notTbBills;
    }

    private static List<Map<String, Object>> currentBills(Object[] allTimes, Object[] billInfos) {
        List billsCopy = billInfos != null ? Arrays.stream(billInfos).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList()) : WTCCollections.modifiableEmptyList();
        List allTimesCopy = allTimes != null ? Arrays.stream(allTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList()) : WTCCollections.modifiableEmptyList();
        HashSet billCode = Sets.newHashSetWithExpectedSize((int)billsCopy.size());
        for (Map map2 : allTimesCopy) {
            billCode.add(FlxTimeBucketUtils.getValue(map2, "leaveRequestBillID", String.class));
            billCode.add(FlxTimeBucketUtils.getValue(map2, "travelRequestBillID", String.class));
            billCode.add(FlxTimeBucketUtils.getValue(map2, "overtimeRequestBillID", String.class));
        }
        billCode.remove(null);
        return billsCopy.stream().filter(map -> billCode.contains(FlxTimeBucketUtils.getValue(map, "requestBillID", String.class))).collect(Collectors.toList());
    }

    private static void creatNewTBByBill(List<Map<String, Object>> sortedAllTimes, List<Map<String, Object>> billMaps) {
        ArrayList newTbList = Lists.newArrayListWithCapacity((int)10);
        ArrayList removeTbList = Lists.newArrayListWithCapacity((int)10);
        Date startest = FlxTimeBucketUtils.getValue(sortedAllTimes.get(0), "startTime", Date.class);
        Date endest = FlxTimeBucketUtils.getValue(sortedAllTimes.get(sortedAllTimes.size() - 1), "endTime", Date.class);
        Map<String, Object> tbMod = sortedAllTimes.get(0);
        for (Map<String, Object> billMap : billMaps) {
            HashMap<String, Object> tb3;
            Map<String, Object> cutTb;
            HashMap<String, Object> tb2;
            HashMap<String, Object> tb1;
            if (!"VA".equals(FlxTimeBucketUtils.getValue(billMap, "bizTypeCode", String.class))) continue;
            Date billStartDate = FlxTimeBucketUtils.getValue(billMap, "startTime", Date.class);
            Date billEndDate = FlxTimeBucketUtils.getValue(billMap, "endTime", Date.class);
            if (billStartDate == null || billEndDate == null) continue;
            if (billEndDate.compareTo(startest) < 0) {
                tb1 = new HashMap<String, Object>(tbMod);
                tb1.put("startTime", billStartDate);
                tb1.put("endTime", billEndDate);
                tb1.put("leaveRequestCode", billMap.get("requestCode"));
                tb1.put("leaveRequestBillID", billMap.get("requestBillID"));
                newTbList.add(tb1);
                tb2 = new HashMap<String, Object>(tbMod);
                tb2.put("startTime", billEndDate);
                tb2.put("endTime", startest);
                newTbList.add(tb2);
                continue;
            }
            if (billEndDate.compareTo(startest) == 0) {
                tb1 = new HashMap<String, Object>(tbMod);
                tb1.put("startTime", billStartDate);
                tb1.put("endTime", billEndDate);
                tb1.put("leaveRequestCode", billMap.get("requestCode"));
                tb1.put("leaveRequestBillID", billMap.get("requestBillID"));
                newTbList.add(tb1);
                continue;
            }
            if (billStartDate.compareTo(endest) > 0) {
                tb1 = new HashMap<String, Object>(tbMod);
                tb1.put("startTime", endest);
                tb1.put("endTime", billStartDate);
                newTbList.add(tb1);
                tb2 = new HashMap<String, Object>(tbMod);
                tb2.put("startTime", billStartDate);
                tb2.put("endTime", billEndDate);
                tb2.put("leaveRequestCode", billMap.get("requestCode"));
                tb2.put("leaveRequestBillID", billMap.get("requestBillID"));
                newTbList.add(tb2);
                continue;
            }
            if (billStartDate.compareTo(endest) == 0) {
                tb1 = new HashMap<String, Object>(tbMod);
                tb1.put("startTime", billStartDate);
                tb1.put("endTime", billEndDate);
                tb1.put("leaveRequestCode", billMap.get("requestCode"));
                tb1.put("leaveRequestBillID", billMap.get("requestBillID"));
                newTbList.add(tb1);
                continue;
            }
            if (startest.compareTo(billStartDate) > 0 && startest.compareTo(billEndDate) < 0) {
                tb1 = new HashMap<String, Object>(tbMod);
                tb1.put("startTime", billStartDate);
                tb1.put("endTime", startest);
                tb1.put("leaveRequestCode", billMap.get("requestCode"));
                tb1.put("leaveRequestBillID", billMap.get("requestBillID"));
                newTbList.add(tb1);
                tb2 = new HashMap<String, Object>(tbMod);
                tb2.put("startTime", startest);
                tb2.put("endTime", billEndDate);
                tb2.put("leaveRequestCode", billMap.get("requestCode"));
                tb2.put("leaveRequestBillID", billMap.get("requestBillID"));
                newTbList.add(tb2);
                cutTb = FlxTimeBucketUtils.getTb(sortedAllTimes, endest, null);
                tb3 = new HashMap<String, Object>(cutTb);
                tb3.put("startTime", billEndDate);
                newTbList.add(tb3);
                removeTbList.add(cutTb);
                continue;
            }
            if (endest.compareTo(billStartDate) <= 0 || endest.compareTo(billEndDate) >= 0) continue;
            tb1 = new HashMap<String, Object>(tbMod);
            tb1.put("startTime", billStartDate);
            tb1.put("endTime", endest);
            tb1.put("leaveRequestCode", billMap.get("requestCode"));
            tb1.put("leaveRequestBillID", billMap.get("requestBillID"));
            newTbList.add(tb1);
            tb2 = new HashMap<String, Object>(tbMod);
            tb2.put("startTime", endest);
            tb2.put("endTime", billEndDate);
            tb2.put("leaveRequestCode", billMap.get("requestCode"));
            tb2.put("leaveRequestBillID", billMap.get("requestBillID"));
            newTbList.add(tb2);
            cutTb = FlxTimeBucketUtils.getTb(sortedAllTimes, null, endest);
            tb3 = new HashMap<String, Object>(cutTb);
            tb3.put("endTime", billStartDate);
            newTbList.add(tb3);
            removeTbList.add(cutTb);
        }
        sortedAllTimes.addAll(newTbList);
        sortedAllTimes.removeAll(removeTbList);
        sortedAllTimes.remove(null);
    }

    private static Map<String, Object> getTb(List<Map<String, Object>> tbs, Date startTime, Date endTime) {
        for (Map<String, Object> tb : tbs) {
            Date startDate = FlxTimeBucketUtils.getValue(tb, "startTime", Date.class);
            Date endDate = FlxTimeBucketUtils.getValue(tb, "endTime", Date.class);
            if (endTime == null && startTime != null && startTime.compareTo(startDate) == 0) {
                return tb;
            }
            if (startTime == null && endTime != null && endTime.compareTo(endDate) == 0) {
                return tb;
            }
            if (startTime == null || endTime == null || startTime.compareTo(startDate) != 0 || endTime.compareTo(endDate) != 0) continue;
            return tb;
        }
        return null;
    }

    public static List<Map<String, Object>> splitFlxTimes(Object[] allTimes, Object[] otBillInfos, Object[] vaTlbillInfos, ShiftInfo shiftInfo) {
        List allTimesCopy = allTimes != null ? Arrays.stream(allTimes).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList()) : WTCCollections.modifiableEmptyList();
        List<Map<String, Object>> sortedAllTimes = allTimesCopy.stream().sorted(Comparator.comparingLong(map -> FlxTimeBucketUtils.getValue(map, "startTime", Date.class).getTime())).collect(Collectors.toList());
        List<ShiftPeriod> shiftPeriodList = FlxTimeBucketUtils.shiftPeriodMap().get(TimeBucketPositionEnum.IN_REST.id);
        TreeSet<Date> restStartSet = new TreeSet<Date>();
        TreeSet<Date> restEndSet = new TreeSet<Date>();
        for (Map time2 : allTimesCopy) {
            String value = FlxTimeBucketUtils.getValue(time2, "timeBucketPositionCode", String.class);
            if (!StringUtils.equals((CharSequence)shiftPeriodList.get(0).getNumber(), (CharSequence)value)) continue;
            restStartSet.add(FlxTimeBucketUtils.getValue(time2, "startTime", Date.class));
            restEndSet.add(FlxTimeBucketUtils.getValue(time2, "endTime", Date.class));
        }
        if (WTCCollections.isNotEmpty(restStartSet) && WTCCollections.isNotEmpty(restEndSet)) {
            shiftInfo.setRestStart((Date)restStartSet.first());
            shiftInfo.setRestEnd((Date)restEndSet.last());
        }
        List bills = vaTlbillInfos != null && vaTlbillInfos.length > 0 ? Arrays.stream(vaTlbillInfos).map(time -> Maps.newHashMap((Map)((Map)time))).collect(Collectors.toList()) : WTCCollections.modifiableEmptyList();
        FlxTimeBucketUtils.creatNewTBByBill(sortedAllTimes, FlxTimeBucketUtils.notTbOwerDateBills(sortedAllTimes, bills));
        List<Map<String, Object>> otBillsCopy = FlxTimeBucketUtils.currentBills(sortedAllTimes.toArray(), otBillInfos);
        List<Map<String, Object>> vaTlbillInfosCopy = FlxTimeBucketUtils.currentBills(sortedAllTimes.toArray(), vaTlbillInfos);
        ArrayList allbills = Lists.newArrayList();
        if (null != otBillInfos && otBillInfos.length > 0) {
            allbills.addAll(FlxTimeBucketUtils.getOtBillInfos((Tuple<Date, Date>)new Tuple((Object)shiftInfo.getRestStart(), (Object)shiftInfo.getRestEnd()), otBillsCopy, shiftInfo));
        }
        if (vaTlbillInfos != null && vaTlbillInfos.length > 0) {
            allbills.addAll(FlxTimeBucketUtils.getVaAndLtBillInfos(vaTlbillInfosCopy, shiftInfo));
        }
        List<Map<String, Object>> splitAllTimes = FlxTimeBucketUtils.splitAllTimes(sortedAllTimes, allbills, shiftInfo);
        FlxTimeBucketUtils.setTag(splitAllTimes, shiftInfo);
        FlxTimeBucketUtils.splitAllTimesAndBill(splitAllTimes, allbills);
        splitAllTimes.remove(null);
        return splitAllTimes.stream().map(hashMap -> Collections.unmodifiableMap(hashMap)).collect(Collectors.toList());
    }

    private static List<Map<String, Object>> getOtBillInfos(Tuple<Date, Date> restTuple, List<Map<String, Object>> otBillInfos, ShiftInfo shiftInfo) {
        List otBillInfosFilter = otBillInfos.stream().filter(bill -> "OT".equals(bill.get("bizTypeCode"))).collect(Collectors.toList());
        if (otBillInfosFilter.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        List<Map<String, Object>> listd = otBillInfosFilter.stream().filter(bill -> APPLYTYPE_1.equals(String.valueOf(bill.get("requestType")))).collect(Collectors.toList());
        List listc = otBillInfosFilter.stream().filter(bill -> APPLYTYPE_2.equals(String.valueOf(bill.get("requestType")))).collect(Collectors.toList());
        listc.sort(Comparator.comparingLong(map -> FlxTimeBucketUtils.getValue(map, "lengthOfTime", Long.class)));
        List<Tuple<Date, Date>> billTuples = listd.stream().map(param -> FlxTimeBucketUtils.getValue(param, "startTime", Date.class) != null ? new Tuple((Object)FlxTimeBucketUtils.getValue(param, "startTime", Date.class), (Object)FlxTimeBucketUtils.getValue(param, "endTime", Date.class)) : null).collect(Collectors.toList());
        billTuples.sort(Comparator.comparing(Tuple::getKey));
        Date lastOtBillTime = WTCCollections.isNotEmpty(billTuples) ? (Date)((Tuple)billTuples.get(billTuples.size() - 1)).getValue() : shiftInfo.getFlxShiftEnd();
        for (Map map2 : listc) {
            List<Tuple<Date, Date>> otNtervals = FlxTimeBucketUtils.otNtervals(restTuple, billTuples, shiftInfo);
            Long lengthOfTime = FlxTimeBucketUtils.getValue(map2, "lengthOfTime", Long.class);
            if (lengthOfTime == null) continue;
            map2.put("startTime", null);
            map2.put("endTime", null);
            Date startTime = null;
            Date endTime = null;
            for (Tuple<Date, Date> otNterval : otNtervals) {
                long ntervalMillis = ((Date)otNterval.getValue()).getTime() - ((Date)otNterval.getKey()).getTime();
                if (lengthOfTime == null || ntervalMillis < lengthOfTime * 1000L) continue;
                startTime = (Date)otNterval.getKey();
                endTime = new Date(startTime.getTime() + lengthOfTime * 1000L);
                map2.put("startTime", startTime);
                map2.put("endTime", endTime);
                billTuples.add((Tuple<Date, Date>)new Tuple((Object)startTime, (Object)endTime));
                break;
            }
            if (map2.get("startTime") == null) {
                startTime = lastOtBillTime;
                endTime = new Date(lastOtBillTime.getTime() + lengthOfTime * 1000L);
                map2.put("startTime", lastOtBillTime);
                map2.put("endTime", new Date(lastOtBillTime.getTime() + lengthOfTime * 1000L));
                billTuples.add((Tuple<Date, Date>)new Tuple((Object)startTime, (Object)endTime));
                lastOtBillTime = endTime;
            }
            listd.add(map2);
        }
        return listd;
    }

    private static List<Map<String, Object>> modifyVaAndLtBillInfos(List<Map<String, Object>> billInfos, ShiftInfo shiftInfo) {
        for (Map<String, Object> billInfo : billInfos) {
            boolean isVaOrBt = "VA".equals(billInfo.get("bizTypeCode")) || "BT".equals(billInfo.get("bizTypeCode"));
            if (!isVaOrBt) continue;
            LocalDate startDate = WTCDateUtils.toLocalDate((Date)FlxTimeBucketUtils.getValue(billInfo, "startTime", Date.class));
            LocalDate endDate = WTCDateUtils.toLocalDate((Date)FlxTimeBucketUtils.getValue(billInfo, "endTime", Date.class));
            String startTimeType = String.valueOf(billInfo.get("startTimeType"));
            if (APPLYTYPE_3.equals(startTimeType) || startDate == null || endDate == null || startDate.isEqual(endDate)) continue;
            if (startDate.isEqual(WTCDateUtils.toLocalDate((Date)shiftInfo.getShiftDate()))) {
                billInfo.put("endTime", shiftInfo.getFlxShiftEnd());
                billInfo.put("endTimeType", APPLYTYPE_1);
                continue;
            }
            if (endDate.isEqual(WTCDateUtils.toLocalDate((Date)shiftInfo.getShiftDate()))) {
                billInfo.put("startTime", shiftInfo.getFlxShiftStart());
                billInfo.put("startTimeType", APPLYTYPE_0);
                continue;
            }
            billInfo.put("startTime", shiftInfo.getFlxShiftStart());
            billInfo.put("startTimeType", APPLYTYPE_2);
            billInfo.put("endTime", shiftInfo.getFlxShiftEnd());
            billInfo.put("endTimeType", APPLYTYPE_2);
        }
        return billInfos;
    }

    private static List<Map<String, Object>> getVaAndLtBillInfos(List<Map<String, Object>> billInfos, ShiftInfo shiftInfo) {
        FlxTimeBucketUtils.modifyVaAndLtBillInfos(billInfos, shiftInfo);
        for (Map<String, Object> billInfo : billInfos) {
            boolean isSpecial;
            boolean isVaOrBt = "VA".equals(billInfo.get("bizTypeCode")) || "BT".equals(billInfo.get("bizTypeCode"));
            boolean bl = isSpecial = "VA".equals(billInfo.get("bizTypeCode")) && SpecialVaTypeEnum.LACTATION_TYPE.vaType.equals(billInfo.get("specialvatype"));
            if (isSpecial) {
                Date startTime;
                if (BaseSetTimeBreastDayTypeEnum.COME_LATE.code.equals(billInfo.get("specialvamethod"))) {
                    startTime = FlxTimeBucketUtils.getValue(billInfo, "startTime", Date.class);
                    Date endTime = FlxTimeBucketUtils.getValue(billInfo, "endTime", Date.class);
                    if (startTime == null || endTime == null) continue;
                    billInfo.put("startTime", shiftInfo.getFlxShiftStart());
                    billInfo.put("endTime", new Date(shiftInfo.getFlxShiftStart().getTime() + (endTime.getTime() - startTime.getTime())));
                    continue;
                }
                if (!BaseSetTimeBreastDayTypeEnum.GO_EARLY.code.equals(billInfo.get("specialvamethod"))) continue;
                startTime = FlxTimeBucketUtils.getValue(billInfo, "startTime", Date.class);
                Date endTime = FlxTimeBucketUtils.getValue(billInfo, "endTime", Date.class);
                if (startTime == null || endTime == null) continue;
                billInfo.put("startTime", new Date(shiftInfo.getFlxShiftEnd().getTime() - (endTime.getTime() - startTime.getTime())));
                billInfo.put("endTime", shiftInfo.getFlxShiftEnd());
                continue;
            }
            if (!isVaOrBt) continue;
            switch (String.valueOf(billInfo.get("startTimeType"))) {
                case "0": 
                case "2": {
                    billInfo.put("startTime", shiftInfo.getFlxShiftStart());
                    break;
                }
                case "1": {
                    break;
                }
            }
            switch (String.valueOf(billInfo.get("endTimeType"))) {
                case "0": {
                    break;
                }
                case "1": 
                case "2": {
                    billInfo.put("endTime", shiftInfo.getFlxShiftEnd());
                    break;
                }
            }
        }
        return billInfos;
    }

    private static void splitByEarAndLat(List<Map<String, Object>> allTimes, List<Map<String, Object>> billInfos, ShiftInfo shiftInfo) {
        List sortedAllTimes = allTimes.stream().sorted(Comparator.comparingLong(map -> FlxTimeBucketUtils.getValue(map, "startTime", Date.class).getTime())).collect(Collectors.toList());
        Date earliestDate = FlxTimeBucketUtils.getValue((Map)sortedAllTimes.get(0), "startTime", Date.class);
        Date latestDate = FlxTimeBucketUtils.getValue((Map)sortedAllTimes.get(sortedAllTimes.size() - 1), "endTime", Date.class);
        if (shiftInfo.getFlxShiftStart().compareTo(earliestDate) < 0) {
            HashMap earliestMap = Maps.newHashMap((Map)((Map)sortedAllTimes.get(0)));
            earliestMap.put("startTime", shiftInfo.getFlxShiftStart());
            earliestMap.put("endTime", earliestDate);
            earliestDate = shiftInfo.getFlxShiftStart();
            allTimes.add(earliestMap);
        }
        if (shiftInfo.getFlxShiftEnd().compareTo(latestDate) > 0) {
            HashMap latestMap = Maps.newHashMap((Map)((Map)sortedAllTimes.get(sortedAllTimes.size() - 1)));
            latestMap.put("startTime", latestDate);
            latestMap.put("endTime", shiftInfo.getFlxShiftEnd());
            latestDate = shiftInfo.getFlxShiftEnd();
            allTimes.add(latestMap);
        }
        if (WTCCollections.isEmpty(billInfos)) {
            return;
        }
        List sortedbillInfos = billInfos.stream().sorted(Comparator.comparingLong(map -> FlxTimeBucketUtils.getValue(map, "startTime", Date.class).getTime())).collect(Collectors.toList());
        Date billEarliestDate = FlxTimeBucketUtils.getValue((Map)sortedbillInfos.get(0), "startTime", Date.class);
        Date billLatestDate = FlxTimeBucketUtils.getValue((Map)sortedbillInfos.get(sortedbillInfos.size() - 1), "endTime", Date.class);
        if (earliestDate != null && earliestDate.compareTo(billEarliestDate) > 0) {
            HashMap earliestMap = Maps.newHashMap(allTimes.get(0));
            earliestMap.put("startTime", billEarliestDate);
            earliestMap.put("endTime", earliestDate);
            allTimes.add(earliestMap);
        }
        if (latestDate != null && latestDate.compareTo(billLatestDate) < 0) {
            HashMap latestMap = Maps.newHashMap(allTimes.get(allTimes.size() - 1));
            latestMap.put("startTime", latestDate);
            latestMap.put("endTime", billLatestDate);
            allTimes.add(latestMap);
        }
    }

    private static boolean checkTimeMap(Map<String, Object> timeMap) {
        Date start = FlxTimeBucketUtils.getValue(timeMap, "startTime", Date.class);
        Date end = FlxTimeBucketUtils.getValue(timeMap, "endTime", Date.class);
        return start != null && end != null && start.compareTo(end) != 0;
    }

    private static Map<Long, List<ShiftPeriod>> shiftPeriodMap() {
        List shiftPeriodList = null;
        try {
            Map leafDyMap = BusinessDataServiceHelper.loadFromCache((String)"wtbd_shiftperiod", (String)"id,number", (QFilter[])new QFilter[0]);
            shiftPeriodList = leafDyMap.values().stream().map(obj -> new ShiftPeriod().setName((OrmLocaleValue)obj.get("name")).setId(obj.getLong("id")).setNumber(obj.getString("number"))).collect(Collectors.toList());
            shiftPeriodList.remove(null);
        }
        catch (Exception exception) {
            LOG.info("wtbd_shiftperiod query error:{}", (Object)exception.getMessage());
        }
        Map<Long, List<ShiftPeriod>> shiftPeriodMap = shiftPeriodList != null && shiftPeriodList.size() > 0 ? shiftPeriodList.stream().collect(Collectors.groupingBy(ShiftPeriod::getId)) : Collections.emptyMap();
        return shiftPeriodMap;
    }

    private static void setTag(List<Map<String, Object>> allTimes, ShiftInfo shiftInfo) {
        String lang = RetrievalMCConfig.defaultConfig().getRetrievalLang();
        Map<Long, List<ShiftPeriod>> shiftPeriodMap = FlxTimeBucketUtils.shiftPeriodMap();
        for (Map<String, Object> timeMap : allTimes) {
            Tuple<ShiftTimeBucketPropertyEnum, TimeBucketPositionEnum> tuple = shiftInfo.tbAttributeTag(timeMap);
            PunchCardTagEnum exTag = shiftInfo.exTag(timeMap);
            List<ShiftPeriod> shiftPeriodList = shiftPeriodMap.get(((ShiftTimeBucketPropertyEnum)tuple.getKey()).id);
            if (WTCCollections.isNotEmpty(shiftPeriodList)) {
                timeMap.put("timeBucketAttribute", shiftPeriodList.get(0).getName().get((Object)lang));
                timeMap.put("timeBucketAttributeCode", shiftPeriodList.get(0).getNumber());
            }
            if (WTCCollections.isNotEmpty(shiftPeriodList = shiftPeriodMap.get(((TimeBucketPositionEnum)tuple.getValue()).id))) {
                timeMap.put("timeBucketPosition", shiftPeriodList.get(0).getName().get((Object)lang));
                timeMap.put("timeBucketPositionCode", shiftPeriodList.get(0).getNumber());
            }
            timeMap.put("exceptionTag", exTag.name.loadKDString(new Object[]{lang}));
            timeMap.put("exceptionTagCode", exTag.code);
        }
    }

    private static List<Map<String, Object>> splitAllTimes(List<Map<String, Object>> allTimes, List<Map<String, Object>> billInfos, ShiftInfo shiftInfo) {
        FlxTimeBucketUtils.splitByEarAndLat(allTimes, billInfos, shiftInfo);
        List<Object> split = Lists.newArrayListWithCapacity((int)allTimes.size());
        for (Map<String, Object> map2 : allTimes) {
            HashMap<String, Object> m1;
            Date date = FlxTimeBucketUtils.getValue(map2, "startTime", Date.class);
            Date endTime = FlxTimeBucketUtils.getValue(map2, "endTime", Date.class);
            if (shiftInfo.getFlxShiftStart().compareTo(date) >= 0 && shiftInfo.getFlxShiftStart().compareTo(endTime) <= 0) {
                m1 = new HashMap<String, Object>(map2);
                m1.put("startTime", shiftInfo.getFlxShiftStart());
                HashMap<String, Object> hashMap = new HashMap<String, Object>(map2);
                hashMap.put("endTime", shiftInfo.getFlxShiftStart());
                if (FlxTimeBucketUtils.checkTimeMap(m1)) {
                    split.add(m1);
                }
                if (!FlxTimeBucketUtils.checkTimeMap(hashMap)) continue;
                split.add(hashMap);
                continue;
            }
            if (shiftInfo.getFlxShiftEnd().compareTo(date) >= 0 && shiftInfo.getFlxShiftEnd().compareTo(endTime) <= 0) {
                m1 = new HashMap<String, Object>(map2);
                m1.put("startTime", shiftInfo.getFlxShiftEnd());
                HashMap<String, Object> hashMap = new HashMap<String, Object>(map2);
                hashMap.put("endTime", shiftInfo.getFlxShiftEnd());
                if (FlxTimeBucketUtils.checkTimeMap(m1)) {
                    split.add(m1);
                }
                if (!FlxTimeBucketUtils.checkTimeMap(hashMap)) continue;
                split.add(hashMap);
                continue;
            }
            split.add(map2);
        }
        if (WTCCollections.isEmpty(billInfos)) {
            return split;
        }
        TreeSet<Date> billDateTime = new TreeSet<Date>();
        for (Map<String, Object> map3 : billInfos) {
            Date startTime = FlxTimeBucketUtils.getValue(map3, "startTime", Date.class);
            Date endTime = FlxTimeBucketUtils.getValue(map3, "endTime", Date.class);
            billDateTime.add(startTime);
            billDateTime.add(endTime);
        }
        split = split.stream().sorted(Comparator.comparingLong(map -> FlxTimeBucketUtils.getValue(map, "startTime", Date.class).getTime())).collect(Collectors.toList());
        for (Date datetime : billDateTime) {
            HashSet hashSet = Sets.newHashSetWithExpectedSize((int)allTimes.size());
            for (Map map4 : split) {
                hashSet.addAll(FlxTimeBucketUtils.splitTimes(map4, datetime));
            }
            split = Lists.newArrayList((Iterable)hashSet);
        }
        return Lists.newArrayList(split);
    }

    private static List<Map<String, Object>> splitTimes(Map<String, Object> timeMap, Date dateTime) {
        if (timeMap == null) {
            return WTCCollections.modifiableEmptyList();
        }
        ArrayList res = Lists.newArrayListWithCapacity((int)(timeMap.size() * 2));
        if (dateTime == null) {
            res.add(timeMap);
            return res;
        }
        Date startTime = FlxTimeBucketUtils.getValue(timeMap, "startTime", Date.class);
        Date endTime = FlxTimeBucketUtils.getValue(timeMap, "endTime", Date.class);
        if (dateTime != null && startTime != null && endTime != null && dateTime.after(startTime) && dateTime.before(endTime)) {
            HashMap<String, Object> tempMap1 = new HashMap<String, Object>(timeMap);
            HashMap<String, Object> tempMap2 = new HashMap<String, Object>(timeMap);
            tempMap1.put("startTime", dateTime);
            tempMap2.put("endTime", dateTime);
            res.add(tempMap1);
            res.add(tempMap2);
        } else {
            res.add(timeMap);
        }
        return res;
    }

    private static List<Tuple<Date, Date>> otNtervals(Tuple<Date, Date> restTuple, List<Tuple<Date, Date>> billTuples, ShiftInfo shiftInfo) {
        int i;
        billTuples = billTuples.stream().sorted(Comparator.comparing(Tuple::getKey)).collect(Collectors.toList());
        billTuples.sort(Comparator.comparing(Tuple::getKey));
        ArrayList<Object> otNtervals = new ArrayList<Object>();
        List billTuplesRest = billTuples.stream().filter(billTuple -> FlxTimeBucketUtils.intersection((Date)restTuple.getKey(), (Date)restTuple.getValue(), (Date)billTuple.getKey(), (Date)billTuple.getValue())).collect(Collectors.toList());
        List billTuplesRestN = billTuples.stream().filter(billTuple -> !FlxTimeBucketUtils.intersection((Date)restTuple.getKey(), (Date)restTuple.getValue(), (Date)billTuple.getKey(), (Date)billTuple.getValue())).collect(Collectors.toList());
        if (WTCCollections.isNotEmpty(billTuplesRestN)) {
            if (shiftInfo.getFlxShiftEnd().compareTo((Date)((Tuple)billTuplesRestN.get(0)).getKey()) < 0) {
                otNtervals.add(new Tuple((Object)shiftInfo.getFlxShiftEnd(), ((Tuple)billTuplesRestN.get(0)).getKey()));
            }
            for (i = 0; i < billTuplesRestN.size() - 1; i += 2) {
                otNtervals.add(new Tuple(((Tuple)billTuples.get(i)).getValue(), ((Tuple)billTuples.get(i + 1)).getKey()));
            }
            otNtervals.add(new Tuple(((Tuple)billTuples.get(billTuples.size() - 1)).getValue(), (Object)WTCDateUtils.addDays((Date)((Date)((Tuple)billTuples.get(billTuples.size() - 1)).getValue()), (int)2)));
        }
        if (WTCCollections.isNotEmpty(billTuplesRest)) {
            if (restTuple != null && restTuple.getKey() != null && restTuple.getValue() != null) {
                if (((Date)restTuple.getKey()).compareTo((Date)((Tuple)billTuplesRest.get(0)).getKey()) < 0) {
                    otNtervals.add(new Tuple(restTuple.getKey(), ((Tuple)billTuplesRest.get(0)).getKey()));
                }
                for (i = 0; i < billTuplesRest.size() - 1; i += 2) {
                    Date start = (Date)((Tuple)billTuplesRest.get(i)).getValue();
                    Date end = (Date)((Tuple)billTuplesRest.get(i + 1)).getKey();
                    if (start == null || end == null) continue;
                    otNtervals.add(new Tuple((Object)start, (Object)end));
                }
                if (((Date)restTuple.getValue()).compareTo((Date)((Tuple)billTuplesRest.get(billTuplesRest.size() - 1)).getValue()) > 0) {
                    otNtervals.add(new Tuple(((Tuple)billTuplesRest.get(billTuplesRest.size() - 1)).getValue(), restTuple.getValue()));
                }
            }
        } else if (restTuple != null && restTuple.getKey() != null && restTuple.getValue() != null) {
            otNtervals.add(restTuple);
        }
        List<Tuple<Date, Date>> otNtervalsList = otNtervals.stream().sorted(Comparator.comparing(Tuple::getKey)).collect(Collectors.toList());
        return otNtervalsList;
    }

    private static void splitAllTimesAndBill(List<Map<String, Object>> splitAllTimes, List<Map<String, Object>> billInfos) {
        for (Map<String, Object> splitAllTime : splitAllTimes) {
            Date startTime = FlxTimeBucketUtils.getValue(splitAllTime, "startTime", Date.class);
            Date endTime = FlxTimeBucketUtils.getValue(splitAllTime, "endTime", Date.class);
            splitAllTime.put("billTag", "\u3001");
            splitAllTime.put("billTagCode", "\u3001");
            splitAllTime.put("overtimeRequestCode", null);
            splitAllTime.put("overtimeRequestBillID", null);
            splitAllTime.put("leaveRequestCode", null);
            splitAllTime.put("leaveRequestBillID", null);
            splitAllTime.put("travelRequestCode", null);
            splitAllTime.put("travelRequestBillID", null);
            for (Map<String, Object> billInfo : billInfos) {
                Date billEndTime;
                Date billStartTime = FlxTimeBucketUtils.getValue(billInfo, "startTime", Date.class);
                if (!FlxTimeBucketUtils.isInclude(startTime, endTime, billStartTime, billEndTime = FlxTimeBucketUtils.getValue(billInfo, "endTime", Date.class))) continue;
                if ("OT".equals(FlxTimeBucketUtils.getValue(billInfo, "bizTypeCode", String.class))) {
                    splitAllTime.put("billTag", splitAllTime.get("billTag") + BillSystemParamConfigEnum.OT.getTypeName() + "\u3001");
                    splitAllTime.put("billTagCode", splitAllTime.get("billTagCode") + "4" + "\u3001");
                    splitAllTime.put("overtimeRequestCode", String.valueOf(billInfo.get("requestCode")));
                    splitAllTime.put("overtimeRequestBillID", String.valueOf(billInfo.get("requestBillID")));
                }
                if ("VA".equals(FlxTimeBucketUtils.getValue(billInfo, "bizTypeCode", String.class))) {
                    splitAllTime.put("billTag", splitAllTime.get("billTag") + BillSystemParamConfigEnum.ABS.getTypeName() + "\u3001");
                    splitAllTime.put("billTagCode", splitAllTime.get("billTagCode") + APPLYTYPE_2 + "\u3001");
                    splitAllTime.put("leaveRequestCode", String.valueOf(billInfo.get("requestCode")));
                    splitAllTime.put("leaveRequestBillID", String.valueOf(billInfo.get("requestBillID")));
                }
                if (!"BT".equals(FlxTimeBucketUtils.getValue(billInfo, "bizTypeCode", String.class))) continue;
                splitAllTime.put("billTag", splitAllTime.get("billTag") + BillSystemParamConfigEnum.BUSITRIP.getTypeName() + "\u3001");
                splitAllTime.put("billTagCode", splitAllTime.get("billTagCode") + APPLYTYPE_1 + "\u3001");
                splitAllTime.put("travelRequestCode", String.valueOf(billInfo.get("requestCode")));
                splitAllTime.put("travelRequestBillID", String.valueOf(billInfo.get("requestBillID")));
            }
            splitAllTime.put("billTag", FlxTimeBucketUtils.removeLeadingAndTrailingCommas(String.valueOf(splitAllTime.get("billTag"))));
            splitAllTime.put("billTagCode", FlxTimeBucketUtils.removeLeadingAndTrailingCommas(String.valueOf(splitAllTime.get("billTagCode"))));
        }
    }

    private static String removeLeadingAndTrailingCommas(String s) {
        int end;
        int start;
        if (s == null || s.isEmpty()) {
            return s;
        }
        for (start = 0; start < s.length() && s.charAt(start) == '\u3001'; ++start) {
        }
        for (end = s.length() - 1; end >= start && s.charAt(end) == '\u3001'; --end) {
        }
        return s.substring(start, end + 1);
    }

    public static <T> T getValue(Map<String, Object> map, String key, Class<T> clazz) {
        Object obj = map.get(key);
        if (clazz.isInstance(obj)) {
            return clazz.cast(obj);
        }
        LOG.info("obj cast error:{}", (Object)key);
        return null;
    }

    private static boolean isInclude(Date s1, Date e1, Date s2, Date e2) {
        return s1 != null && e1 != null && s2 != null && s2.compareTo(s1) <= 0 && e2.compareTo(e1) >= 0;
    }

    public static boolean intersection(Date s1, Date e1, Date s2, Date e2) {
        if (s1 == null || s2 == null || e1 == null || e2 == null) {
            return false;
        }
        return s1.compareTo(e2) < 0 && s2.compareTo(e1) < 0;
    }
}

