/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.wtc.wtbs.business.daterange.DateRangeServiceImpl;
import kd.wtc.wtbs.common.util.WTCCollectionIndexUtil;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtbs.common.util.third.util.CollectionUtils;
import kd.wtc.wtbs.common.util.third.util.StringUtils;
import kd.wtc.wtp.common.formula.FilterModel;
import kd.wtc.wtp.common.kdstring.FormulaKDString;

public class FormulaFuncUtil {
    private static final String UNIT_MINUTE = "min";
    private static final String UNIT_HOUR = "h";
    private static final int SIXTY = 60;
    private static final String START_TIME_SOURCE_EFFECT_CARD = "10";
    private static final BigDecimal CONDITION_ZERO = BigDecimal.ZERO;
    private static final BigDecimal CONDITION_ONE = BigDecimal.ONE;
    private static final BigDecimal CONDITION_TWO = BigDecimal.valueOf(Long.parseLong("2"), 0);
    private static final Log LOG = LogFactory.getLog(FormulaFuncUtil.class);

    public static BigDecimal getTimeDiffWithUnit(Date date1, Date date2, String unit) {
        BigDecimal result;
        if (null == date1 || null == date2) {
            return BigDecimal.ZERO;
        }
        LocalDateTime dateTime1 = WTCDateUtils.toLocalDateTime((Date)date1);
        LocalDateTime dateTime2 = WTCDateUtils.toLocalDateTime((Date)date2);
        long diffInMin = ChronoUnit.MINUTES.between(dateTime2, dateTime1);
        switch (unit) {
            case "min": {
                result = BigDecimal.valueOf(diffInMin);
                break;
            }
            case "h": {
                result = BigDecimal.valueOf(diffInMin).divide(BigDecimal.valueOf(60L), 6, RoundingMode.HALF_UP);
                break;
            }
            default: {
                result = BigDecimal.ZERO;
            }
        }
        return result;
    }

    public static Date getNewDateAfterMinusDuration(Date date, BigDecimal value, String unit) {
        Date result;
        if (null == date || null == value) {
            return date;
        }
        LocalDateTime dateTime = WTCDateUtils.toLocalDateTime((Date)date);
        switch (unit) {
            case "min": {
                result = WTCDateUtils.toDate((LocalDateTime)dateTime.minusMinutes(value.longValue()));
                break;
            }
            case "h": {
                result = WTCDateUtils.toDate((LocalDateTime)dateTime.minusMinutes(value.multiply(BigDecimal.valueOf(60L)).longValue()));
                break;
            }
            default: {
                result = date;
            }
        }
        return result;
    }

    public static Date getNewDateAfterPlusDuration(Date date, BigDecimal value, String unit) {
        Date result;
        if (null == date || null == value) {
            return date;
        }
        LocalDateTime dateTime = WTCDateUtils.toLocalDateTime((Date)date);
        switch (unit) {
            case "min": {
                result = WTCDateUtils.toDate((LocalDateTime)dateTime.plusMinutes(value.longValue()));
                break;
            }
            case "h": {
                result = WTCDateUtils.toDate((LocalDateTime)dateTime.plusMinutes(value.multiply(BigDecimal.valueOf(60L)).longValue()));
                break;
            }
            default: {
                result = date;
            }
        }
        return result;
    }

    public static Object[] filterTimeBucket(Object[] timeAry, String conditionStr) {
        QFilter filter;
        if (timeAry == null || timeAry.length == 0 || StringUtils.isBlank((CharSequence)conditionStr)) {
            return timeAry;
        }
        Map[] timeBucketArrMap = (Map[])Arrays.stream(timeAry).map(time -> new HashMap((Map)time)).toArray(HashMap[]::new);
        try {
            filter = QFilter.of((String)conditionStr, (Object[])new Object[0]);
        }
        catch (Exception ex) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("\u51fd\u6570\u6761\u4ef6\u8868\u8fbe\u5f0f\u586b\u5199\u4e0d\u6b63\u786e,conditionStr={}", (Object)conditionStr);
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8fc7\u6ee4\u65f6\u95f4\u5bf9\u201d\u51fd\u6570\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f\u8f93\u5165\u53c2\u6570\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_01", (String)"wtc-wtp-common", (Object[])new Object[0]));
        }
        conditionStr = filter.toString();
        ArrayList<FilterModel> filterModelList = new ArrayList<FilterModel>(2);
        FormulaFuncUtil.genAllQFilterModel(filter, filterModelList);
        if (CollectionUtils.isEmpty(filterModelList)) {
            return timeAry;
        }
        HashMap ignoreUppercaseMap = new HashMap(16);
        Arrays.stream(timeBucketArrMap).forEach(map -> map.keySet().forEach(key -> ignoreUppercaseMap.put(key.toLowerCase(), key)));
        ArrayList<Map> filteredTimeBucketList = new ArrayList<Map>(20);
        for (Map map2 : timeBucketArrMap) {
            String resultExpress = conditionStr;
            for (FilterModel filterModel : filterModelList) {
                String property = filterModel.getProperty();
                String cp = filterModel.getCp();
                Object value = filterModel.getValue();
                String express = new QFilter(property, cp, value).toString();
                String key = (String)ignoreUppercaseMap.get(property.toLowerCase());
                if (WTCStringUtils.isEmpty((String)key)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8fc7\u6ee4\u65f6\u95f4\u5bf9\u201d\u51fd\u6570\u7684\u65f6\u95f4\u5bf9\u4e2d\u4e0d\u5305\u542b\u8fc7\u6ee4\u53c2\u6570\u201c%1$s\u201d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_14", (String)"wtc-wtp-common", (Object[])new Object[]{property}));
                }
                Object timeBucketValue = map2.get(key);
                if (cp.equalsIgnoreCase("=")) {
                    resultExpress = Objects.equals(timeBucketValue, value) ? resultExpress.replace(express, "1") : resultExpress.replace(express, "0");
                    continue;
                }
                if (cp.equalsIgnoreCase("!=")) {
                    resultExpress = !Objects.equals(timeBucketValue, value) ? resultExpress.replace(express, "1") : resultExpress.replace(express, "0");
                    continue;
                }
                if (cp.equalsIgnoreCase("like")) {
                    resultExpress = Objects.nonNull(timeBucketValue) && timeBucketValue instanceof String && Objects.nonNull(value) && ((String)timeBucketValue).contains((String)value) ? resultExpress.replace(express, "1") : resultExpress.replace(express, "0");
                    continue;
                }
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8fc7\u6ee4\u65f6\u95f4\u5bf9\u201d\u51fd\u6570\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f\u8f93\u5165\u53c2\u6570\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_01", (String)"wtc-wtp-common", (Object[])new Object[0]));
            }
            if (resultExpress.contains("=")) {
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u8fc7\u6ee4\u65f6\u95f4\u5bf9\u201d\u51fd\u6570\u7684\u6761\u4ef6\u8868\u8fbe\u5f0f\u8f93\u5165\u53c2\u6570\u586b\u5199\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_01", (String)"wtc-wtp-common", (Object[])new Object[0]));
            }
            resultExpress = resultExpress.replaceAll("and", "&");
            resultExpress = resultExpress.replaceAll("AND", "&");
            resultExpress = resultExpress.replaceAll("or", "|");
            boolean result = DateRangeServiceImpl.get((String)(resultExpress = resultExpress.replaceAll("OR", "|")));
            if (!result) continue;
            filteredTimeBucketList.add(map2);
        }
        return filteredTimeBucketList.toArray();
    }

    public static BigDecimal timeAryToDuration(Object[] timeAry, String unit) {
        BigDecimal duration = BigDecimal.ZERO;
        if (timeAry == null || timeAry.length == 0) {
            LOG.info("FormulaFuncUtil.timeAryToDuration timeAry is empty");
            return duration;
        }
        if (StringUtils.isBlank((CharSequence)unit)) {
            LOG.info("FormulaFuncUtil.timeAryToDuration unit is empty");
            return duration;
        }
        HashMap[] timeBucketArrMap = new HashMap[timeAry.length];
        int k = 0;
        for (int i = 0; i < timeAry.length; ++i) {
            if (!(timeAry[i] instanceof Map)) {
                LOG.info("\u201c\u65f6\u95f4\u5bf9\u8f6c\u65f6\u957f\u201d\u51fd\u6570\u7684\u65f6\u95f4\u5bf9\u6570\u7ec4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002");
                throw new KDBizException(ResManager.loadKDString((String)"\u201c\u65f6\u95f4\u5bf9\u8f6c\u65f6\u957f\u201d\u51fd\u6570\u7684\u65f6\u95f4\u5bf9\u6570\u7ec4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_04", (String)"wtc-wtp-common", (Object[])new Object[0]));
            }
            timeBucketArrMap[k++] = (Map)timeAry[i];
        }
        for (HashMap map : timeBucketArrMap) {
            Date startTime = (Date)map.get("startTime");
            Date endTime = (Date)map.get("endTime");
            Object lengthOfTime = map.get("lengthOfTime");
            if (startTime == null || endTime == null) {
                if (lengthOfTime == null) continue;
                BigDecimal lengthOfMinutes = ((BigDecimal)lengthOfTime).divide(BigDecimal.valueOf(60L), 6, RoundingMode.HALF_UP);
                duration = duration.add(lengthOfMinutes);
                continue;
            }
            LocalDateTime startLocalDateTime = WTCDateUtils.toLocalDateTime((Date)startTime);
            LocalDateTime endLocalDateTime = WTCDateUtils.toLocalDateTime((Date)endTime);
            long diffInMin = ChronoUnit.MINUTES.between(startLocalDateTime, endLocalDateTime);
            duration = duration.add(BigDecimal.valueOf(diffInMin));
        }
        switch (unit) {
            case "min": {
                break;
            }
            case "h": {
                duration = duration.divide(BigDecimal.valueOf(60L), 6, RoundingMode.HALF_UP);
                break;
            }
            default: {
                duration = BigDecimal.ZERO;
            }
        }
        return duration;
    }

    public static Object[] removeTimeAry(Object[] timeAry, Integer index) {
        if (index == null || index < 0) {
            LOG.info("FormulaFuncUtil.removeTimeAry  index is error");
            return timeAry;
        }
        if (timeAry == null || timeAry.length == 0 || index >= timeAry.length) {
            LOG.info("FormulaFuncUtil.removeTimeAry  timeAry is empty");
            return timeAry;
        }
        Object[] newTimeArr = new Object[timeAry.length - 1];
        int k = 0;
        for (int i = 0; i < timeAry.length; ++i) {
            if (i == index) continue;
            newTimeArr[k++] = timeAry[i];
        }
        return newTimeArr;
    }

    public static String getTimeAryInfo(Object[] timeAry, Integer index, String key) {
        if (index == null || index < 0) {
            LOG.info("FormulaFuncUtil.getTimeAryInfo  index is error");
            return null;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            LOG.info("FormulaFuncUtil.getTimeAryInfo  key is empty");
            return null;
        }
        if (timeAry == null || timeAry.length == 0 || index >= timeAry.length) {
            LOG.info("FormulaFuncUtil.removeTimeAry  timeAry is empty");
            return null;
        }
        Object object = timeAry[index];
        if (!(object instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u83b7\u53d6\u65f6\u95f4\u5bf9\u4fe1\u606f\u201d\u51fd\u6570\u7684\u65f6\u95f4\u5bf9\u6570\u7ec4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_08", (String)"wtc-wtp-common", (Object[])new Object[0]));
        }
        Map map = (Map)object;
        Object result = map.get(key);
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"startTime", "endTime"})) {
            Date date = (Date)result;
            return WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd HH:mm:ss");
        }
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"shiftDate"})) {
            Date date = (Date)result;
            return WTCDateUtils.date2Str((Date)date, (String)"yyyy-MM-dd");
        }
        return result != null ? result.toString() : null;
    }

    public static Object[] updateTimeAry(Object[] timeAry, Integer index, String key, String value) {
        if (index == null || index < 0) {
            LOG.info("FormulaFuncUtil.updateTimeAry  index is error");
            return timeAry;
        }
        if (StringUtils.isBlank((CharSequence)key)) {
            LOG.info("FormulaFuncUtil.updateTimeAry  key is empty");
            return timeAry;
        }
        if (timeAry == null || timeAry.length == 0 || index >= timeAry.length) {
            LOG.info("FormulaFuncUtil.updateTimeAry  timeAry is empty");
            return null;
        }
        Object object = timeAry[index];
        if (!(object instanceof Map)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u4fee\u6539\u65f6\u95f4\u5bf9\u4fe1\u606f\u201d\u51fd\u6570\u7684\u65f6\u95f4\u5bf9\u6570\u7ec4\u6570\u636e\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_11", (String)"wtc-wtp-common", (Object[])new Object[0]));
        }
        Map map = (Map)object;
        if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"startTime", "endTime"})) {
            Date date = WTCDateUtils.str2Date((String)value, (String)"yyyy-MM-dd HH:mm:ss");
            map.put(key, date);
        } else if (StringUtils.equalsAny((CharSequence)key, (CharSequence[])new CharSequence[]{"shiftDate"})) {
            Date date = WTCDateUtils.str2Date((String)value, (String)"yyyy-MM-dd");
            map.put(key, date);
        } else {
            map.put(key, value);
        }
        timeAry[index.intValue()] = map;
        return timeAry;
    }

    private static void genAllQFilterModel(QFilter qFilter, List<FilterModel> filterModelList) {
        String property = qFilter.getProperty();
        String cp = qFilter.getCP();
        Object value = qFilter.getValue();
        FilterModel filterModel = new FilterModel(property, cp, value);
        filterModelList.add(filterModel);
        List filterNests = qFilter.getNests(false);
        if (CollectionUtils.isEmpty(filterModelList)) {
            return;
        }
        for (QFilter.QFilterNest nest : filterNests) {
            QFilter filter = nest.getFilter();
            FormulaFuncUtil.genAllQFilterModel(filter, filterModelList);
        }
    }

    public static Object[] getElasticSimulateShift(Date startTime, Date endTime, BigDecimal maxEarlyArrivalTime, BigDecimal maxBeLateTime, Object[] timeAry, Object[] otApplyInfo, Object[] vaApplyInfo, Object[] tpApplyInfo, BigDecimal condition) {
        boolean isConditionEmpty;
        boolean isStartTimeEmpty = startTime == null;
        boolean isEndTimeEmpty = endTime == null;
        boolean isMaxEarlyArrivalTimeEmpty = maxEarlyArrivalTime == null || maxEarlyArrivalTime.compareTo(BigDecimal.ZERO) < 0;
        boolean isMaxBeLateTimeEmpty = maxBeLateTime == null || maxBeLateTime.compareTo(BigDecimal.ZERO) < 0;
        boolean isTimeAryEmpty = timeAry == null || timeAry.length == 0;
        boolean bl = isConditionEmpty = condition == null || BigDecimal.valueOf(2L).compareTo(condition) != 0 && BigDecimal.ONE.compareTo(condition) != 0 && BigDecimal.ZERO.compareTo(condition) != 0;
        if (isStartTimeEmpty || isEndTimeEmpty || isMaxEarlyArrivalTimeEmpty || isMaxBeLateTimeEmpty || isTimeAryEmpty || isConditionEmpty) {
            LOG.info("FormulaFuncUtil.getElasticSimulateShift  startTime:{} ,endTime:{} ,maxEarlyArrivalTime:{},maxBeLateTime:{}, timeAry:{}, condition:{}", new Object[]{isStartTimeEmpty, isEndTimeEmpty, isMaxEarlyArrivalTimeEmpty, isMaxBeLateTimeEmpty, isTimeAryEmpty, condition});
            return null;
        }
        if (startTime.compareTo(endTime) > 0) {
            LOG.warn("FormulaFuncUtil.getElasticSimulateShift startTime > endTime");
            throw new KDBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u5927\u4e8e\u7ed3\u675f\u65f6\u95f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FormulaFuncUtil_13", (String)"wtc-wtp-common", (Object[])new Object[0]));
        }
        Object[] timeBucketArrMap = (Map[])Arrays.stream(timeAry).map(time -> new HashMap((Map)time)).toArray(HashMap[]::new);
        List vaStartTimeTypeList = Arrays.stream(timeBucketArrMap).map(timeBucketMap -> (String)timeBucketMap.get("leaveStartTimeType")).distinct().filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.toList());
        List tlStartTimeTypeList = Arrays.stream(timeBucketArrMap).map(timeBucketMap -> (String)timeBucketMap.get("travelStartTimeType")).distinct().filter(org.apache.commons.lang3.StringUtils::isNotEmpty).collect(Collectors.toList());
        if (vaStartTimeTypeList.contains("2") || tlStartTimeTypeList.contains("2")) {
            return new Object[]{startTime, endTime};
        }
        if (vaStartTimeTypeList.contains("0") || tlStartTimeTypeList.contains("0")) {
            return new Object[]{startTime, endTime};
        }
        if ((vaStartTimeTypeList.contains("1") || tlStartTimeTypeList.contains("1")) && FormulaFuncUtil.halfSecondDayAndWithoutOtherBusiness(timeBucketArrMap)) {
            return new Object[]{startTime, endTime};
        }
        LocalDateTime localStartTime = WTCDateUtils.toLocalDateTime((Date)startTime);
        LocalDateTime localEndTime = WTCDateUtils.toLocalDateTime((Date)endTime);
        LocalDateTime earliestStartTime = localStartTime.plusMinutes(-maxEarlyArrivalTime.longValue());
        LocalDateTime latestStartTime = localStartTime.plusMinutes(maxBeLateTime.longValue());
        LocalDateTime earliestEndTime = localEndTime.plusMinutes(-maxEarlyArrivalTime.longValue());
        LocalDateTime latestEndTime = localEndTime.plusMinutes(maxBeLateTime.longValue());
        Date busiEarliestStartTime = null;
        Date shiftOwnDate = WTCCollectionIndexUtil.getEleFromArr((Object[])timeBucketArrMap, (int)0).isPresent() ? (Date)((Map)WTCCollectionIndexUtil.getEleFromArr((Object[])timeBucketArrMap, (int)0).get()).get("shiftDate") : null;
        Date vaEarliestStartTime = FormulaFuncUtil.getBillEarliestStartTime(vaApplyInfo, shiftOwnDate, true);
        Date tpEarliestStartTime = FormulaFuncUtil.getBillEarliestStartTime(tpApplyInfo, shiftOwnDate, true);
        Date effCardEarliestStartTime = FormulaFuncUtil.getBillEarliestStartTime(timeAry, null, false);
        if (CONDITION_ZERO.compareTo(condition) == 0) {
            busiEarliestStartTime = FormulaFuncUtil.getEarliestDateTime(effCardEarliestStartTime, vaEarliestStartTime, tpEarliestStartTime);
        } else if (CONDITION_ONE.compareTo(condition) == 0) {
            busiEarliestStartTime = FormulaFuncUtil.getEarliestDateTime(effCardEarliestStartTime);
        } else if (CONDITION_TWO.compareTo(condition) == 0) {
            busiEarliestStartTime = FormulaFuncUtil.getEarliestDateTime(effCardEarliestStartTime, vaEarliestStartTime);
        }
        Object[] shiftDate = new Date[2];
        if (busiEarliestStartTime == null) {
            shiftDate[0] = startTime;
            shiftDate[1] = endTime;
            return shiftDate;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("FormulaFuncUtil.getElasticSimulateShift busiEarliestStartTime:{}", (Object)busiEarliestStartTime);
        }
        Duration duration = Duration.between(localStartTime, WTCDateUtils.toLocalDateTime((Date)busiEarliestStartTime));
        long diffMinutes = Math.abs(duration.toMinutes());
        if (busiEarliestStartTime.compareTo(WTCDateUtils.toDate((LocalDateTime)earliestStartTime)) < 0) {
            shiftDate[0] = WTCDateUtils.toDate((LocalDateTime)earliestStartTime);
            shiftDate[1] = WTCDateUtils.toDate((LocalDateTime)earliestEndTime);
        } else if (busiEarliestStartTime.compareTo(WTCDateUtils.toDate((LocalDateTime)earliestStartTime)) >= 0 && busiEarliestStartTime.compareTo(startTime) <= 0) {
            shiftDate[0] = busiEarliestStartTime;
            shiftDate[1] = WTCDateUtils.toDate((LocalDateTime)localEndTime.plusMinutes(-diffMinutes));
        } else if (startTime.compareTo(busiEarliestStartTime) < 0 && busiEarliestStartTime.compareTo(WTCDateUtils.toDate((LocalDateTime)latestStartTime)) <= 0) {
            shiftDate[0] = busiEarliestStartTime;
            shiftDate[1] = WTCDateUtils.toDate((LocalDateTime)localEndTime.plusMinutes(diffMinutes));
        } else if (busiEarliestStartTime.compareTo(WTCDateUtils.toDate((LocalDateTime)latestStartTime)) > 0) {
            shiftDate[0] = WTCDateUtils.toDate((LocalDateTime)latestStartTime);
            shiftDate[1] = WTCDateUtils.toDate((LocalDateTime)latestEndTime);
        }
        return shiftDate;
    }

    private static boolean halfSecondDayAndWithoutOtherBusiness(Map<String, Object>[] timeBucketArrMap) {
        if (timeBucketArrMap == null || timeBucketArrMap.length == 0) {
            return false;
        }
        List list = Arrays.stream(timeBucketArrMap).filter(map -> !"1".equalsIgnoreCase((String)map.get("leaveStartTimeType"))).filter(map -> !"1".equals((String)map.get("travelStartTimeType"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(list)) {
            return true;
        }
        List existNormalCardTimeBucketList = list.stream().filter(map -> FormulaKDString.getBillTagForNormalCard().equals(map.get("exceptionTag"))).collect(Collectors.toList());
        List existBillTimeBucketList = list.stream().filter(map -> !"0".equals(map.get("billTagCode"))).collect(Collectors.toList());
        return CollectionUtils.isEmpty(existNormalCardTimeBucketList) && CollectionUtils.isEmpty(existBillTimeBucketList);
    }

    private static Date getEarliestDateTime(Date ... dates) {
        if (dates == null || dates.length == 0) {
            return null;
        }
        List dateList = Arrays.stream(dates).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dateList)) {
            return null;
        }
        return WTCCollectionIndexUtil.getEleFromList(dateList, (int)0).isPresent() ? (Date)WTCCollectionIndexUtil.getEleFromList(dateList, (int)0).get() : null;
    }

    private static Date getBillEarliestStartTime(Object[] arr, Date shiftOwnDate, boolean isBill) {
        if (arr == null || arr.length == 0) {
            return null;
        }
        Map[] arrMap = (Map[])Arrays.stream(arr).map(time -> new HashMap((Map)time)).toArray(HashMap[]::new);
        List dateList = isBill ? (shiftOwnDate != null ? Arrays.stream(arrMap).filter(map -> map.get("startTime") != null).map(map -> (Date)map.get("startTime")).filter(Objects::nonNull).filter(date -> WTCDateUtils.getZeroDate((Date)date).compareTo(WTCDateUtils.getZeroDate((Date)shiftOwnDate)) == 0).sorted().collect(Collectors.toList()) : Arrays.stream(arrMap).filter(map -> map.get("startTime") != null).map(map -> (Date)map.get("startTime")).filter(Objects::nonNull).sorted().collect(Collectors.toList())) : Arrays.stream(arrMap).filter(map -> map.get("startTimeSource") != null && map.get("startTime") != null).filter(map -> FormulaKDString.getEffCardKDString().equals((String)map.get("startTimeSource"))).map(map -> (Date)map.get("startTime")).filter(Objects::nonNull).sorted().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(dateList)) {
            return null;
        }
        return WTCCollectionIndexUtil.getEleFromList(dateList, (int)0).isPresent() ? (Date)WTCCollectionIndexUtil.getEleFromList(dateList, (int)0).get() : null;
    }

    public static BigDecimal strToNum(String text) {
        BigDecimal result;
        if (WTCStringUtils.isEmpty((String)text)) {
            LOG.info("FormulaFuncUtil.strToNum  text is empty");
            return BigDecimal.ZERO;
        }
        try {
            result = new BigDecimal(text);
        }
        catch (NumberFormatException ex) {
            LOG.warn("FormulaFuncUtil.strToNum NumberFormatException text={}", (Object)text);
            throw new KDBizException(FormulaKDString.getNumberFormatExceptionMsg());
        }
        return result;
    }

    public static String logMsg(String key, Object content) {
        if (content instanceof Date) {
            content = WTCDateUtils.date2Str((Date)((Date)content), (String)"yyyy-MM-dd HH:mm:ss");
        } else if (content instanceof Object[]) {
            content = JSON.toJSONStringWithDateFormat((Object)content, (String)"yyyy-MM-dd HH:mm:ss", (SerializerFeature[])new SerializerFeature[0]);
        }
        LOG.info("FormulaFuncUtil.logMsg key={} : content={}", (Object)key, content);
        return "true";
    }
}

