/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtp.utils;

import java.util.Date;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.wtc.wtbs.common.enums.ShiftTimeBucketPropertyEnum;
import kd.wtc.wtbs.common.enums.TimeBucketPositionEnum;
import kd.wtc.wtbs.common.util.Tuple;
import kd.wtc.wtp.utils.FlxTimeBucketUtils;
import kd.wtc.wtp.utils.PunchCardTagEnum;

class ShiftInfo {
    private Log LOG = LogFactory.getLog(ShiftInfo.class);
    private Date flxShiftStart;
    private Date flxShiftEnd;
    private Date effectiveStartCard;
    private Date effectiveEndtCard;
    private Date restStart = null;
    private Date restEnd = null;
    private Date shiftDate = null;

    Tuple<ShiftTimeBucketPropertyEnum, TimeBucketPositionEnum> tbAttributeTag(Map<String, Object> map) {
        Date start = FlxTimeBucketUtils.getValue(map, "startTime", Date.class);
        Date end = FlxTimeBucketUtils.getValue(map, "endTime", Date.class);
        String tbAttributeCode = FlxTimeBucketUtils.getValue(map, "timeBucketAttributeCode", String.class);
        if (start == null || end == null) {
            return new Tuple((Object)ShiftTimeBucketPropertyEnum.UNKNOWN, (Object)TimeBucketPositionEnum.UNKNOWN);
        }
        if (this.isRestTime(start, end)) {
            return new Tuple((Object)ShiftTimeBucketPropertyEnum.REST, (Object)TimeBucketPositionEnum.IN_REST);
        }
        if (end.compareTo(this.flxShiftStart) <= 0) {
            return new Tuple((Object)ShiftTimeBucketPropertyEnum.BEFORE_SHIFT, (Object)TimeBucketPositionEnum.BEFORE_SHIFT);
        }
        if (start.compareTo(this.flxShiftStart) >= 0 && end.compareTo(this.flxShiftEnd) <= 0) {
            if (ShiftTimeBucketPropertyEnum.REST.code.equals(tbAttributeCode)) {
                return new Tuple((Object)ShiftTimeBucketPropertyEnum.REST, (Object)TimeBucketPositionEnum.IN_REST);
            }
            if (ShiftTimeBucketPropertyEnum.ATT_OT.code.equals(tbAttributeCode)) {
                return new Tuple((Object)ShiftTimeBucketPropertyEnum.ATT_OT, (Object)TimeBucketPositionEnum.IN_SHIFT);
            }
            if (ShiftTimeBucketPropertyEnum.CORE_ATT.code.equals(tbAttributeCode)) {
                return new Tuple((Object)ShiftTimeBucketPropertyEnum.CORE_ATT, (Object)TimeBucketPositionEnum.IN_SHIFT);
            }
            return new Tuple((Object)ShiftTimeBucketPropertyEnum.ATTENDANCE, (Object)TimeBucketPositionEnum.IN_SHIFT);
        }
        if (this.flxShiftEnd.compareTo(start) <= 0) {
            return new Tuple((Object)ShiftTimeBucketPropertyEnum.AFTER_SHIFT, (Object)TimeBucketPositionEnum.AFTER_SHIFT);
        }
        this.LOG.warn("tbAttributeTag warn start:{},end:{},this:{}", new Object[]{start, end, this.toString()});
        return new Tuple((Object)ShiftTimeBucketPropertyEnum.UNKNOWN, (Object)TimeBucketPositionEnum.UNKNOWN);
    }

    PunchCardTagEnum exTag(Map<String, Object> map) {
        Date start = FlxTimeBucketUtils.getValue(map, "startTime", Date.class);
        Date end = FlxTimeBucketUtils.getValue(map, "endTime", Date.class);
        String tbAttributeCode = FlxTimeBucketUtils.getValue(map, "timeBucketAttributeCode", String.class);
        if (start == null || end == null) {
            return PunchCardTagEnum.OTHER;
        }
        if (this.effectiveStartCard != null && this.effectiveEndtCard != null && start.compareTo(this.effectiveStartCard) >= 0 && end.compareTo(this.effectiveEndtCard) <= 0) {
            return PunchCardTagEnum.NORMAL;
        }
        if (this.isRestTime(start, end)) {
            return PunchCardTagEnum.NON_CARD;
        }
        if (this.effectiveStartCard != null && this.effectiveEndtCard != null) {
            if (this.flxShiftStart.compareTo(this.effectiveStartCard) < 0 && start.compareTo(this.flxShiftStart) >= 0 && end.compareTo(this.effectiveStartCard) <= 0) {
                return PunchCardTagEnum.BE_LATE;
            }
            if (this.effectiveEndtCard.compareTo(this.flxShiftEnd) < 0 && start.compareTo(this.effectiveEndtCard) >= 0 && end.compareTo(this.flxShiftEnd) <= 0) {
                return PunchCardTagEnum.LEAVE_EARLY;
            }
            if (start.compareTo(this.effectiveStartCard) >= 0 && end.compareTo(this.effectiveEndtCard) <= 0) {
                return PunchCardTagEnum.NORMAL;
            }
            return PunchCardTagEnum.NON_CARD;
        }
        if (this.effectiveStartCard == null && this.effectiveEndtCard == null) {
            if (this.flxShiftStart.compareTo(start) <= 0 && end.compareTo(this.flxShiftEnd) <= 0) {
                if (ShiftTimeBucketPropertyEnum.REST.code.equals(tbAttributeCode)) {
                    return PunchCardTagEnum.NON_CARD;
                }
                return PunchCardTagEnum.ABSENT;
            }
            if (end.compareTo(this.flxShiftStart) <= 0 || this.flxShiftEnd.compareTo(start) <= 0) {
                return PunchCardTagEnum.NON_CARD;
            }
        } else if (this.flxShiftStart.compareTo(start) <= 0 && end.compareTo(this.flxShiftEnd) <= 0) {
            if (ShiftTimeBucketPropertyEnum.REST.code.equals(tbAttributeCode)) {
                return PunchCardTagEnum.NON_CARD;
            }
            if (this.effectiveStartCard == null) {
                return PunchCardTagEnum.IN_ABSENT;
            }
            if (this.effectiveEndtCard == null) {
                return PunchCardTagEnum.OUT_ABSENT;
            }
        } else if (end.compareTo(this.flxShiftStart) <= 0 || this.flxShiftEnd.compareTo(start) <= 0) {
            return PunchCardTagEnum.NON_CARD;
        }
        this.LOG.warn("exTag warn start:{},end:{},this:{}", new Object[]{start, end, this.toString()});
        return PunchCardTagEnum.NON_CARD;
    }

    private boolean isRestTime(Date start, Date end) {
        if (this.restStart == null || this.restEnd == null || start == null || end == null) {
            return false;
        }
        return start.compareTo(this.restStart) >= 0 && end.compareTo(this.restEnd) <= 0;
    }

    public ShiftInfo(Date flxShiftStart, Date flxShiftEnd, Date effectiveStartCard, Date effectiveEndtCard, Date shiftDate) {
        this.flxShiftStart = flxShiftStart;
        this.flxShiftEnd = flxShiftEnd;
        this.effectiveStartCard = effectiveStartCard;
        this.effectiveEndtCard = effectiveEndtCard;
        this.shiftDate = shiftDate;
    }

    public Date getShiftDate() {
        return this.shiftDate;
    }

    public void setRestStart(Date restStart) {
        this.restStart = restStart;
    }

    public void setRestEnd(Date restEnd) {
        this.restEnd = restEnd;
    }

    public Date getEffectiveStartCard() {
        return this.effectiveStartCard;
    }

    public Date getEffectiveEndtCard() {
        return this.effectiveEndtCard;
    }

    public Date getFlxShiftStart() {
        return this.flxShiftStart;
    }

    public Date getFlxShiftEnd() {
        return this.flxShiftEnd;
    }

    public Date getRestStart() {
        return this.restStart;
    }

    public Date getRestEnd() {
        return this.restEnd;
    }

    public String toString() {
        return "ShiftInfo{flxShiftStart=" + this.flxShiftStart + ", flxShiftEnd=" + this.flxShiftEnd + ", effectiveStartCard=" + this.effectiveStartCard + ", effectiveEndtCard=" + this.effectiveEndtCard + ", restStart=" + this.restStart + ", restEnd=" + this.restEnd + '}';
    }
}

