/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpd.business.sign;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.KDDateUtils;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.wtc.wtbs.business.auth.WTCDataPermissionServiceImpl;
import kd.wtc.wtbs.common.model.sign.SignCardDTO;
import kd.wtc.wtbs.common.util.WTCStringUtils;
import kd.wtc.wtpd.common.sign.constants.SignCardConstants;
import kd.wtc.wtpd.common.sign.constants.SignCardKDString;

public class SignCardService
implements SignCardConstants {
    private static final Log LOG = LogFactory.getLog(SignCardService.class);

    public Map<Long, String> batchImportSignCards(List<SignCardDTO> signCards) {
        HashMap<Long, String> message = new HashMap<Long, String>(16);
        if (CollectionUtils.isEmpty(signCards)) {
            return message;
        }
        LOG.info("batchImportSignCards, requestSize:{}", (Object)signCards.size());
        HRBaseServiceHelper helper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] result = new DynamicObject[signCards.size()];
        int num = 0;
        Long zero = 0L;
        for (SignCardDTO signCard : signCards) {
            if (null == signCard || null == signCard.getSignDateTime()) {
                LOG.info("batchImportSignCards, signPoint is not set");
                message.put(null == signCard ? zero : signCard.getId(), "signPoint is not set");
                continue;
            }
            DynamicObject data = new DynamicObject((DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"wtpd_signcard"));
            if (null == signCard.getAttPersonId()) {
                LOG.info("batchImportSignCards, attPersonId is not set");
                message.put(signCard.getId(), "attPersonId is not set");
                continue;
            }
            data.set("attperson", (Object)signCard.getAttPersonId());
            data.set("attfilebo", (Object)signCard.getAttFileBoId());
            data.set("attfile", (Object)signCard.getAttFileId());
            data.set("org", (Object)signCard.getOrgId());
            data.set("attcard", (Object)signCard.getAttCard());
            data.set("signpoint", (Object)signCard.getSignDateTime());
            data.set("source", (Object)signCard.getSource());
            data.set("device", (Object)signCard.getDeviceId());
            data.set("status", (Object)"1");
            data.set("accesstag", (Object)signCard.getAccessTag());
            data.set("timezone", (Object)signCard.getTimeZoneId());
            LocalDateTime signPoint = signCard.getSignDateTime().toInstant().atZone(KDDateUtils.getSysTimeZone().toZoneId()).toLocalDateTime();
            LocalDateTime signPointUtc = signPoint.minusHours(signCard.getTimeDiff());
            data.set("signpointutc", (Object)Date.from(signPointUtc.atZone(KDDateUtils.getSysTimeZone().toZoneId()).toInstant()));
            data.set("presetbiz1", (Object)signCard.getPresetBiz1());
            data.set("presetbiz2", (Object)signCard.getPresetBiz2());
            result[num] = data;
            ++num;
        }
        helper.save(result);
        return message;
    }

    public void invalidSignCards(Set<Long> attFileBoIds) {
        if (HRCollUtil.isEmpty(attFileBoIds)) {
            LOG.info("invalidSignCards, request is empty");
            return;
        }
        LOG.info("invalidSignCards, requestSize:{}", (Object)attFileBoIds.size());
        HRBaseServiceHelper signCardServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] data = signCardServiceHelper.query("id,status,source,remark,modifytype", new QFilter[]{new QFilter("attfile.boid", "in", attFileBoIds)});
        HRBaseServiceHelper noteHisHelper = new HRBaseServiceHelper("wtpd_signnotehis");
        long currUserId = RequestContext.get().getCurrUserId();
        Date now = new Date();
        DynamicObject[] noteHisDys = new DynamicObject[data.length];
        String note = SignCardKDString.attFileInvalid();
        for (int i = 0; i < data.length; ++i) {
            DynamicObject row = data[i];
            row.set("status", (Object)"0");
            row.set("remark", (Object)note);
            row.set("modifytype", (Object)"0");
            DynamicObject noteHisDy = noteHisHelper.generateEmptyDynamicObject();
            noteHisDy.set("creator", (Object)currUserId);
            noteHisDy.set("createtime", (Object)now);
            noteHisDy.set("signcardid", (Object)row.getLong("id"));
            noteHisDy.set("remark", (Object)note);
            noteHisDy.set("type", (Object)"2");
            noteHisDys[i] = noteHisDy;
        }
        signCardServiceHelper.save(data);
        noteHisHelper.save(noteHisDys);
    }

    public List<DynamicObject> querySignCards(Set<Long> attFileBoIds, String selectProperties) {
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        QFilter qFilter = new QFilter("attfile.boid", "in", attFileBoIds);
        QFilter statusQFilter = new QFilter("status", "!=", (Object)"0");
        QFilter[] filters = new QFilter[]{qFilter, statusQFilter};
        if (WTCStringUtils.isEmpty((String)selectProperties)) {
            DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(filters);
            return Arrays.stream(dynamicObjects).collect(Collectors.toList());
        }
        DynamicObject[] data = hrBaseServiceHelper.query(selectProperties, filters);
        return Arrays.stream(data).collect(Collectors.toList());
    }

    public List<DynamicObject> getSignCards(Set<Long> attFileBoIds, Date startDate, Date endDate, boolean checkAuth, String selectProperties) {
        QFilter authFilter;
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        QFilter qFilter = new QFilter("attfile.boid", "in", attFileBoIds);
        QFilter statusQFilter = new QFilter("status", "!=", (Object)"0");
        if (checkAuth && null != (authFilter = WTCDataPermissionServiceImpl.getInstance().getDataRule(Long.valueOf(RequestContext.get().getCurrUserId()), "wtpm", "wtpd_signcard", "org", "47150e89000000ac", new HashMap(0)))) {
            qFilter = qFilter.and(authFilter);
        }
        if (null != startDate) {
            qFilter = qFilter.and(new QFilter("signpoint", ">=", (Object)startDate));
        }
        if (null != endDate) {
            qFilter = qFilter.and(new QFilter("signpoint", "<=", (Object)endDate));
        }
        QFilter[] filters = new QFilter[]{qFilter, statusQFilter};
        if (WTCStringUtils.isEmpty((String)selectProperties)) {
            DynamicObject[] dynamicObjects = hrBaseServiceHelper.loadDynamicObjectArray(filters);
            return Arrays.stream(dynamicObjects).collect(Collectors.toList());
        }
        DynamicObject[] data = hrBaseServiceHelper.query(selectProperties, filters);
        return Arrays.stream(data).collect(Collectors.toList());
    }
}

