/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpd.opplugin.web.sign;

import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.util.CollectionUtils;
import kd.hr.hbp.opplugin.web.HRDataBaseOp;
import kd.wtc.wtbs.business.auth.HRAuthUtil;
import kd.wtc.wtbs.business.util.attfilef7.AttFileF7Utils;
import kd.wtc.wtbs.business.web.file.schedule.AttFileScheduleServiceImpl;
import kd.wtc.wtbs.common.enums.AttFileScheduleEnum;
import kd.wtc.wtbs.common.model.attfile.AttFileScheduleQueryParam;
import kd.wtc.wtbs.common.util.WTCDateUtils;
import kd.wtc.wtbs.common.util.third.collect.Sets;
import kd.wtc.wtpd.common.sign.constants.SignCardConstants;
import kd.wtc.wtpd.opplugin.web.sign.validator.SignImportValidator;

public class SignCardImportOp
extends HRDataBaseOp
implements SignCardConstants {
    private static final String _ID = "_id";

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SignImportValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dataEntities = args.getDataEntities();
        List<Long> attFileBoIdList = Arrays.stream(dataEntities).map(item -> item.getLong("attfilebo.id")).collect(Collectors.toList());
        Map<Long, List<DynamicObject>> attCardMap = this.getAttCardListMap(attFileBoIdList);
        List attFileAuthList = AttFileF7Utils.getAttFileAuthList(attFileBoIdList);
        List attFileAuthMapList = HRAuthUtil.getAuthFieldByAttFileBatch((List)attFileAuthList);
        Map attFileAuthMap = attFileAuthMapList.stream().collect(Collectors.toMap(item -> item.get("attFileBoId"), Function.identity()));
        for (DynamicObject dataEntity : dataEntities) {
            long attFileBoId = dataEntity.getLong("attfilebo.id");
            if (ObjectUtils.isEmpty((Object)dataEntity.get("source"))) {
                dataEntity.set("source_id", (Object)SignCardConstants.SOURCE_IMPORT_ID);
            }
            Map attFileAuth = (Map)attFileAuthMap.get(attFileBoId);
            if (ObjectUtils.isEmpty((Object)dataEntity.get("org"))) {
                dataEntity.set("org_id", attFileAuth.get("org"));
            }
            dataEntity.set("attperson_id", attFileAuth.get("attPersonId"));
            dataEntity.set("attfile_id", attFileAuth.get("attFileId"));
            Date signDate = dataEntity.getDate("signpoint");
            dataEntity.set("attcard", (Object)this.getAttCard(attCardMap, attFileBoId, signDate));
            dataEntity.set("signpointutc", (Object)this.getZeroTime(signDate, dataEntity.getDynamicObject("timezone")));
            dataEntity.set("status", (Object)"1");
        }
    }

    private String getAttCard(Map<Long, List<DynamicObject>> attCardMap, long attFileBoId, Date signDate) {
        Optional<DynamicObject> first;
        String card = "";
        List<DynamicObject> attCardList = attCardMap.get(attFileBoId);
        if (!CollectionUtils.isEmpty(attCardList) && (first = attCardList.stream().filter(item -> item.getDate("bsed").compareTo(signDate) <= 0 && item.getDate("bsled").compareTo(signDate) >= 0).findFirst()).isPresent()) {
            card = first.get().getString("card");
        }
        return card;
    }

    private Map<Long, List<DynamicObject>> getAttCardListMap(List<Long> attFileBoIdList) {
        AttFileScheduleQueryParam attFileScheduleQueryParam = new AttFileScheduleQueryParam();
        attFileScheduleQueryParam.setFileBoIdSet((Set)Sets.newHashSet(attFileBoIdList));
        attFileScheduleQueryParam.setLoad(Boolean.TRUE);
        return AttFileScheduleServiceImpl.getInstance().queryAttFileSchedule(AttFileScheduleEnum.CARD, attFileScheduleQueryParam);
    }

    private Date getZeroTime(Date date, DynamicObject timezone) {
        if (date == null) {
            return null;
        }
        LocalDateTime signPointLocal = WTCDateUtils.toLocalDateTime((Date)date);
        int timeDif = timezone.getInt("timedif");
        LocalDateTime localDateTime = signPointLocal.plusHours(timeDif * -1);
        return WTCDateUtils.toDate((LocalDateTime)localDateTime);
    }
}

