/*
 * Decompiled with CFR 0.152.
 */
package kd.wtc.wtpd.opplugin.web.sign.validator;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRCollUtil;
import kd.hr.hbp.opplugin.validator.HRDataBaseValidator;
import kd.wtc.wtbs.business.web.file.AttFileQueryServiceImpl;
import kd.wtc.wtbs.common.model.attfile.AttFileQueryParam;
import kd.wtc.wtpd.common.sign.constants.SignCardConstants;
import kd.wtc.wtpd.common.sign.constants.SignCardKDString;

public class SignCardEffectValidator
extends HRDataBaseValidator
implements SignCardConstants {
    private static final Log LOG = LogFactory.getLog(SignCardEffectValidator.class);

    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        LOG.info("SignCardEffectValidator size:{}", (Object)dataEntities.length);
        if (dataEntities.length == 1) {
            return;
        }
        HashSet<Long> ids = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            ids.add(dataEntity.getDataEntity().getLong("id"));
        }
        HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper("wtpd_signcard");
        DynamicObject[] signCardDys = hrBaseServiceHelper.query("id,attfilebo.id", new QFilter[]{new QFilter("id", "in", ids)});
        HashMap<Long, Long> idMap = new HashMap<Long, Long>(dataEntities.length);
        HashSet<Long> attFileBoIds = new HashSet<Long>(dataEntities.length);
        for (DynamicObject signCardDy : signCardDys) {
            idMap.put(signCardDy.getLong("id"), signCardDy.getLong("attfilebo.id"));
            attFileBoIds.add(signCardDy.getLong("attfilebo.id"));
        }
        AttFileQueryParam queryParam = new AttFileQueryParam();
        queryParam.setAuthCheck(Boolean.FALSE);
        queryParam.setProperties("name,id");
        queryParam.setSetBoIds(attFileBoIds);
        queryParam.setAttStatus(null);
        HashSet<String> status = new HashSet<String>(2);
        status.add("-1");
        queryParam.setUsableStatus(status);
        queryParam.setBeCurrent(Boolean.valueOf(true));
        List attFileList = AttFileQueryServiceImpl.getInstance().queryAttFiles(queryParam);
        if (HRCollUtil.isEmpty((Collection)attFileList)) {
            return;
        }
        Map<Long, List<DynamicObject>> discardAttFileMap = attFileList.stream().collect(Collectors.groupingBy(file -> file.getLong("id")));
        Set discardAttFileBoIds = attFileList.stream().map(file -> file.getLong("id")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : dataEntities) {
            long id = dataEntity.getDataEntity().getLong("id");
            long attFileBoId = (Long)idMap.get(id);
            if (!discardAttFileBoIds.contains(attFileBoId)) continue;
            String name = discardAttFileMap.get(attFileBoId).get(0).getString("name");
            this.addErrorMessage(dataEntity, SignCardKDString.attFileDisCard((String)name));
        }
    }
}

